package com.ejianc.business.control.service;

import com.ejianc.business.control.vo.ControlVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.control.bean.ControlEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 分包招标控制价审核表
 * 
 * @author generator
 * 
 */
public interface IControlService extends IBaseService<ControlEntity> {

    ControlVO saveOrUpdate(ControlVO saveOrUpdateVO, Boolean isControl);

    ParamsCheckVO checkParams(ControlVO vo, CommonResponse<ParamsCheckVO> response,Object o);

    ControlVO queryDetail(Long id);

    CommonResponse<Object> importData(Integer type, String tabKey,HttpServletRequest request, HttpServletResponse response);

    CommonResponse<Object> importOtherData(Integer type, String tabKey, HttpServletRequest request, HttpServletResponse response);

    CommonResponse<Object> importEquipmentData(Integer type, String tabKey, HttpServletRequest request, HttpServletResponse response);

    String getLinkUrl(Long id, Integer type);

    ExecutionVO targetCost(ControlVO controlVO, String linkUrl, Integer subType, String billTypeCode);
}
