package com.ejianc.business.prosub.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ContractFilingTypeEnum {

    /**
     * 分包合同补充协议
     */
    分包合同补充协议("contract_supplement", "分包合同补充协议"),
    /**
     * 分包合同变更
     */
    分包合同变更("contract_change", "分包合同变更"),
    /**
     * 分包合同月度结算
     */
    分包合同月度结算("contract_month", "分包合同月度结算"),
    /**
     * 分包合同节点结算
     */
    分包合同节点结算("contract_node", "分包合同节点结算"),
    /**
     * 分包合同最终结算
     */
    分包合同最终结算("contract_final", "分包合同最终结算");


    ContractFilingTypeEnum(String typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    //合同烈性
    private String typeCode;
    //合同业务类型名称
    private String typeName;
    private static Map<String, ContractFilingTypeEnum> enumMap = new HashMap<>();


    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    static {
        enumMap = EnumSet.allOf(ContractFilingTypeEnum.class).stream().collect(Collectors.toMap(ContractFilingTypeEnum::getTypeCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ContractFilingTypeEnum getByCode(String code) {
        return enumMap.get(code);
    }

    public static ContractFilingTypeEnum getEnumByCode(String typeCode) {
        return enumMap.get(typeCode);
    }
}
