package com.ejianc.business.process.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 零工申请 用工明细实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_oldjob_application_detail")
public class ApplicationDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     *  零工申请id
     */
    @TableField(value="application_id")
    private Long applicationId;
    /**
     * 合同名称
     */
    @TableField(value="contract_name")
    private String contractName;
    /**
     * 合同id
     */
    @TableField(value="contract_id")
    private Long contractId;
    /**
     * 合同编码
     */
    @TableField(value="contract_code")
    private String contractCode;
    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    @TableField(value="contract_type")
    private Integer contractType;
    /**
     * 合同类型：0-主合同 1-补充协议
     */
    @TableField(value="supplement_flag")
    private Integer supplementFlag;
    /**
     * 清单名称
     */
    @TableField(value="list_name")
    private String listName;
    /**
     * 清单id
     */
    @TableField(value="list_id")
    private Long listId;
    /**
     * 清单来源 0- 选择，1-新增
     */
    @TableField(value="list_type")
    private Integer listType;
    /**
     * 清单来源id 合同id
     */
    @TableField(value="source_id")
    private Long sourceId;
    /**
     *  零工申请工程量
     */
    @TableField(value="work_num")
    private BigDecimal workNum;
    /**
     * 合同工程量
     */
    @TableField(value = "contract_work_num")
    private BigDecimal contractWorkNum;

    /**
     *  单价
     */
    @TableField(value="price")
    private BigDecimal price;
    /**
     *  单价(含税)
     */
    @TableField(value="tax_price")
    private BigDecimal taxPrice;
    /**
     *  税率
     */
    @TableField(value="list_tax_rate")
    private BigDecimal listTaxRate;
    /**
     *  总额 自动计算 不支持修改(含税)
     */
    @TableField(value="list_tax_mny")
    private BigDecimal listTaxMny;
    /**
     *  总额 自动计算 不支持修改
     */
    @TableField(value="list_mny")
    private BigDecimal listMny;
    /**
     *  税额
     */
    @TableField(value="list_tax")
    private BigDecimal listTax;


    /**
     * 工作内容
     */
    @TableField("detail_work_content")
    private String detailWorkContent;

    /**
     * 计量规则
     */
    @TableField("detail_measurement_rules")
    private String detailMeasurementRules;

    /**
     * 单位
     */
    @TableField("detail_unit")
    private String detailUnit;
    /**
     * 备注
     */
    @TableField("detail_memo")
    private String detailMemo;

    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }

    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }

    public void setListTax(BigDecimal listTax) {
        this.listTax = listTax;
    }

    public String getDetailWorkContent() {
        return detailWorkContent;
    }

    public void setDetailWorkContent(String detailWorkContent) {
        this.detailWorkContent = detailWorkContent;
    }

    public String getDetailMeasurementRules() {
        return detailMeasurementRules;
    }

    public void setDetailMeasurementRules(String detailMeasurementRules) {
        this.detailMeasurementRules = detailMeasurementRules;
    }

    public BigDecimal getContractWorkNum() {
        return contractWorkNum;
    }

    public void setContractWorkNum(BigDecimal contractWorkNum) {
        this.contractWorkNum = contractWorkNum;
    }

    public Long getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(Long applicationId) {
        this.applicationId = applicationId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public String getListName() {
        return listName;
    }

    public void setListName(String listName) {
        this.listName = listName;
    }
    public Long getListId() {
        return listId;
    }

    public void setListId(Long listId) {
        this.listId = listId;
    }
    public Integer getListType() {
        return listType;
    }

    public void setListType(Integer listType) {
        this.listType = listType;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public BigDecimal getWorkNum() {
        return workNum;
    }

    public void setWorkNum(BigDecimal workNum) {
        this.workNum = workNum;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    public BigDecimal getListTaxRate() {
        return listTaxRate;
    }

    public void setListTaxRate(BigDecimal listTaxRate) {
        this.listTaxRate = listTaxRate;
    }
    public BigDecimal getListTaxMny() {
        return listTaxMny;
    }

    public void setListTaxMny(BigDecimal listTaxMny) {
        this.listTaxMny = listTaxMny;
    }
    public BigDecimal getListMny() {
        return listMny;
    }

    public void setListMny(BigDecimal listMny) {
        this.listMny = listMny;
    }
    public BigDecimal getListTax() {
        return listTax;
    }

}
