package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.plan.bean.PlanDetailChangeHisEntity;
import com.ejianc.business.plan.service.IPlanDetailChangeHisService;
import com.ejianc.business.plan.vo.PlanChangeHisVO;
import com.ejianc.business.plan.vo.PlanDetailChangeHisVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.PlanChangeHisMapper;
import com.ejianc.business.plan.bean.PlanChangeHisEntity;
import com.ejianc.business.plan.service.IPlanChangeHisService;

import java.util.ArrayList;
import java.util.List;

/**
 * 分包总计划变更记录实体
 * 
 * @author generator
 * 
 */
@Service("planChangeHisService")
public class PlanChangeHisServiceImpl extends BaseServiceImpl<PlanChangeHisMapper, PlanChangeHisEntity> implements IPlanChangeHisService{

    @Autowired
    private IPlanDetailChangeHisService planDetailChangeHisService;

    @Override
    public PlanChangeHisVO queryDetail(Long id, boolean detailHasChildren) {
        LambdaQueryWrapper<PlanChangeHisEntity> lambda = Wrappers.<PlanChangeHisEntity>lambdaQuery();
        lambda.eq(PlanChangeHisEntity::getChangePlanId, id);
        PlanChangeHisEntity one = this.getOne(lambda);
        PlanChangeHisVO planChangeHisVO = BeanMapper.map(one, PlanChangeHisVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("planId", new Parameter(QueryParam.EQ, one.getId()));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<PlanDetailChangeHisEntity> detailEntityListDb = planDetailChangeHisService.queryList(queryParam, false);
        List<PlanDetailChangeHisEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(PlanDetailChangeHisEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                cdEntity.setRowState("add");
            }
            List<PlanDetailChangeHisVO> resultMapList = BeanMapper.mapList(detailEntityList, PlanDetailChangeHisVO.class);
            if(detailHasChildren){
                planChangeHisVO.setPlanDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }else {
                planChangeHisVO.setPlanDetailList(resultMapList);
            }
        } else {
            planChangeHisVO.setPlanDetailList(BeanMapper.mapList(detailEntityList, PlanDetailChangeHisVO.class));
        }

        return planChangeHisVO;
    }
}
