package com.ejianc.business.contract.relieve.controller.api;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contract.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.contract.relieve.service.IContractRelieveService;
import com.ejianc.business.contract.relieve.vo.ContractRelieveVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping
public class ContractRelieveApiController {

    @Autowired
    private IContractRelieveService service;


    @PostMapping(value = "/api/contractRelieve/updateFilingStatus")
    CommonResponse<ContractRelieveVO> updateFilingStatus(@RequestBody ContractRelieveVO vo) {
        LambdaUpdateWrapper<ContractRelieveEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(ContractRelieveEntity::getId, vo.getId());
        updateWrapper.set(ContractRelieveEntity::getFilingStatus, vo.getFilingStatus());//(1:是，0：否)
        service.update(updateWrapper);
        return CommonResponse.success("修改成功", vo);
    }
}
