package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.settle.service.ISettleSignatureService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class SettleSignatureController {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettleSignatureService service;


    @PostMapping(value = "/processSettleSignature/changeStatus")
    public CommonResponse<String> processChangeStatus(@RequestBody String objectStr) {
        return this.changeStatus(objectStr);
    }

    @PostMapping(value = "/nodeSettleSignature/changeStatus")
    public CommonResponse<String> nodeChangeStatus(@RequestBody String objectStr) {
        return this.changeStatus(objectStr);
    }

    @PostMapping(value = "/finishSettleSignature/changeStatus")
    public CommonResponse<String> finishChangeStatus(@RequestBody String objectStr) {
        return this.changeStatus(objectStr);
    }

    private CommonResponse<String> changeStatus(String objectStr) {
        if (StringUtils.isEmpty(objectStr)) {
            throw new BusinessException("签章流程返回对象为空，请检查！");
        }
        logger.info("签章流程返回对象--{}", objectStr);
        JSONObject object = (JSONObject) JSONObject.parse(objectStr);
        String billId = object.getString("billId");
        String status = object.getString("status");
        String refCode = object.getString("refCode");
        if (StringUtils.isEmpty(billId) || StringUtils.isEmpty(status) || StringUtils.isEmpty(refCode)) {
            return CommonResponse.error("参数异常，请检查相关参数！");
        }
        return service.changeSignatureStatus(Long.valueOf(billId), Integer.parseInt(status), refCode);
    }
}
