package com.ejianc.business.prosub.pricelib.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.prosub.pricelib.vo.PriceLibVO;
import com.ejianc.business.prosub.pricelib.vo.PriceTrendVo;
import com.ejianc.business.prosub.util.DateUtils;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.prosub.pricelib.bean.PriceContractEntity;
import com.ejianc.business.prosub.pricelib.service.IPriceContractService;
import com.ejianc.business.prosub.pricelib.vo.PriceContractVO;

/**
 * 分包价格库清单明细实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("priceContract")
public class PriceContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;

    @Autowired
    private IPriceContractService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PriceContractVO> saveOrUpdate(@RequestBody PriceContractVO saveOrUpdateVO) {
    	PriceContractEntity entity = BeanMapper.map(saveOrUpdateVO, PriceContractEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	PriceContractVO vo = BeanMapper.map(entity, PriceContractVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PriceContractVO> queryDetail(Long id) {
    	PriceContractEntity entity = service.selectById(id);
    	PriceContractVO vo = BeanMapper.map(entity, PriceContractVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PriceContractVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PriceContractVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PriceContractVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PriceContractVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PriceContractEntity> page = service.queryPage(param,false);
        IPage<PriceContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PriceContractVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        Map<String, Object> beans = new HashMap<>();

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        List<PriceContractEntity> page = service.queryList(param,false);
        List<PriceContractVO> vos = BeanMapper.mapList(page, PriceContractVO.class);

        beans.put("records", vos);
        String exportFileName = param.getParams().get("contractType").getValue().equals(0) ? "laborSubPriceLib-export.xlsx" : "proSubPriceLib-export.xlsx";
        ExcelExport.getInstance().export(exportFileName, beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPriceContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PriceContractVO>> refPriceContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PriceContractEntity> page = service.queryPage(param,false);
        IPage<PriceContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PriceContractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }




    /**
     * 查询列表
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @RequestMapping(value = "/queryPriceList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PriceLibVO>> queryPriceList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.queryPriceLibListByTime(param));
    }


    /**
     * 查询合同明细列表
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @RequestMapping(value = "/queryPriceContractList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PriceContractVO>> queryPriceContractList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询合同明细列表数据成功！", service.queryPriceContractListDetail(param));
    }


    /**
     * @param
     * @Description 劳务分包价格库参照参照
     * @Return void
     */
    @RequestMapping(value = "/refLaborPriceContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PriceLibVO>> refLaborPriceContractData(@RequestParam Integer pageNumber,
                                                          @RequestParam Integer pageSize,
                                                          String relyCondition,
                                                          String searchText,
                                                          String condition,
                                                          String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("contractType", new Parameter(QueryParam.EQ, 0));
        /** 租户隔离 */
        if (StringUtils.isNotEmpty(relyCondition)) {
            String innerCode = relyCondition.split("=")[1];
            param.getParams().put("docInnerCode", new Parameter(QueryParam.LIKE_RIGHT, innerCode));
        }
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("innerCode")) {
                param.getParams().put("docInnerCode", new Parameter(QueryParam.LIKE_RIGHT, _con.get("innerCode")));
            }
        }
        CommonResponse<List<PriceDepotParamSetDTO>> rsp = priceDepotParamSetApi
                .queryPriceDepotParamSetList(PrinceDepotEnum.劳务分包价格库.getCode());
        logger.info("查询价格库设置，查询结果：{}", JSONObject.toJSONString(rsp));
        if (!rsp.isSuccess()) {
            throw new BusinessException("查询价格库设置失败！" + rsp.getMsg());
        }
        // 日期统一，所以随便取一个日期间隔参数
        BigDecimal cycle = rsp.getData().get(0).getCycle();
        int c = cycle.intValue();
        Date endDate = DateUtils.formatDate(new Date(), DateUtils.YYYY_MM_DD);
        Date startDate = DateUtils.formatDate(DateUtils.calculationMonth(endDate, -c), DateUtils.YYYY_MM_DD);
        param.getParams().put("startDate", new Parameter(QueryParam.EQ, DateUtils.transformationDefaultDate(startDate)));
        param.getParams().put("endDate", new Parameter(QueryParam.EQ, DateUtils.transformationDefaultDate(endDate)));
        return CommonResponse.success("查询参照数据成功！", service.queryPriceLibListByTime(param));
    }


    /**
     * @param
     * @Description 专业分包价格库参照参照
     * @Return void
     */
    @RequestMapping(value = "/refProPriceContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PriceLibVO>> refProPriceContractData(@RequestParam Integer pageNumber,
                                                          @RequestParam Integer pageSize,
                                                          String relyCondition,
                                                          String searchText,
                                                          String condition,
                                                          String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("contractType", new Parameter(QueryParam.EQ, 1));
        /** 租户隔离 */
        if (StringUtils.isNotEmpty(relyCondition)) {
            String innerCode = relyCondition.split("=")[1];
            param.getParams().put("docInnerCode", new Parameter(QueryParam.LIKE_RIGHT, innerCode));
        }
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("innerCode")) {
                param.getParams().put("docInnerCode", new Parameter(QueryParam.LIKE_RIGHT, _con.get("innerCode")));
            }
        }
        CommonResponse<List<PriceDepotParamSetDTO>> rsp = priceDepotParamSetApi
                .queryPriceDepotParamSetList(PrinceDepotEnum.劳务分包价格库.getCode());
        logger.info("查询价格库设置，查询结果：{}", JSONObject.toJSONString(rsp));
        if (!rsp.isSuccess()) {
            throw new BusinessException("查询价格库设置失败！" + rsp.getMsg());
        }
        // 日期统一，所以随便取一个日期间隔参数
        BigDecimal cycle = rsp.getData().get(0).getCycle();
        int c = cycle.intValue();
        Date endDate = DateUtils.formatDate(new Date(), DateUtils.YYYY_MM_DD);
        Date startDate = DateUtils.formatDate(DateUtils.calculationMonth(endDate, -c), DateUtils.YYYY_MM_DD);
        param.getParams().put("startDate", new Parameter(QueryParam.EQ, DateUtils.transformationDefaultDate(startDate)));
        param.getParams().put("endDate", new Parameter(QueryParam.EQ, DateUtils.transformationDefaultDate(endDate)));
        return CommonResponse.success("查询参照数据成功！", service.queryPriceLibListByTime(param));
    }


    /**
     * @Description shelfGoods 定时处理价格库数据
     */
    @RequestMapping(value = "/initPriceContract", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> initPriceContract(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param);
        logger.info("获取到的参数JSON是：" + param + "----");
        service.savePriceContractByTiming(null);
        return CommonResponse.success("初始化处理成功");
    }


    /**
     * @Description shelfGoods 定时处理价格库数据
     */
    @RequestMapping(value = "/savePriceContractByTiming", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> savePriceContractByTiming(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param);
        logger.info("获取到的参数JSON是：" + param + "----");
        service.savePriceContractByTiming(new Date());
        return CommonResponse.success("定时任务处理成功");
    }

    /**
     * 查询列表
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @RequestMapping(value = "/queryPriceDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PriceLibVO> queryPriceDetail(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.queryPriceLibDetail(param));
    }


    /**
     * 查询合同价格趋势图数据
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @RequestMapping(value = "/queryPriceTrendContractList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<PriceTrendVo>> queryPriceTrendContractList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询合同价格趋势图数据！", service.queryPriceTrendContractList(param));
    }


    /**
     * 移除价格库合同明细
     *
     * @param vo 合同明细id
     * @return 移除结果
     */
    @RequestMapping(value = "/removePriceContractDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> removePriceContractDetail(@RequestBody PriceContractVO vo) {
        service.removePriceContractDetail(vo.getId());
        return CommonResponse.success("移除成功");
    }
}
