package com.ejianc.business.material.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.prosub.enums.PerformanceStatusEnum;
import com.ejianc.business.prosub.enums.SignatureStatusEnum;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.material.bean.MaterialApplyEntity;
import com.ejianc.business.material.service.IMaterialApplyService;
import com.ejianc.business.material.vo.MaterialApplyVO;

/**
 * 领料限额登记主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialApply")
public class MaterialApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "MATERIAL_APPLY";//此处需要根据实际修改

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialApplyService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialApplyVO> saveOrUpdate(@RequestBody MaterialApplyVO saveOrUpdateVO) {
    	//判断当前合同是否被其他领料使用
        if (null == saveOrUpdateVO.getId()){
            CommonResponse result = queryUnusedContract(saveOrUpdateVO.getContractId());
            if (null != result && 1 == result.getCode()){
                return result;
            }
        }
        MaterialApplyEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialApplyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	MaterialApplyVO vo = BeanMapper.map(entity, MaterialApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialApplyVO> queryDetail(Long id) {
    	MaterialApplyEntity entity = service.selectById(id);
    	MaterialApplyVO vo = BeanMapper.map(entity, MaterialApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialApplyVO> vos) {
        service.removeByIds(vos.stream().map(MaterialApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
        if(!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }
        List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));


        IPage<MaterialApplyEntity> page = service.queryPage(param,false);
        IPage<MaterialApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }




    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        Map<String, Object> beans = new HashMap<>();
        param.setPageSize(-1);
        CommonResponse<IPage<MaterialApplyVO>> commonResponse = queryList(param);
        List<MaterialApplyVO> MaterialApplyVOList = new ArrayList<>();
        if (null != commonResponse.getData()){
            MaterialApplyVOList = (List<MaterialApplyVO>) commonResponse.getData().getRecords();
        }
        beans.put("records", MaterialApplyVOList);
        ExcelExport.getInstance().export("materialApply-export.xlsx", beans, response);

    }


    /**
     * @Description queryUnusedContract 查询合同是否被领料使用
     * @param contractId
     */
    @RequestMapping(value = "/queryUnusedContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryUnusedContract(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        List<MaterialApplyEntity> resultList = service.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(resultList)){
            return CommonResponse.error("当前合同已进行领料登记，请选择其他合同。");
        }
        return CommonResponse.success("查询详情数据成功！");
    }



}
