package com.ejianc.business.plan.service.impl;

import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.mapper.PlanDetailMapper;
import com.ejianc.business.plan.service.IPlanDetailService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 分包总计划明细实体
 * 
 * @author generator
 * 
 */
@Service("planDetailService")
public class PlanDetailServiceImpl extends BaseServiceImpl<PlanDetailMapper, PlanDetailEntity> implements IPlanDetailService{

    @Autowired
    private PlanDetailMapper planDetailMapper;

    @Override
    public void delByPlanIdAndDetailIds(List<Long> delDetailIds, Long planId) {
        if(CollectionUtils.isNotEmpty(delDetailIds)) {
            planDetailMapper.delByPlanIdAndDetailIds(delDetailIds, planId);
        }
    }

    @Override
    public List<PlanDetailEntity> getListBySourceIdsAndInnerCode(Long planId, List<Long> detailSourceIds, List<String> innerCodes) {
        return planDetailMapper.getListBySourceIdsAndInnerCode(planId, CollectionUtils.isNotEmpty(detailSourceIds) ? detailSourceIds : null
                , CollectionUtils.isNotEmpty(innerCodes) ? innerCodes : null);
    }
}
