package com.ejianc.business.prosub.equip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prosub.equip.bean.EquipUseApplyDetailEntity;
import com.ejianc.business.prosub.equip.service.IEquipUseApplyDetailService;
import com.ejianc.business.prosub.equip.service.IEquipUseApplyService;
import com.ejianc.business.prosub.equip.vo.EquipUseApplyDetailVO;
import com.ejianc.business.prosub.equip.vo.EquipUseApplyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包机械使用申请-子表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("equipUseApplyDetail")
public class EquipUseApplyDetailController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEquipUseApplyDetailService service;

    @Autowired
    private IEquipUseApplyService applyService;

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @PostMapping(value = "queryAllByApplyIds")
    public CommonResponse<List<EquipUseApplyDetailVO>> queryAllByApplyIds(@RequestBody List<Long> applyIds) {
        List<EquipUseApplyVO> applyList= applyService.getAllByIds(applyIds);
        Map<Long, EquipUseApplyVO> applyMap = applyList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));

        List<EquipUseApplyDetailVO> detailList = service.queryAllByApplyIds(applyIds);
        for(EquipUseApplyDetailVO detail : detailList) {
            detail.setApplyCode(applyMap.get(detail.getApplyId()).getBillCode());
        }

        return CommonResponse.success("查询成功！", detailList);
    }


    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refEquipUseApplyDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EquipUseApplyDetailVO>> refEquipUseApplyDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<EquipUseApplyDetailEntity> page = service.queryPage(param,false);
        IPage<EquipUseApplyDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EquipUseApplyDetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
