/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.controller;

import com.ejianc.business.prosub.mapper.ProgressAnalysisMapper;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"progressAnalysis"})
public class ProgressAnalysisController {
    private static final Logger log = LoggerFactory.getLogger(ProgressAnalysisController.class);
    @Autowired
    private ProgressAnalysisMapper mapper;
    @Autowired
    private SettleMapper settleMapper;

    @GetMapping(value={"/analysis"})
    public CommonResponse<Map<String, Object>> analysisSelect(@RequestParam(value="id", required=false) Long projectId) {
        HashMap<String, Serializable> ans = new HashMap<String, Serializable>();
        if (projectId == null) {
            ans.put("duration", null);
            ans.put("planEndDate", null);
            ans.put("progress", Integer.valueOf(0));
            ans.put("planStartDate", null);
            ans.put("planDateNum", Integer.valueOf(0));
            ans.put("productionProgress", Integer.valueOf(0));
            ans.put("approvalProgress", Integer.valueOf(0));
            ans.put("reportProgress", Integer.valueOf(0));
            ans.put("paymentCollection", Integer.valueOf(0));
            ans.put("expenditureSettlement", Integer.valueOf(0));
            ans.put("paymentProgress", Integer.valueOf(0));
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", ans);
        }
        Map<String, Object> projectInitiation = this.mapper.getProjectInitiation(projectId);
        long duration = 0L;
        Date day = new Date();
        try {
            Date planEndDate = (Date)projectInitiation.get("plan_end_date");
            duration = ChronoUnit.DAYS.between(this.getLocalDate(day), this.getLocalDate(planEndDate));
            ans.put("duration", Long.valueOf(duration));
            log.info("duration:{}", ans.get("duration"));
            ans.put("planEndDate", planEndDate);
            log.info("planEndDate:{}", ans.get("planEndDate"));
        }
        catch (Exception e) {
            log.error("\u3010\u5269\u4f59\u5de5\u671f\u3011\u9519\u8bef", (Throwable)e);
            ans.put("duration", Integer.valueOf(0));
        }
        try {
            Date planStartDate = (Date)projectInitiation.get("plan_start_date");
            long planDateNum = Long.parseLong(String.valueOf(projectInitiation.get("plan_date_num")));
            long progress = ChronoUnit.DAYS.between(this.getLocalDate(day), this.getLocalDate(planStartDate)) / planDateNum * 100L;
            ans.put("progress", Long.valueOf(progress));
            log.info("progress:{}", ans.get("progress"));
            ans.put("planStartDate", planStartDate);
            log.info("planStartDate:{}", ans.get("planStartDate"));
            ans.put("planDateNum", Long.valueOf(planDateNum));
            log.info("planDateNum:{}", ans.get("planDateNum"));
        }
        catch (Exception e) {
            log.error("\u3010\u8ba1\u5212\u5f00\u5de5\u65e5\u671f\u3011\u9519\u8bef", (Throwable)e);
            ans.put("progress", Integer.valueOf(0));
        }
        BigDecimal registerProgectId = null;
        try {
            BigDecimal incomeProgectId = this.mapper.getProductionProgectMoney(projectId);
            registerProgectId = this.mapper.getContractRegisterProgectMoney(projectId);
            BigDecimal productionProgress = incomeProgectId.subtract(registerProgectId);
            ans.put("productionProgress", productionProgress);
            log.info("productionProgress:{}", ans.get("productionProgress"));
        }
        catch (Exception e) {
            log.error("\u3010\u65bd\u5de5\u5408\u540c\u91d1\u989d\u3011\u9519\u8bef", (Throwable)e);
            ans.put("productionProgress", Integer.valueOf(0));
        }
        try {
            BigDecimal templaterProgectMoney = this.mapper.getTemplaterProgectMoney(projectId);
            if (registerProgectId == null) {
                throw new BusinessException("\u65bd\u5de5\u5408\u540c\u91d1\u989d\u5f02\u5e38");
            }
            BigDecimal approvalProgress = templaterProgectMoney.subtract(registerProgectId);
            ans.put("approvalProgress", approvalProgress);
            log.info("approvalProgress:{}", ans.get("approvalProgress"));
        }
        catch (Exception e) {
            log.error("\u3010\u6279\u590d\u8fdb\u5ea6\u3011\u9519\u8bef", (Throwable)e);
            ans.put("approvalProgress", Integer.valueOf(0));
        }
        try {
            BigDecimal money = this.mapper.getSBProgectMoney(projectId);
            BigDecimal reportProgress = money.subtract(registerProgectId);
            ans.put("reportProgress", reportProgress);
            log.info("reportProgress:{}", ans.get("reportProgress"));
        }
        catch (Exception e) {
            log.error("\u3010\u4e0a\u62a5\u8fdb\u5ea6\u3011\u9519\u8bef", (Throwable)e);
            ans.put("reportProgress", Integer.valueOf(0));
        }
        try {
            BigDecimal registerProgectMoney = this.mapper.getReceiptRegisterProgectMoney(projectId);
            if (registerProgectId == null) {
                throw new BusinessException("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u5f02\u5e38");
            }
            BigDecimal paymentCollection = registerProgectMoney.subtract(registerProgectId);
            ans.put("paymentCollection", paymentCollection);
            log.info("paymentCollection:{}", ans.get("paymentCollection"));
        }
        catch (Exception e) {
            log.error("\u3010\u56de\u6b3e\u8fdb\u5ea6\u3011\u9519\u8bef", (Throwable)e);
            ans.put("paymentCollection", Integer.valueOf(0));
        }
        BigDecimal expenditureContractAmount = null;
        BigDecimal settlementAmountSum = null;
        try {
            BigDecimal measurementProjectMny = this.settleMapper.getMeasurementProjectMny(projectId);
            BigDecimal adjustmentAmount = this.mapper.getAdjustmentAmount(projectId);
            BigDecimal promaterialSettlementAmount = this.mapper.getPromaterialSettlementAmount(projectId);
            BigDecimal settlementAmount = this.mapper.getSettlementAmount(projectId);
            BigDecimal proequipmentPurchaseAmount = this.mapper.getProequipmentPurchaseAmount(projectId);
            BigDecimal prosubSettleAmount = this.mapper.getProsubSettleAmount(projectId);
            expenditureContractAmount = this.mapper.getSubcontractAmount(projectId);
            settlementAmountSum = measurementProjectMny.add(adjustmentAmount).add(prosubSettleAmount).add(promaterialSettlementAmount).add(settlementAmount).add(proequipmentPurchaseAmount);
            BigDecimal expenditureSettlement = settlementAmountSum.subtract(expenditureContractAmount);
            ans.put("expenditureSettlement", expenditureSettlement);
            log.info("expenditureSettlement:{}", ans.get("expenditureSettlement"));
        }
        catch (Exception e) {
            log.error("\u3010\u652f\u51fa\u7ed3\u7b97\u3011\u9519\u8bef", (Throwable)e);
            ans.put("expenditureSettlement", Integer.valueOf(0));
        }
        try {
            BigDecimal paymentRegisterAmount = this.mapper.getPaymentRegisterAmount(projectId);
            BigDecimal paymentProgress = paymentRegisterAmount.subtract(expenditureContractAmount);
            ans.put("paymentProgress", paymentProgress);
            log.info("paymentProgress:{}", ans.get("paymentProgress"));
        }
        catch (Exception e) {
            log.error("\u3010\u4ed8\u6b3e\u8fdb\u5ea6\u3011\u9519\u8bef", (Throwable)e);
            ans.put("paymentProgress", Integer.valueOf(0));
        }
        return CommonResponse.success((String)("\u67e5\u8be2\u6210\u529f:" + projectId), ans);
    }

    private LocalDate getLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @GetMapping(value={"/expenditureAnalysis"})
    public CommonResponse<Map<String, Object>> expenditureAnalysis(@RequestParam(value="id", required=false) Long projectId) {
        HashMap<String, Number> ans = new HashMap<String, Number>();
        BigDecimal expenditureContractAmount = null;
        if (projectId == null) {
            ans.put("expenditureContractAmount", 0);
            ans.put("settlementAmountSum", 0);
            ans.put("paymentRegisterAmount", 0);
            ans.put("oldjobRegistration", 0);
            ans.put("paymentAmount", 0);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", ans);
        }
        try {
            expenditureContractAmount = this.mapper.getSubcontractAmount(projectId);
            ans.put("expenditureContractAmount", expenditureContractAmount);
            log.info("expenditureContractAmount:{}", ans.get("expenditureContractAmount"));
        }
        catch (Exception e) {
            log.error("\u3010\u652f\u51fa\u5408\u540c\u91d1\u989d\u3011\u9519\u8bef", (Throwable)e);
            ans.put("expenditureContractAmount", 0);
        }
        BigDecimal settlementAmountSum = null;
        try {
            BigDecimal measurementProjectMny = this.settleMapper.getMeasurementProjectMny(projectId);
            BigDecimal adjustmentAmount = this.mapper.getAdjustmentAmount(projectId);
            BigDecimal promaterialSettlementAmount = this.mapper.getPromaterialSettlementAmount(projectId);
            BigDecimal settlementAmount = this.mapper.getSettlementAmount(projectId);
            BigDecimal proequipmentPurchaseAmount = this.mapper.getProequipmentPurchaseAmount(projectId);
            BigDecimal prosubSettleAmount = this.mapper.getProsubSettleAmount(projectId);
            settlementAmountSum = measurementProjectMny.add(adjustmentAmount).add(prosubSettleAmount).add(promaterialSettlementAmount).add(settlementAmount).add(proequipmentPurchaseAmount);
            ans.put("settlementAmountSum", settlementAmountSum);
            log.info("settlementAmountSum:{}", ans.get("settlementAmountSum"));
        }
        catch (Exception e) {
            log.error("\u3010\u8ba1\u91cf/\u7ed3\u7b97\u91d1\u989d\u3011\u9519\u8bef", (Throwable)e);
            ans.put("settlementAmountSum", 0);
        }
        BigDecimal paymentRegisterAmount = this.mapper.getPaymentRegisterAmount(projectId);
        ans.put("paymentRegisterAmount", paymentRegisterAmount);
        log.info("paymentRegisterAmount:{}", ans.get("paymentRegisterAmount"));
        try {
            BigDecimal oldjobRegistration = this.mapper.getOldjobRegistration(projectId);
            ans.put("oldjobRegistration", oldjobRegistration);
            log.info("oldjobRegistration:{}", ans.get("oldjobRegistration"));
        }
        catch (Exception e) {
            log.error("\u3010\u5206\u5305\u7b7e\u8bc1\u91d1\u989d\u3011\u9519\u8bef", (Throwable)e);
            ans.put("oldjobRegistration", 0);
        }
        try {
            BigDecimal paymentAmount = this.mapper.getPaymentRegisterAmount(projectId);
            ans.put("paymentAmount", paymentAmount);
            log.info("paymentAmount:{}", ans.get("paymentAmount"));
        }
        catch (Exception e) {
            log.error("\u3010\u4ed8\u6b3e\u91d1\u989d\u3011\u9519\u8bef", (Throwable)e);
            ans.put("paymentAmount", 0);
        }
        return CommonResponse.success((String)("\u67e5\u8be2\u6210\u529f:" + projectId), ans);
    }
}

