package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.process.vo.ImprotSalaryDetailVO;
import com.ejianc.business.process.vo.SalaryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.process.mapper.SalaryMapper;
import com.ejianc.business.process.bean.SalaryEntity;
import com.ejianc.business.process.service.ISalaryService;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 工人工资单主实体
 * 
 * @author generator
 * 
 */
@Service("salaryService")
public class SalaryServiceImpl extends BaseServiceImpl<SalaryMapper, SalaryEntity> implements ISalaryService{
    @Autowired
    private SalaryMapper salaryMapper;
    private static final String regex = "^\\d{16}|\\d{19}$";
    private static final String IdCardRegex="^\\d{17}[0-9X]";
    @Override
    public List<SalaryVO> checkContract(Long contractId, String belongMonth) {
        return salaryMapper.checkContract(contractId,belongMonth);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImprotSalaryDetailVO> successList = new ArrayList<>();
            List<ImprotSalaryDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 15) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size()>=10000){
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }

                for (int i = 1; i < result.size(); i++) {
                    StringBuilder errorMessage = new StringBuilder();
                    List<String> datas = result.get(i);
                    ImprotSalaryDetailVO salaryDetailVO = new ImprotSalaryDetailVO();
                    //WorkerName
                    if (StringUtils.isBlank(datas.get(0))) {
                        errorMessage.append("[名字为必填项]");
                    }
                    else if (datas.get(0).length() > 20 || datas.get(0).length()==1 ) {
                        errorMessage.append("[名字为必填项]");
                    }
                    salaryDetailVO.setWorkerName(datas.get(0));

                    //WorkType
                    if (datas.get(1).length() > 20) {
                        errorMessage.append("[填写工种长度为0~20字]");
                    }
                    salaryDetailVO.setWorkType(datas.get(1));

                    //身份证号- IdCard
                    if (StringUtils.isNotBlank(datas.get(2))) {
                        if (datas.get(2).length() > 18) {
                            salaryDetailVO.setErrorMessage("填写身份证号长度最大为18位");
                        }else {
                            salaryDetailVO.setIdCard(datas.get(2).trim());
                        }
                    }

                    //班组 groupName
                    if (datas.get(3).length()>100){
                        errorMessage.append("[填写班组长度为0~100字]");
                    }
                    salaryDetailVO.setGroupName(datas.get(3));


                    //银行卡号-accountNum
                    if (StringUtils.isNotBlank(datas.get(4))){
                        if (datas.get(4).trim().length() > 19) {
                            salaryDetailVO.setErrorMessage("填写银行卡号长度最大为19位");
                        }else {
                            salaryDetailVO.setBankCard(datas.get(4).trim());
                        }
                    }

                    //BankName
                    if (datas.get(5).length()>20){
                        errorMessage.append("[填写开户行长度为0~20字]");
                    }
                    salaryDetailVO.setBankName(datas.get(5));

                    //MeasurementType 计量方式
                    if (StringUtils.isBlank(datas.get(6))) {
                        errorMessage.append("[计量方式为必填项]");
                    } else if (datas.get(6).length()!=4) {
                        errorMessage.append("[计量方式填写错误]");
                    } else if (datas.get(6).equals("计日结算") ) {
                        salaryDetailVO.setMeasurementType("0");
                        if (StringUtils.isBlank(datas.get(9))){
                            errorMessage.append("[计量方式为计日结算需要填写出勤天数]");
                        }else {
                            try {
                                //计日结算则填写出勤天数
                                salaryDetailVO.setWorkload(new BigDecimal(datas.get(9)));
                            } catch (Exception e) {
                                errorMessage.append("[出勤天数为必须为数字]");
                            }
                        }
                    } else if (datas.get(6).equals("计件结算") ) {
                        salaryDetailVO.setMeasurementType("1");
                        if (StringUtils.isBlank(datas.get(7))){
                            errorMessage.append("[计量方式为计件结算需要填写工作量（计件）]");
                        }else {
                            try {
                                //计件结算填写工作量（计件）
                                salaryDetailVO.setWorkload(new BigDecimal(datas.get(7)));
                            } catch (Exception e) {
                                errorMessage.append("[工作量（计件）为必须为数字]");
                            }
                        }
                    }

                    //Price
                    if (StringUtils.isNotBlank(datas.get(8))) {
                        try {
                            salaryDetailVO.setPrice(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            errorMessage.append("[单价为必须为数字]");
                        }
                    } else {
                        errorMessage.append("[单价为必填项]");
                    }


                    //OvertimeMeasureType
                    if (datas.get(10).equals("计日结算") ) {
                        salaryDetailVO.setOvertimeMeasureType("0");
                    }
                    else if (datas.get(10).equals("计件结算") ) {
                        salaryDetailVO.setOvertimeMeasureType("1");
                    }
                    //OvertimeNum
                    if (StringUtils.isNotBlank(datas.get(11))) {
                        try {
                            salaryDetailVO.setOvertimeNum(new BigDecimal(datas.get(11)));
                        } catch (Exception e) {
                            errorMessage.append("[加班工作量为必须为数字]");
                        }
                    }
                    //setShouldSalaryMmy
                    if (StringUtils.isNotBlank(datas.get(12))) {
                        try {
                            salaryDetailVO.setShouldSalaryMny(new BigDecimal(datas.get(12)));
                        } catch (Exception e) {
                            errorMessage.append("[应发工资为必须为数字]");
                        }
                    } else {
                        errorMessage.append("[应发工资为必填项]");
                    }
                    //setDeductMny
                    if (StringUtils.isNotBlank(datas.get(13))) {
                        try {
                            salaryDetailVO.setDeductMny(new BigDecimal(datas.get(13)));
                        } catch (Exception e) {
                            errorMessage.append("[扣款费用为必须为数字]");
                        }
                    }
                    //
                    if (StringUtils.isNotBlank(datas.get(14))) {
                        try {
                            salaryDetailVO.setSalaryMny(new BigDecimal(datas.get(14)));
                        } catch (Exception e) {
                            errorMessage.append("[实发工资为必须为数字]");
                        }
                    }

                    if (StringUtils.isNotBlank(errorMessage)){
                        salaryDetailVO.setErrorMessage(String.valueOf(errorMessage));
                        errorList.add(salaryDetailVO);
                    }else {
                        successList.add(salaryDetailVO);
                    }
                }
            }
            //errorListTable
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }
}
