package com.ejianc.business.prosub.controller;

import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.prosub.mapper.ProgressAnalysisMapper;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.xml.namespace.QName;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * 进度分析门户和支出分析门户
 * */
@RestController
@RequestMapping("progressAnalysis")
public class ProgressAnalysisController {

    private static final Logger log = LoggerFactory.getLogger(ProgressAnalysisController.class);
    @Autowired
    private ProgressAnalysisMapper mapper;

    @Autowired
    private SettleMapper settleMapper;

    @GetMapping(value = "/analysis")
    public CommonResponse<Map<String, Object>> analysisSelect(@RequestParam(value = "id", required = false) Long projectId) {
        Map<String, Object> ans = new HashMap<>();
        //没有项目ID直接返回空数据
        if (projectId == null) {
            ans.put("duration", null);
            ans.put("planEndDate", null);
            ans.put("progress", 0);
            ans.put("planStartDate", null);
            ans.put("planDateNum", 0);
            ans.put("productionProgress", 0);
            ans.put("approvalProgress", 0);
            ans.put("reportProgress", 0);
            ans.put("paymentCollection", 0);
            ans.put("expenditureSettlement", 0);
            ans.put("paymentProgress", 0);
            return CommonResponse.success("查询成功", ans);
        }
        //获取项目立项数据
        Map<String, Object> projectInitiation =
                mapper.getProjectInitiation(projectId);
        log.info("projectInitiation:{}",projectInitiation);
        //projectInitiation:{plan_end_date=2026-04-15, plan_date_num=197, plan_start_date=2025-09-30}
        //剩余工期
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        long duration = 0;
        Date day = new Date(); //获取当前日期
        try {
            //计划完工日期
            String planEndDateStr = String.valueOf(projectInitiation.get("plan_end_date"));
            Date planEndDate = format.parse(planEndDateStr);
            //剩余工期 = 【计划完工日期】-【当前日期】+ 1；
            duration = ChronoUnit.DAYS.between(getLocalDate(day), getLocalDate(planEndDate));
            ans.put("duration", duration);
            log.info("duration:{}",ans.get("duration"));
            ans.put("planEndDate", planEndDate);
            log.info("planEndDate:{}",ans.get("planEndDate"));
        } catch (Exception e) {
            log.error("【剩余工期】错误", e);
            ans.put("duration", null);
        }

        try {
            //计划开工日期 planStartDate
            //Date planStartDate = (Date) projectInitiation.get("plan_start_date");
            //计划完工日期
            String planStartDateStr = String.valueOf(projectInitiation.get("plan_start_date"));
            Date planStartDate = format.parse(planStartDateStr);
            //计划工期 planDateNum
            long planDateNum = Long.parseLong(String.valueOf(projectInitiation.get("plan_date_num")));
            //【工期进度】=（【当前日期】-【计划开工日期】+ 1） /【预计工期】* 100%；
            long progress = (ChronoUnit.DAYS.between(getLocalDate(day),
                    getLocalDate(planStartDate)) / planDateNum) * 100;
            ans.put("progress", progress);
            log.info("progress:{}",ans.get("progress"));
            ans.put("planStartDate", planStartDate);
            log.info("planStartDate:{}",ans.get("planStartDate"));
            ans.put("planDateNum", planDateNum);
            log.info("planDateNum:{}",ans.get("planDateNum"));
        } catch (Exception e) {
            log.error("【计划开工日期】错误", e);
            ans.put("progress", 0);
        }

        //施工合同金额 使用合同签订金额
        BigDecimal registerProgectId = null;
        try {
            //"EJC-PROINCOME"
            //产值进度=【产值金额】/【施工合同金额】
            //产值金额
            BigDecimal incomeProgectId = mapper.getProductionProgectMoney(projectId);
            //施工合同金额
            registerProgectId = mapper.getContractRegisterProgectMoney(projectId);
            //TODO
            BigDecimal productionProgress = incomeProgectId.subtract(registerProgectId);
            ans.put("productionProgress", productionProgress);
            log.info("productionProgress:{}",ans.get("productionProgress"));
        } catch (Exception e) {
            log.error("【施工合同金额】错误", e);
            ans.put("productionProgress", 0);
        }
        try {
            //【批复金额】
            BigDecimal templaterProgectMoney = mapper.getTemplaterProgectMoney(projectId);
            if (registerProgectId == null) {
                throw new BusinessException("施工合同金额异常");
            }
            //批复进度
            BigDecimal approvalProgress = templaterProgectMoney.subtract(registerProgectId);
            ans.put("approvalProgress", approvalProgress);
            log.info("approvalProgress:{}",ans.get("approvalProgress"));
        } catch (Exception e) {
            log.error("【批复进度】错误", e);
            ans.put("approvalProgress", 0);
        }
        //上报进度
        try {
            BigDecimal money = mapper.getSBProgectMoney(projectId);
            BigDecimal reportProgress = money.subtract(registerProgectId);
            ans.put("reportProgress", reportProgress);
            log.info("reportProgress:{}",ans.get("reportProgress"));
        } catch (Exception e) {
            log.error("【上报进度】错误", e);
            ans.put("reportProgress", 0);
        }
        try {
            //【收款金额】
            BigDecimal registerProgectMoney = mapper.getReceiptRegisterProgectMoney(projectId);
            if (registerProgectId == null) {
                throw new BusinessException("合同签订金额异常");
            }
            //回款进度
            BigDecimal paymentCollection = registerProgectMoney.subtract(registerProgectId);
            ans.put("paymentCollection", paymentCollection);
            log.info("paymentCollection:{}",ans.get("paymentCollection"));
        } catch (Exception e) {
            log.error("【回款进度】错误", e);
            ans.put("paymentCollection", 0);
        }
        //支出结算=【结算金额】/【支出合同金额】；
        //支出合同金额
        BigDecimal expenditureContractAmount = null;
        BigDecimal settlementAmountSum = null;
        try {
            //	分包中间计量【本期生效中间计量金额】
            BigDecimal measurementProjectMny = settleMapper.getMeasurementProjectMny(projectId);
            //	采购结算调差单【调整金额】合计 调整金额
            BigDecimal adjustmentAmount = mapper.getAdjustmentAmount(projectId);
            //	对账结算
            BigDecimal promaterialSettlementAmount = mapper.getPromaterialSettlementAmount(projectId);
            //	施工机械结算单中【结算金额】合计
            BigDecimal settlementAmount = mapper.getSettlementAmount(projectId);
            //	设备采购结算单中【结算金额】合计
            BigDecimal proequipmentPurchaseAmount = mapper.getProequipmentPurchaseAmount(projectId);
            //	分包结算中【结算-中间计量】合计
            BigDecimal prosubSettleAmount = mapper.getProsubSettleAmount(projectId);
            //支出合同金额
            expenditureContractAmount = mapper.getSubcontractAmount(projectId);
            settlementAmountSum = measurementProjectMny
                    .add(adjustmentAmount)
                    .add(prosubSettleAmount)
                    .add(promaterialSettlementAmount)
                    .add(settlementAmount)
                    .add(proequipmentPurchaseAmount);
            //支出结算
            BigDecimal expenditureSettlement = settlementAmountSum.subtract(expenditureContractAmount);
            ans.put("expenditureSettlement", expenditureSettlement);
            log.info("expenditureSettlement:{}",ans.get("expenditureSettlement"));
        } catch (Exception e) {
            log.error("【支出结算】错误", e);
            ans.put("expenditureSettlement", 0);
        }
        //付款进度=【付款金额】/【结算金额】
        try {
            //付款金额
            BigDecimal paymentRegisterAmount = mapper.getPaymentRegisterAmount(projectId);
            BigDecimal paymentProgress = paymentRegisterAmount.subtract(expenditureContractAmount);
            ans.put("paymentProgress", paymentProgress);
            log.info("paymentProgress:{}",ans.get("paymentProgress"));
        } catch (Exception e) {
            log.error("【付款进度】错误", e);
            ans.put("paymentProgress", 0);
        }
        return CommonResponse.success("查询成功:" + projectId, ans);
    }

    // 修复后的 getLocalDate 方法
    private LocalDate getLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        // 正确方法：先将Date转换为Instant，再指定时区，最后转换为LocalDate
        return date.toInstant()
                .atZone(ZoneId.systemDefault()) // 使用系统默认时区，根据你的业务需求也可以指定特定时区（如 ZoneId.of("UTC")）
                .toLocalDate();
    }

    @GetMapping(value = "/expenditureAnalysis")
    public CommonResponse<Map<String, Object>> expenditureAnalysis(@RequestParam(value = "id",required = false)
                                                                       Long projectId) {
        Map<String, Object> ans = new HashMap<>();
        //支出合同金额
        BigDecimal expenditureContractAmount = null;
        if(projectId == null){
            //无项目ID返回空数据
            ans.put("expenditureContractAmount", 0);
            ans.put("settlementAmountSum", 0);
            ans.put("paymentRegisterAmount", 0);
            ans.put("oldjobRegistration", 0);
            ans.put("paymentAmount", 0);
            return CommonResponse.success("查询成功", ans);
        }
        try {
            expenditureContractAmount = mapper.getSubcontractAmount(projectId);
            ans.put("expenditureContractAmount", expenditureContractAmount);
            log.info("expenditureContractAmount:{}",ans.get("expenditureContractAmount"));
        } catch (Exception e) {
            log.error("【支出合同金额】错误", e);
            ans.put("expenditureContractAmount", 0);
        }
        //计量/结算金额
        BigDecimal settlementAmountSum = null;
        try {
            //	分包中间计量【本期生效中间计量金额】
            BigDecimal measurementProjectMny = settleMapper.getMeasurementProjectMny(projectId);
            //	采购结算调差单【调整金额】合计 调整金额
            BigDecimal adjustmentAmount = mapper.getAdjustmentAmount(projectId);
            //	对账结算
            BigDecimal promaterialSettlementAmount = mapper.getPromaterialSettlementAmount(projectId);
            //	施工机械结算单中【结算金额】合计
            BigDecimal settlementAmount = mapper.getSettlementAmount(projectId);
            //	设备采购结算单中【结算金额】合计
            BigDecimal proequipmentPurchaseAmount = mapper.getProequipmentPurchaseAmount(projectId);
            //	分包结算中【结算-中间计量】合计
            BigDecimal prosubSettleAmount = mapper.getProsubSettleAmount(projectId);
            settlementAmountSum = measurementProjectMny
                    .add(adjustmentAmount)
                    .add(prosubSettleAmount)
                    .add(promaterialSettlementAmount)
                    .add(settlementAmount)
                    .add(proequipmentPurchaseAmount);
            ans.put("settlementAmountSum", settlementAmountSum);
            log.info("settlementAmountSum:{}",ans.get("settlementAmountSum"));
        } catch (Exception e) {
            log.error("【计量/结算金额】错误", e);
            ans.put("settlementAmountSum", 0);
        }
        //付款金额
        BigDecimal paymentRegisterAmount = mapper.getPaymentRegisterAmount(projectId);
        ans.put("paymentRegisterAmount", paymentRegisterAmount);
        log.info("paymentRegisterAmount:{}",ans.get("paymentRegisterAmount"));
        //分包签证金额
        try {
            BigDecimal oldjobRegistration = mapper.getOldjobRegistration(projectId);
            ans.put("oldjobRegistration", oldjobRegistration);
            log.info("oldjobRegistration:{}",ans.get("oldjobRegistration"));
        } catch (Exception e) {
            log.error("【分包签证金额】错误", e);
            ans.put("oldjobRegistration", 0);
        }
        //付款金额
        try {
            BigDecimal paymentAmount = mapper.getPaymentRegisterAmount(projectId);
            ans.put("paymentAmount", paymentAmount);
            log.info("paymentAmount:{}",ans.get("paymentAmount"));
        } catch (Exception e) {
            log.error("【付款金额】错误", e);
            ans.put("paymentAmount", 0);
        }
        return CommonResponse.success("查询成功:" + projectId, ans);
    }

}
