package com.ejianc.business.prosub.equip.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prosub.equip.vo.EquipUseApplyDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.prosub.equip.mapper.EquipUseApplyDetailMapper;
import com.ejianc.business.prosub.equip.bean.EquipUseApplyDetailEntity;
import com.ejianc.business.prosub.equip.service.IEquipUseApplyDetailService;

import java.util.ArrayList;
import java.util.List;

/**
 * 分包机械使用申请-子表
 * 
 * @author generator
 * 
 */
@Service("equipUseApplyDetailService")
public class EquipUseApplyDetailServiceImpl extends BaseServiceImpl<EquipUseApplyDetailMapper, EquipUseApplyDetailEntity> implements IEquipUseApplyDetailService{

    @Override
    public List<EquipUseApplyDetailVO> queryAllByApplyIds(List<Long> applyIds) {
        List<EquipUseApplyDetailVO> resp =new ArrayList<>();
        QueryWrapper<EquipUseApplyDetailEntity> query = new QueryWrapper<>();
        query.in("apply_id", applyIds);

        List<EquipUseApplyDetailEntity> dbList = super.list(query);

        if(CollectionUtils.isNotEmpty(dbList)) {
            return BeanMapper.mapList(dbList, EquipUseApplyDetailVO.class);
        }

        return resp;
    }
}
