package com.ejianc.business.prosub.controller;

import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.prosub.mapper.ProgressAnalysisMapper;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.xml.namespace.QName;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * 进度分析门户和支出分析门户
 * */
@RestController
@RequestMapping("progressAnalysis")
public class ProgressAnalysisController {

    private static final Logger log = LoggerFactory.getLogger(ProgressAnalysisController.class);
    @Autowired
    private ProgressAnalysisMapper mapper;

    @Autowired
    private SettleMapper settleMapper;

    @GetMapping(value = "/analysis")
    public CommonResponse<Map<String, Object>> analysisSelect(@RequestParam(value = "id", required = false) Long projectId) {
        Map<String, Object> ans = new HashMap<>();
        //没有项目ID直接返回空数据
        if (projectId == null) {
            ans.put("duration", 0);
            ans.put("planEndDate", 0);
            ans.put("progress", 0);
            ans.put("planStartDate", 0);
            ans.put("planDateNum", 0);
            ans.put("productionProgress", 0);
            ans.put("approvalProgress", 0);
            ans.put("reportProgress", 0);
            ans.put("paymentCollection", 0);
            ans.put("expenditureSettlement", 0);
            ans.put("paymentProgress", 0);
            return CommonResponse.success("查询成功", ans);
        }
        //获取项目立项数据
        Map<String, Object> projectInitiation =
                mapper.getProjectInitiation(projectId);
        log.info("projectInitiation:{}",projectInitiation);
        //剩余工期
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        long duration = 0;
        Date day = new Date(); //获取当前日期
        try {
            //计划完工日期
            String planEndDateStr = String.valueOf(projectInitiation.get("plan_end_date"));
            Date planEndDate = format.parse(planEndDateStr);
            //剩余工期 = 【计划完工日期】-【当前日期】+ 1；
            duration = Math.abs(ChronoUnit.DAYS.between(getLocalDate(day), getLocalDate(planEndDate)));
            ans.put("duration", duration);
            log.info("duration:{}",ans.get("duration"));
            ans.put("planEndDate", format.format(planEndDate));
            log.info("planEndDate:{}",ans.get("planEndDate"));
        } catch (Exception e) {
            log.error("【剩余工期】错误");
            ans.put("duration", 0);
        }

        try {
            //计划开工日期 planStartDate
            //计划完工日期
            String planStartDateStr = String.valueOf(projectInitiation.get("plan_start_date"));
            Date planStartDate = format.parse(planStartDateStr);
            //计划工期 planDateNum
            long planDateNum = Long.parseLong(String.valueOf(projectInitiation.get("plan_date_num")));
            //【工期进度】=（【当前日期】-【计划开工日期】+ 1） /【预计工期】* 100%；
            double progress = 0;
            long between = Math.abs(ChronoUnit.DAYS.between(getLocalDate(day), getLocalDate(planStartDate)));
            progress = ((double) between / (double) planDateNum) * 100;
            ans.put("progress", progress);
            ans.put("planStartDate", format.format(planStartDate));
            ans.put("planDateNum", planDateNum);
        } catch (Exception e) {
            log.error("【计划工期】，【计划开工日期】，【工期进度】错误");
            ans.put("progress", 0);
        }

        //施工合同金额 使用合同签订金额
        BigDecimal registerProgectId = null;
        try {
            //"EJC-PROINCOME"
            //产值进度=【产值金额】/【施工合同金额】
            //产值金额
            BigDecimal incomeProgectId = mapper.getProductionProgectMoney(projectId);//540001
            //施工合同金额
            registerProgectId = mapper.getContractRegisterProgectMoney(projectId);//18348623.85321101
            //TODO
            BigDecimal productionProgress ;
            if (registerProgectId.compareTo(BigDecimal.ZERO) == 0) {
                productionProgress = BigDecimal.ZERO;
            } else {
                productionProgress = incomeProgectId.divide(registerProgectId, 10, RoundingMode.HALF_UP);
            }
            ans.put("productionProgress", productionProgress.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
            log.info("productionProgress:{}",ans.get("productionProgress"));
        } catch (Exception e) {
            log.error("【施工合同金额】错误");
            ans.put("productionProgress", 0);
        }
        try {
            //【批复金额】
            BigDecimal templaterProgectMoney = mapper.getTemplaterProgectMoney(projectId);
            if (registerProgectId == null) {
                throw new BusinessException("施工合同金额异常");
            }
            //批复进度
            BigDecimal approvalProgress ;
            if (registerProgectId.compareTo(BigDecimal.ZERO) == 0) {
                approvalProgress = BigDecimal.ZERO;
            } else {
                approvalProgress = templaterProgectMoney.divide(registerProgectId, 10, RoundingMode.HALF_UP);
            }
            ans.put("approvalProgress", approvalProgress.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
        } catch (Exception e) {
            log.error("【批复进度】错误");
            ans.put("approvalProgress", 0);
        }
        //上报进度
        try {
            BigDecimal money = mapper.getSBProgectMoney(projectId);
            BigDecimal reportProgress ;
            if (registerProgectId.compareTo(BigDecimal.ZERO) == 0) {
                reportProgress = BigDecimal.ZERO;
            } else {
                reportProgress = money.divide(registerProgectId, 10, RoundingMode.HALF_UP);
            }
            ans.put("reportProgress", reportProgress.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
        } catch (Exception e) {
            log.error("【上报进度】错误");
            ans.put("reportProgress", 0);
        }
        try {
            //【收款金额】
            BigDecimal registerProgectMoney = mapper.getReceiptRegisterProgectMoney(projectId);
            if (registerProgectId == null) {
                throw new BusinessException("合同签订金额异常");
            }
            //回款进度
            BigDecimal paymentCollection;
            if (registerProgectId.compareTo(BigDecimal.ZERO) == 0) {
                paymentCollection = BigDecimal.ZERO;
            } else {
                paymentCollection = registerProgectMoney.divide(registerProgectId, 10, RoundingMode.HALF_UP);
            }
            ans.put("paymentCollection", paymentCollection.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
        } catch (Exception e) {
            log.error("【回款进度】错误");
            ans.put("paymentCollection", 0);
        }
        //支出结算=【结算金额】/【支出合同金额】；
        //支出合同金额
        BigDecimal expenditureContractAmount = null;
        BigDecimal settlementAmountSum = null;
        try {
            settlementAmountSum = getAmountSum(projectId);
            //支出合同金额
            expenditureContractAmount = mapper.getSubcontractAmount(projectId);
            //支出结算
            BigDecimal expenditureSettlement;
            if (expenditureContractAmount.compareTo(BigDecimal.ZERO) == 0) {
                expenditureSettlement = BigDecimal.ZERO;
            } else {
                expenditureSettlement = settlementAmountSum.divide(expenditureContractAmount, 10, RoundingMode.HALF_UP);
            }
            ans.put("expenditureSettlement", expenditureSettlement.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
        } catch (Exception e) {
            ans.put("expenditureSettlement", 0);
        }
        //付款进度=【付款金额】/【结算金额】
        try {
            //付款金额
            BigDecimal paymentRegisterAmount = mapper.getPaymentRegisterAmount(projectId);
            BigDecimal paymentProgress;
            if (settlementAmountSum.compareTo(BigDecimal.ZERO) == 0) {
                paymentProgress = BigDecimal.ZERO;
            } else {
                paymentProgress = paymentRegisterAmount.divide(settlementAmountSum, 10, RoundingMode.HALF_UP);
            }
            ans.put("paymentProgress", paymentProgress.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
        } catch (Exception e) {
            log.error("【付款进度】错误");
            ans.put("paymentProgress", 0);
        }
        return CommonResponse.success("查询成功:" + projectId, ans);
    }

    private BigDecimal getAmountSum(Long projectId) {
        //	分包中间计量【本期生效中间计量金额】
        BigDecimal measurementProjectMny = settleMapper.getMeasurementProjectMny(projectId);
        //	采购结算调差单【调整金额】合计 调整金额
        BigDecimal adjustmentAmount = mapper.getAdjustmentAmount(projectId);
        //	对账结算
        BigDecimal promaterialSettlementAmount = mapper.getPromaterialSettlementAmount(projectId);
        //	施工机械结算单中【结算金额】合计
        BigDecimal settlementAmount = mapper.getSettlementAmount(projectId);
        //	设备采购结算单中【结算金额】合计
        BigDecimal proequipmentPurchaseAmount = mapper.getProequipmentPurchaseAmount(projectId);
        //	分包结算中【结算-中间计量】合计
        BigDecimal prosubSettleAmount = mapper.getProsubSettleAmount(projectId);
        return (measurementProjectMny == null ? BigDecimal.ZERO : measurementProjectMny)
                .add((adjustmentAmount == null ? BigDecimal.ZERO : adjustmentAmount))
                .add((prosubSettleAmount == null ? BigDecimal.ZERO : prosubSettleAmount))
                .add((promaterialSettlementAmount == null ? BigDecimal.ZERO : promaterialSettlementAmount))
                .add((settlementAmount == null ? BigDecimal.ZERO : settlementAmount))
                .add((proequipmentPurchaseAmount == null ? BigDecimal.ZERO : proequipmentPurchaseAmount));
    }

    // 修复后的 getLocalDate 方法
    private LocalDate getLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        // 正确方法：先将Date转换为Instant，再指定时区，最后转换为LocalDate
        return date.toInstant()
                .atZone(ZoneId.systemDefault()) // 使用系统默认时区，根据你的业务需求也可以指定特定时区（如 ZoneId.of("UTC")）
                .toLocalDate();
    }

    @GetMapping(value = "/expenditureAnalysis")
    public CommonResponse<Map<String, Object>> expenditureAnalysis(@RequestParam(value = "id",required = false)
                                                                       Long projectId) {
        Map<String, Object> ans = new HashMap<>();
        //支出合同金额
        BigDecimal expenditureContractAmount = null;
        if(projectId == null){
            //无项目ID返回空数据
            ans.put("expenditureContractAmount", 0);
            ans.put("settlementAmountSum", 0);
            ans.put("paymentRegisterAmount", 0);
            ans.put("oldjobRegistration", 0);
            ans.put("paymentAmount", 0);
            return CommonResponse.success("查询成功", ans);
        }
        try {
            expenditureContractAmount = mapper.getSubcontractAmount(projectId);
            ans.put("expenditureContractAmount", expenditureContractAmount);
        } catch (Exception e) {
            log.error("【支出合同金额】错误");
            ans.put("expenditureContractAmount", 0);
        }
        //计量/结算金额
        BigDecimal settlementAmountSum = null;
        try {
            settlementAmountSum = getAmountSum(projectId);
            ans.put("settlementAmountSum", settlementAmountSum);
        } catch (Exception e) {
            log.error("【计量/结算金额】错误");
            ans.put("settlementAmountSum", 0);
        }
        //付款金额
        BigDecimal paymentRegisterAmount = mapper.getPaymentRegisterAmount(projectId);
        ans.put("paymentRegisterAmount", paymentRegisterAmount);
        //分包签证金额
        try {
            BigDecimal oldjobRegistration = mapper.getOldjobRegistration(projectId);
            ans.put("oldjobRegistration", oldjobRegistration);
        } catch (Exception e) {
            log.error("【分包签证金额】错误");
            ans.put("oldjobRegistration", 0);
        }
        //付款金额
        try {
            BigDecimal paymentAmount = mapper.getPaymentRegisterAmount(projectId);
            ans.put("paymentAmount", paymentAmount);
        } catch (Exception e) {
            log.error("【付款金额】错误");
            ans.put("paymentAmount", 0);
        }
        return CommonResponse.success("查询成功:" + projectId, ans);
    }



}
