package com.ejianc.business.prosub.equip.service.impl;

import com.ejianc.business.prosub.equip.bean.EquipUseApplyEntity;
import com.ejianc.business.prosub.equip.service.IEquipUseApplyService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

@Service("equipUseApply") 
public class EquipUseApplyBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IEquipUseApplyService service;

	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IBillTypeApi billTypeApi;

	Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		EquipUseApplyEntity entity = service.selectById(billId);
		UserContext user = sessionManager.getUserContext();
		entity.setCommitDate(new Date());
		entity.setCommitUserCode(user.getUserCode());
		entity.setCommitUserName(user.getUserName());

		service.saveOrUpdate(entity, false);

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		doBack(billId, state, billTypeCode);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		EquipUseApplyEntity entity = service.selectById(billId);
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
			UserContext user = sessionManager.getUserContext();
			entity.setCommitDate(new Date());
			entity.setCommitUserCode(user.getUserCode());
			entity.setCommitUserName(user.getUserName());

		}
		entity.setEffectiveDate(new Date());
		service.saveOrUpdate(entity, false);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		doBack(billId, state, billTypeCode);
		return CommonResponse.success();
	}

	private void doBack(Long billId, Integer state, String billTypeCode) {
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		if(!resp.isSuccess()){
			logger.error("分包机械使用申请 弃审失败，单据已被下游单据引用, {}", resp.getMsg());
			throw new BusinessException("操作失败，单据已被下游单据引用！");
		}

		EquipUseApplyEntity entity = service.selectById(billId);
		entity.setCommitDate(null);
		entity.setCommitUserCode(null);
		entity.setCommitUserName(null);
		entity.setEffectiveDate(null);

		service.saveOrUpdate(entity, false);
	}


}
