package com.ejianc.business.process.service;

import com.ejianc.business.process.bean.DeductionEntity;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;

/**
 * 扣奖罚单
 *
 * @author generator
 */
public interface IDeductionService extends IBaseService<DeductionEntity> {

    /**
     * 单据推送协同
     *
     * @param deductionEntity 扣奖罚单
     * @param billTypeCode 单据类型编码
     * @param cooperateVO 单据协同设置
     * @return
     */
    boolean pushBillToSupCenter(DeductionEntity deductionEntity, String billTypeCode, CooperateVO cooperateVO);

    /**
     * 单据作废通知供方
     *
     * @param deductionEntity 扣奖罚单
     * @param billTypeCode 单据类型编码
     * @return
     */
    boolean delPushBill(DeductionEntity deductionEntity, String billTypeCode);

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);
}
