/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.bean.AdjustDetailEntity;
import com.ejianc.business.process.bean.DeductionEntity;
import com.ejianc.business.process.bean.ProgressEntity;
import com.ejianc.business.process.bean.RegistrationEntity;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.service.IAdjustDetailService;
import com.ejianc.business.process.service.IDeductionService;
import com.ejianc.business.process.service.IProgressService;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.business.profinance.api.ISalaryApi;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.bean.SettlePriceEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.enums.SignatureStatusEnum;
import com.ejianc.business.settle.service.IProcessSettleService;
import com.ejianc.business.settle.service.ISettlePriceService;
import com.ejianc.business.settle.service.ISettleSalaryService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"processSettle"})
public class ProcessSettleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "PROCESS_SETTLE";
    private static final String PRO_BILL_CODE = "PRO_PROCESS_SETTLE";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProcessSettleService service;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private ISalaryApi salaryApi;
    @Autowired
    private ISettleSalaryService settleSalaryService;
    @Autowired
    private IProgressService progressService;
    @Autowired
    private IRegistrationService registrationService;
    @Autowired
    private IDeductionService deductionService;
    @Autowired
    private IAdjustDetailService adjustDetailService;
    @Autowired
    private ISettlePriceService settlePriceService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        LambdaUpdateWrapper updateWrapper;
        HashSet addIds;
        HashSet delIds;
        List<SettleDetailEntity> detailList;
        SettleEntity entity = (SettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)(entity.getContractType() == 0 ? BILL_CODE : PRO_BILL_CODE), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setFilingStatus(0);
            entity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode());
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
            entity.setRelationFlag("0");
            entity.setProportionFlag("0");
        }
        if (!(detailList = entity.getSettleDetailList()).isEmpty()) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (SettleDetailEntity sd : detailList) {
                if ("del".equals(sd.getRowState())) continue;
                if (sd.getId() == null || entity.getId() == null) {
                    sd.setId(IdWorker.getId());
                }
                idMap.put(sd.getTid(), sd.getId());
                sd.setParentId(null);
            }
            for (SettleDetailEntity sd : detailList) {
                if ("del".equals(sd.getRowState()) || !StringUtils.isNotEmpty((CharSequence)sd.getTpid())) continue;
                sd.setParentId((Long)idMap.get(sd.getTpid()));
            }
        }
        entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        if (CollectionUtils.isNotEmpty(entity.getSettleProgressList())) {
            HashSet ids = new HashSet();
            entity.getSettleProgressList().forEach(e -> ids.add(e.getSourceId()));
            LambdaUpdateWrapper updateWrapper2 = new LambdaUpdateWrapper();
            updateWrapper2.in(BaseEntity::getId, ids);
            updateWrapper2.set(ProgressEntity::getSettleFlag, (Object)1);
            this.progressService.update((Wrapper)updateWrapper2);
        }
        if (CollectionUtils.isNotEmpty(entity.getSettleOddjobList())) {
            delIds = new HashSet();
            addIds = new HashSet();
            saveOrUpdateVO.getSettleOddjobList().forEach(e -> {
                if ("del".equals(e.getRowState())) {
                    delIds.add(e.getSourceId());
                } else {
                    addIds.add(e.getSourceId());
                }
            });
            if (CollectionUtils.isNotEmpty(addIds)) {
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, addIds);
                updateWrapper.set(RegistrationEntity::getSettleFlag, (Object)1);
                this.registrationService.update((Wrapper)updateWrapper);
            }
            if (CollectionUtils.isNotEmpty(delIds)) {
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, delIds);
                updateWrapper.set(RegistrationEntity::getSettleFlag, (Object)0);
                this.registrationService.update((Wrapper)updateWrapper);
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getSettleDeductList())) {
            delIds = new HashSet();
            addIds = new HashSet();
            saveOrUpdateVO.getSettleDeductList().forEach(e -> {
                if ("del".equals(e.getRowState())) {
                    delIds.add(e.getSourceId());
                } else {
                    addIds.add(e.getSourceId());
                }
            });
            if (CollectionUtils.isNotEmpty(addIds)) {
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, addIds);
                updateWrapper.set(DeductionEntity::getSettleFlag, (Object)1);
                this.deductionService.update((Wrapper)updateWrapper);
            }
            if (CollectionUtils.isNotEmpty(delIds)) {
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, delIds);
                updateWrapper.set(DeductionEntity::getSettleFlag, (Object)0);
                this.deductionService.update((Wrapper)updateWrapper);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.settleService.pushSettle2TargetCost(entity);
        this.settleService.saveCost(entity, 0);
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        List voList = vo.getSettleDetailList();
        if (!voList.isEmpty()) {
            for (SettleDetailVO detail : voList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0L ? String.valueOf(detail.getParentId()) : null);
            }
            vo.setSettleDetailList(TreeNodeBUtil.buildTree((List)voList));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u8be6\u60c5\u5f02\u5e38\uff01");
        }
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        List detailList = vo.getSettleDetailList();
        if (!detailList.isEmpty()) {
            for (SettleDetailVO detail : detailList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0L ? String.valueOf(detail.getParentId()) : null);
                detail.setParentId(null != detail.getTpid() ? Long.valueOf(detail.getTpid()) : null);
            }
            vo.setSettleDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    public CommonResponse<SettleVO> test(Long id) {
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(id));
        List<SettlePriceEntity> settlePriceList = settleEntity.getSettlePriceList();
        if (CollectionUtils.isNotEmpty(settlePriceList)) {
            List sourceIds = settlePriceList.stream().map(SettlePriceEntity::getSourceId).collect(Collectors.toList());
            this.logger.info("sourceIds" + JSONArray.toJSONString(sourceIds));
            Map settlePriceMap = settlePriceList.stream().collect(Collectors.toMap(SettlePriceEntity::getSourceId, Function.identity()));
            LambdaQueryWrapper lambdaAdjust = Wrappers.lambdaQuery();
            lambdaAdjust.in(BaseEntity::getId, sourceIds);
            List adjustDetailEntities = this.adjustDetailService.list((Wrapper)lambdaAdjust);
            this.logger.info("sourceIds" + JSONArray.toJSONString(sourceIds));
            for (AdjustDetailEntity adjustDetailEntity : adjustDetailEntities) {
                if (!settlePriceMap.containsKey(adjustDetailEntity.getId())) continue;
                SettlePriceEntity settlePriceEntity = (SettlePriceEntity)((Object)settlePriceMap.get(adjustDetailEntity.getId()));
                adjustDetailEntity.setSumMeasureNum(ComputeUtil.safeAdd((BigDecimal)adjustDetailEntity.getSumMeasureNum(), (BigDecimal)settlePriceEntity.getPriceSettleNum()));
                adjustDetailEntity.setSumMeasureMny(ComputeUtil.safeAdd((BigDecimal)adjustDetailEntity.getSumMeasureMny(), (BigDecimal)settlePriceEntity.getPriceSettleTaxMny()));
            }
            this.adjustDetailService.saveOrUpdateBatch(adjustDetailEntities);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        List<Long> billIds = vos.stream().map(SettleVO::getId).collect(Collectors.toList());
        String checkResult = this.settleService.delCheck(billIds);
        if (StringUtils.isNotBlank((CharSequence)checkResult)) {
            return CommonResponse.error((String)checkResult);
        }
        billIds.forEach(id -> {
            LambdaUpdateWrapper updateWrapper;
            HashSet ids;
            SettleEntity entity = (SettleEntity)((Object)((Object)this.service.selectById((Serializable)id)));
            if (CollectionUtils.isNotEmpty(entity.getSettleProgressList())) {
                ids = new HashSet();
                entity.getSettleProgressList().forEach(e -> ids.add(e.getSourceId()));
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, ids);
                updateWrapper.set(ProgressEntity::getSettleFlag, (Object)0);
                this.progressService.update((Wrapper)updateWrapper);
            }
            if (CollectionUtils.isNotEmpty(entity.getSettleOddjobList())) {
                ids = new HashSet();
                entity.getSettleOddjobList().forEach(e -> ids.add(e.getSourceId()));
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, ids);
                updateWrapper.set(RegistrationEntity::getSettleFlag, (Object)0);
                this.registrationService.update((Wrapper)updateWrapper);
            }
            if (CollectionUtils.isNotEmpty(entity.getSettleDeductList())) {
                ids = new HashSet();
                entity.getSettleDeductList().forEach(e -> ids.add(e.getSourceId()));
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(BaseEntity::getId, ids);
                updateWrapper.set(DeductionEntity::getSettleFlag, (Object)0);
                this.deductionService.update((Wrapper)updateWrapper);
            }
        });
        this.settleService.delSettleTargetCostInfo(billIds);
        this.settleService.delSettleCostInfo(billIds);
        this.service.removeByIds(billIds, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("settle_type", new Parameter("eq", (Object)SettleTypeEnum.\u8fc7\u7a0b.getCode()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("settle_type", new Parameter("eq", (Object)SettleTypeEnum.\u8fc7\u7a0b.getCode()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, SettleVO.class);
        voList.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vo.setSignStatusName(Objects.equals(vo.getSupplierSignStatus(), SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode()) ? "\u4e59\u65b9\u672a\u7b7e\u5b57" : "\u4e59\u65b9\u5df2\u7b7e\u5b57");
            vo.setSignatureStatusName(SignatureStatusEnum.getEnumByCode(vo.getSignatureStatus()).getDescription());
            vo.setContractTypeName(vo.getContractType() == 0 ? "\u52b3\u52a1\u5408\u540c" : "\u4e13\u4e1a\u5408\u540c");
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("processSettle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSettleData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<SettleVO>> refSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/mnyCtrl"}, method={RequestMethod.POST})
    public CommonResponse<ParamsCheckVO> mnyCtrl(@RequestBody SettleVO settleVO) {
        ParamsCheckVO response = this.service.mnyCtrl(settleVO, false);
        if (response == null) {
            this.logger.error("\u8fc7\u7a0b\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u5931\u8d25");
            response = new ParamsCheckVO();
        }
        ParamsCheckVO responseData = this.paramCheck(settleVO, response, false);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    @RequestMapping(value={"/mnyCtrlById"}, method={RequestMethod.GET})
    public CommonResponse<ParamsCheckVO> mnyCtrlById(@RequestParam(value="id") Long id) {
        SettleEntity settle = (SettleEntity)((Object)this.service.selectById(id));
        if (settle == null) {
            return CommonResponse.error((String)"\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728\uff01");
        }
        SettleVO settleVO = (SettleVO)BeanMapper.map((Object)((Object)settle), SettleVO.class);
        ParamsCheckVO response = this.service.mnyCtrl(settleVO, true);
        if (response == null) {
            this.logger.error("\u8fc7\u7a0b\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u5931\u8d25");
            response = new ParamsCheckVO();
        }
        ParamsCheckVO responseData = this.paramCheck(settleVO, response, true);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    private ParamsCheckVO paramCheck(@RequestBody SettleVO settleVO, ParamsCheckVO responseData, boolean flag) {
        String responseDataWarnType = responseData.getWarnType();
        int resWarnTypeInt = ParamCtrlUtil.getWarnTypeInt(responseDataWarnType, 1);
        ParamsCheckVO checkVO = this.service.numCtrl(settleVO, flag);
        String warnType = checkVO.getWarnType();
        if (StringUtils.isNotBlank((CharSequence)warnType) && !"none".equals(warnType)) {
            List list;
            int changeWarnTypeInt = ParamCtrlUtil.getWarnTypeInt(warnType, 2);
            if (changeWarnTypeInt > resWarnTypeInt) {
                return checkVO;
            }
            if (changeWarnTypeInt == resWarnTypeInt && CollectionUtils.isNotEmpty((Collection)(list = checkVO.getDataSource()))) {
                responseData.getDataSource().addAll(list);
            }
        }
        return responseData;
    }
}

