package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.process.bean.MeasureEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.mapper.MeasureMapper;
import com.ejianc.business.process.service.IMeasureService;
import com.ejianc.business.process.vo.MeasureVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包计量实体
 *
 * @author generator
 */
@Service("measureService")
@SuppressWarnings(value = "")
public class MeasureServiceImpl extends BaseServiceImpl<MeasureMapper, MeasureEntity> implements IMeasureService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private JedisPool jedisPool;

    private final String OPERATE = "MEASURE_BILL_SYNC";

    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/measure/billSync";
    private final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/measure/billDel";

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    /**
     * 计量单单据类型编码
     */
    private final String billType = "BT211227000000002";

    // 劳务分包合同-进度计量（移动端）  【合同金额】控【进度计量金额】
    private final String LAB_MEASURE_PARAM_CODE = "P-964Bf984";
    // 专业分包合同-进度计量（移动端）  【合同金额】控【进度计量金额】
    private final String PRO_MEASURE_PARAM_CODE = "P-Ctsd6X85";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IContractService contractService;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Override
    public boolean pushBillToSupCenter(MeasureEntity measureEntity, String billTypeCode, CooperateVO cooperate) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + measureEntity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.executeUpdate(measureEntity.getId(), false);
            logger.error("推送计量单据-{}失败，获取当前系统编码失败,{}", measureEntity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        measureEntity.setSourceSystemId(ejcCloudSystemCode.getData());
        // 清空租户ID
        measureEntity.setTenantId(null);
        if(CollectionUtils.isNotEmpty(measureEntity.getMeasureDetailList())) {
            measureEntity.getMeasureDetailList().forEach(item -> item.setTenantId(null));
        }

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                this.executeUpdate(measureEntity.getId(), false);
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("transData", JSONObject.toJSONString(measureEntity));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(measureEntity.getId(), null, null, null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();

                //Map<fileName, fileSourceType>
                Map<String, String> fileSourceTypeMap = new HashMap<>();
                List<Long> fileIds = new ArrayList<>();

                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }

                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));

                //当前单据携带有附件信息
                if (CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                logger.info("向供应商-{}推送计量单据参数-{}", measureEntity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        measureEntity.getSupplierId().toString(),
                        files);

                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        this.executeUpdate(measureEntity.getId(), true);
                        syncFlag = true;
                    } else {
                        this.executeUpdate(measureEntity.getId(), false);
                        logger.error("供方id-{}处理推送计量单据id-{}失败, {}", measureEntity.getSupplierId(), measureEntity.getId(), billPushResp.getMsg());
                    }
                } else {
                    this.executeUpdate(measureEntity.getId(), false);
                    logger.error("发送请求推送计量单据id-{}给供方id-{}失败, {}", measureEntity.getId(), measureEntity.getSupplierId(), syncReqResp.getMsg());
                }
            } else {
                this.executeUpdate(measureEntity.getId(), false);
                logger.error("获取计量单据id-{}对应附件信息失败, {}", measureEntity.getId(), fileResp.getMsg());
            }

        } catch (Exception e) {
            this.executeUpdate(measureEntity.getId(), false);
            logger.error("推送计量单据id-{}给供方id-{} 异常，", measureEntity.getId(), measureEntity.getSupplierId(), e);
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }


    /**
     * 更新单据推送状态
     * @param id 单据id
     * @param flag 是否成功推送
     */
    private void executeUpdate(Long id,Boolean flag) {
        // 更新协同推送状态
        UpdateWrapper<MeasureEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", id);
        // 修改推送状态
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set("bill_push_flag", BillPushStatusEnum.推送成功.getStatus());
        } else {
            updateWrapper.set("bill_push_flag", BillPushStatusEnum.未成功推送.getStatus());
        }
        super.update(updateWrapper);
    }


    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.valueOf(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        logger.info("接收到单据签章通知：id-{}, supOperatorName-{}, supOperatorPhone-{}, supOperatorUserCode-{}, supOperateTime-{}, nameSourceTypeMapping-{}",
                billId, supOperatorName, supOperatorPhone, supOperatorUserCode, supOperateTime, nameSourceTypeMapping);

        MeasureEntity measure = super.selectById(billId);
        //设置供方签字信息
        measure.setSupOperateTime(supOperateTime);
        measure.setSupOperatorName(supOperatorName);
        measure.setSupOperatorPhone(supOperatorPhone);
        measure.setSupOperatorUserCode(supOperatorUserCode);

        String key = billType + "::" + measure.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字状态更新失败，单据锁获取失败！";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, billType, authority, measure.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            measure.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态
            measure.setSupplierSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());

            //更新单据
            super.saveOrUpdate(measure, false);

            //向单据制单人和经办人推送该消息
            String msgSendResult = sendMsg(measure, "供方已签字提醒", "计量单据[" + measure.getBillCode() + "]供方已签字完成");
            if (null != msgSendResult) {
                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(measure.getCreateUserId(), measure.getEmployeeId()),
                        measure.getId(), msgSendResult);
            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", measure.getId(), e);
            msg = "单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }

    /**
     * 通知用户消息
     *
     * @param measure
     */
    private String sendMsg(MeasureEntity measure, String subject, String content) {

        String[] msgRecUserIds = new String[]{measure.getCreateUserId().toString(), measure.getEmployeeId().toString()};

        logger.info("消息接收人: {}", StringUtils.join(msgRecUserIds, ","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(subject);
        //消息类型
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(measure.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});

        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }

    @Override
    public boolean delPushBill(MeasureEntity measureEntity, String billTypeCode) {
        boolean locked = false, delSuc = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + measureEntity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("通知供方计量单据-{}作废失败，获取当前系统编码失败,{}", measureEntity.getId(), ejcCloudSystemCode.getMsg());
        }
        //设置当前系统ID
        measureEntity.setSourceSystemId(ejcCloudSystemCode.getData());

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("sourceId", measureEntity.getId().toString());
            paramMap.put("sourceSystemId", measureEntity.getSourceSystemId());
            logger.info("计量单据id-{}弃审，通知供方-{}单据作废!", measureEntity.getSupplierId(), measureEntity.getId());

            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(DEL_SUP_BILL_SERVER_URL,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    measureEntity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    delSuc = true;
                } else {
                    logger.error("供方-{}处理作废计量单据id-{}作废失败, {}", measureEntity.getSupplierId(), measureEntity.getId(), supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", measureEntity.getSupplierId(), measureEntity.getId(), syncReqResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", measureEntity.getId(), e);
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return delSuc;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }

    // 劳务/专业分包合同-进度计量（移动端）  【合同金额】控【进度计量金额】  进度计量金额>合同金额*X*%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    @Override
    public ParamsCheckVO mnyCtrl(MeasureVO measureVO, boolean flag) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        // 劳务
        if (0 == measureVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_MEASURE_PARAM_CODE, measureVO.getOrgId());
        }
        // 专业
        if (1 == measureVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_MEASURE_PARAM_CODE, measureVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
//            logger.info("获取控制参数配置失败！");
//            throw new BusinessException("获取控制参数配置失败！");
            return paramsCheckVO;
        }
        List<BillParamVO> data = billParamByCode.getData();
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        for (BillParamVO billParamVO : data) {
            List<ParamsCheckDsVO> dataSource = new ArrayList<>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();

            // 控制规则值  百分比
            BigDecimal roleValue = billParamVO.getRoleValue();
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }

            // 为none时不需要控制
            if (!"none".equals(paramsCheck.getWarnType())) {
                Long contractId = measureVO.getContractId();

                // 查询所在合同下单所有进度计量金额的累加值
                QueryWrapper<MeasureEntity> measureEntityQueryWrapper = new QueryWrapper<>();
                measureEntityQueryWrapper
                        .eq("dr", 0)
                        .eq("tenant_id", InvocationInfoProxy.getTenantid())
                        .eq("contract_id", contractId);
                if (flag && measureVO.getId() != null) {
                    // 排除自己
                    measureEntityQueryWrapper.notIn("id", Arrays.asList(measureVO.getId()));
                }
                measureEntityQueryWrapper.select("sum(total_tax_mny) as totalTaxMny");
                Map<String, Object> measureMnyMap = super.getMap(measureEntityQueryWrapper);
                BigDecimal totalTaxMny = BigDecimal.ZERO;
                if (measureMnyMap != null) {
                    // 查询到的不包含自己的所属合同下的所有进度计量金额的累加值
                    totalTaxMny = measureMnyMap.get("totalTaxMny") != null ? new BigDecimal(measureMnyMap.get("totalTaxMny").toString()) : BigDecimal.ZERO;
                }
                // 当前单据的进度计量金额
                BigDecimal curTotalTaxMny = measureVO.getTotalTaxMny() != null ? measureVO.getTotalTaxMny() : BigDecimal.ZERO;
                // 所有的进度计量金额（当前单据所属合同下的所有进度计量金额的累加值） = 查询到的不包含自己的进度计量金额的累加值 + 当前单据的进度计量金额
                totalTaxMny = totalTaxMny.add(curTotalTaxMny);

                // 查询所在合同
                ContractEntity contractEntity = contractService.selectById(contractId);
                if (contractEntity == null) {
                    logger.info("查询合同失败！");
                    throw new BusinessException("查询合同失败！");
                }

                // 计算 合同金额*X%
                BigDecimal contractTaxMny = contractEntity.getContractTaxMny();
                contractTaxMny = contractTaxMny == null ? BigDecimal.ZERO : contractTaxMny;
                BigDecimal conTaxMny = contractTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP);

                //  进度计量金额 > 合同金额*X%
                if (totalTaxMny.compareTo(conTaxMny) > 0) {
                    BigDecimal overTaxMny = totalTaxMny.subtract(conTaxMny);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("进度计量超合同金额");
                    paramsCheckDsVO.setWarnName("累计进度计量金额大于合同金额");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次进度计量金额：").append(curTotalTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，含本次进度计量金额：").append(totalTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，合同金额*").append(roleValue).append("%：").append(conTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("。超出金额：").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheck.setDataSource(dataSource);
                } else {
                    // 无需控制
                    paramsCheck.setWarnType(paramsArray[0]);
                }
            }
            paramsCheckVOList.add(paramsCheck);
        }

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for(ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }

        return paramsCheckVO;
    }
}
