package com.ejianc.business.prosub.equip.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prosub.equip.vo.EquipUseApplyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.prosub.equip.mapper.EquipUseApplyMapper;
import com.ejianc.business.prosub.equip.bean.EquipUseApplyEntity;
import com.ejianc.business.prosub.equip.service.IEquipUseApplyService;

import java.util.ArrayList;
import java.util.List;

/**
 * 分包机械使用申请
 * 
 * @author generator
 * 
 */
@Service("equipUseApplyService")
public class EquipUseApplyServiceImpl extends BaseServiceImpl<EquipUseApplyMapper, EquipUseApplyEntity> implements IEquipUseApplyService{

    @Override
    public List<EquipUseApplyVO> getAllByIds(List<Long> applyIds) {
        List<EquipUseApplyVO> resp =new ArrayList<>();
        QueryWrapper<EquipUseApplyEntity> query = new QueryWrapper<>();
        query.in("id", applyIds);

        List<EquipUseApplyEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            return BeanMapper.mapList(dbList, EquipUseApplyVO.class);
        }

        return resp;
    }
}
