package com.ejianc.business.process.controller;

import java.io.Serializable;

import com.alibaba.druid.sql.dialect.h2.visitor.H2ASTVisitor;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.process.bean.AdjustDetailEntity;
import com.ejianc.business.process.bean.ApplicationDetailEntity;
import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.service.IAdjustDetailService;
import com.ejianc.business.process.vo.AdjustDetailVO;
import com.ejianc.business.process.vo.ApplicationDetailVO;
import com.ejianc.business.process.vo.ApplicationVO;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.prosub.vo.ContractDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.process.bean.AdjustEntity;
import com.ejianc.business.process.service.IAdjustService;
import com.ejianc.business.process.vo.AdjustVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 分包价格调整与增补
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("adjust")
public class AdjustController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ADJUST_CODE";//此处需要根据实际修改

    @Autowired
    private IAdjustService service;
    @Autowired
    private IAdjustDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AdjustVO> saveOrUpdate(@RequestBody AdjustVO saveOrUpdateVO) {
        AdjustVO vo = service.insertOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AdjustVO> queryDetail(Long id) {
        AdjustVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AdjustVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (AdjustVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(AdjustVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AdjustVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("parentOrgName","orgName","billCode","projectName","contractName","supplierName","changeItems","employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }


        IPage<AdjustEntity> page = service.queryPage(param,false);
        IPage<AdjustVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AdjustVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @RequestMapping(value = "/referTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> referTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         @RequestParam String condition) {
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("parentOrgName","orgName","billCode","projectName","contractName","supplierName","changeItems","employeeName"));

        /** 数据隔离 参数组织orgId本下 */
        JSONObject _con = JSONObject.parseObject(condition);
        if(StringUtils.isNotEmpty(condition)){
            if (_con.containsKey("contractId")){
                queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.getLong("contractId")));
            }
            if (_con.containsKey("useType")){
                queryParam.getParams().put("useType", new Parameter(QueryParam.LIKE, _con.get("useType")));
            }
            if (_con.containsKey("endDate")){
                queryParam.getParams().put("signDate", new Parameter(QueryParam.LE, _con.get("endDate")));
            }
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 已提交的数据 或者 审批通过的数据 */
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<AdjustEntity> dataList = service.queryList(queryParam, false);
        List<Map> resultMapList = new ArrayList<>();
        Map map = null;
        for (AdjustEntity entity : dataList) {
            if (_con.containsKey("useType")) {
                QueryWrapper<AdjustDetailEntity> queryWrapper = new QueryWrapper();
                queryWrapper.eq("pid", entity.getId())
                        .eq("dr", 0)
                        .like(null != _con.get("useType"), "detail_use_type_name", _con.get("useType"))
                        .apply("IFNULL(detail_finish_num,0)>IFNULL(sum_measure_num,0)");
                List<AdjustDetailEntity> adjustDetailEntities = detailService.list(queryWrapper);
                if (CollectionUtils.isEmpty(adjustDetailEntities)) {
                    continue;
                }
            }
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getBillCode());
            map.put("code", entity.getBillCode());
            map.put("parentId", "000001");
            resultMapList.add(map);
        }
        if(CollectionUtils.isNotEmpty(resultMapList)){
            map = new HashMap<>();
            map.put("id", "000001");
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", "000001");
            map.put("name", "全部");
            map.put("code", "000001");
            map.put("parentId", null);
            resultMapList.add(map);
        }

        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value = "/refSubData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> refSubData(@RequestParam Integer pageNumber,
                                                                     @RequestParam Integer pageSize,
                                                                     @RequestParam(required = false) String relyCondition,
                                                                     @RequestParam(required = false) String condition,
                                                                     @RequestParam(required = false) String relyNode,
                                                                     @RequestParam(required = false) String searchText,
                                                                     @RequestParam(required = false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("changeType");
        fuzzyFields.add("detailName");
        fuzzyFields.add("detailWorkContent");
        fuzzyFields.add("detailMeasurementRules");
        fuzzyFields.add("detailUnit");
        Map<String, Parameter> param = queryParam.getParams();


        //是否查询全部
        boolean queryAllFlag = false;
        if (org.apache.commons.lang.StringUtils.isNotEmpty(relyCondition)) {
            String pid = relyCondition.split("=")[1];
            if (!"000001".equals(pid)) {
                param.put("pid", new Parameter(QueryParam.EQ, pid));
                if (StringUtils.isNotBlank(condition) && condition.contains("useType")){
                    param.put("detailUseTypeName", new Parameter(QueryParam.EQ, JSONObject.parseObject(condition).get("useType")));
                }
            } else {
                queryAllFlag = true;
            }
        } else {
            queryAllFlag = true;
        }

        if (org.apache.commons.lang.StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter(QueryParam.LIKE, search.get(key).toString()));
            }
        }

        if (queryAllFlag) {
            if (StringUtils.isEmpty(condition) || !condition.contains("contractId")) {
                throw new BusinessException("查询参数不正确！请传入contractId");
            }
            JSONObject conditionJson = JSONObject.parseObject(condition);
            Long contractId = conditionJson.getLong("contractId");
            LambdaQueryWrapper<AdjustEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(AdjustEntity::getContractId, contractId);
            if (conditionJson.containsKey("endDate")) {
                queryWrapper.le(AdjustEntity::getSignDate, conditionJson.get("endDate"));
            }
            if (conditionJson.containsKey("useType")) {
                //主表查询含该类型的
                queryWrapper.like(AdjustEntity::getUseType, conditionJson.get("useType"));
                //子表查询含该类型的
                param.put("detailUseTypeName", new Parameter(QueryParam.EQ, JSONObject.parseObject(condition).get("useType")));
            }
            queryWrapper.in(AdjustEntity::getBillState,  Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            List<AdjustEntity> list = service.list(queryWrapper);
            if(CollectionUtils.isNotEmpty(list)){
                List<Long> ids = new ArrayList<>();
                for (AdjustEntity entity : list) {
                    ids.add(entity.getId());
                }
                param.put("pid", new Parameter(QueryParam.IN, ids));
            } else {
                param.put("pid", new Parameter(QueryParam.EQ, 1L));
            }
        }
        if (condition.contains("useType")) {
            param.put("111", new Parameter(QueryParam.SQL, "IFNULL(detail_finish_num,0)>IFNULL(sum_measure_num,0)"));
        }
//        IPage<AdjustDetailEntity> pageData = new Page<>(queryParam.getPageIndex(), queryParam.getPageSize());
        IPage<AdjustDetailEntity> pageData = detailService.queryPage(queryParam);

        IPage<AdjustDetailVO> voPage = null;
//        if (pageData != null) {
//            voPage = new Page<>();
//            voPage.setCurrent(pageData.getCurrent());
//            voPage.setPages(pageData.getPages());
//            voPage.setTotal(pageData.getTotal());
//            voPage.setSize(queryParam.getPageSize());
//            voPage.setRecords(BeanMapper.mapList(list.getRecords(), AdjustDetailVO.class));
//        }

        JSONObject page = new JSONObject();
        page.put("records", pageData.getRecords());
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询分包合同数据成功！", page);


//        return CommonResponse.success("查询数表参照成功", voPage);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("parentOrgName","orgName","billCode","projectName","contractName","supplierName","changeItems","employeeName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AdjustEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("Adjust-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refAdjustData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AdjustVO>> refAdjustData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("adjustId")) {
                param.getParams().put("adjustId", new Parameter(QueryParam.EQ, conditionMap.get("adjustId")));
            }
            if(null != conditionMap.get("contractId")) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, conditionMap.get("contractId")));
            }
            if(null != conditionMap.get("useType")) {
                param.getParams().put("useType", new Parameter(QueryParam.EQ, conditionMap.get("useType")));
            }
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<AdjustEntity> page = service.queryPage(param,false);
        IPage<AdjustVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<AdjustVO> voList = BeanMapper.mapList(page.getRecords(), AdjustVO.class);
        if (CollectionUtils.isNotEmpty(voList)){
            List<Long> ids = voList.stream().map(AdjustVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<AdjustDetailEntity> qw = Wrappers.lambdaQuery();
            qw.in(AdjustDetailEntity::getPid,ids)
                    .eq(AdjustDetailEntity::getDr,0);
            List<AdjustDetailEntity> list = detailService.list(qw);
            Map<Long, List<AdjustDetailEntity>> detailListMap = list.stream().collect(Collectors.groupingBy(AdjustDetailEntity::getPid));
            for (AdjustVO adjustVO : voList) {
                adjustVO.setAdjustDetailList(BeanMapper.mapList(detailListMap.get(adjustVO.getId()),AdjustDetailVO.class));
            }
        }
        pageData.setRecords(voList);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download", method = RequestMethod.POST)
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "adjust-detail-import.xlsx", "分包价格调整与增补-详情");
    }
    /**
     * 其他分包合同明明细导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadOther", method = RequestMethod.POST)
    @ResponseBody
    public void downloadOther(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "adjustOther-detail-import.xlsx", "其他分包明细表");
    }
    @RequestMapping(value = "/downloadEquipment", method = RequestMethod.POST)
    @ResponseBody
    public void downloadEquipment(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "adjustEquipment-detail-import.xlsx", "特种设备明细表");
    }
    @RequestMapping(value = "/importOtherData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> importOtherData(HttpServletRequest request, HttpServletResponse response){
        return service.importOtherData(request,response);
    }
    @RequestMapping(value = "/importEquipmentData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> importEquipmentData(HttpServletRequest request, HttpServletResponse response) {
        return service.importEquipmentData(request,response);
    }
    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/import", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> importData(Integer type,HttpServletRequest request, HttpServletResponse response) {
        return service.importData(type, request, response);
    }
}
