package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.enums.SignatureStatusEnum;
import com.ejianc.business.settle.service.IFinishSettleService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 结算主实体
 *
 * @author generator
 */
@RestController
@RequestMapping("finishSettle")
public class FinishSettleController implements Serializable {
    private static final long serialVersionUID = 1L;

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFinishSettleService service;

    @Autowired
    private ISettleService settleService;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Autowired
    private IExecutionApi executionApi;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        SettleVO vo = service.saveFinishSettle(saveOrUpdateVO);
        // 获取结算明细
        List<SettleDetailVO> voList = vo.getSettleDetailList();
        if (!voList.isEmpty()) {
            for (SettleDetailVO detail : voList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0 ? String.valueOf(detail.getParentId()) : null);
            }
            vo.setSettleDetailList(TreeNodeBUtil.buildTree(voList));
        }
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleEntity entity = service.selectById(id);
        if (entity == null) {
            CommonResponse.error("查询详情异常！");
        }
        SettleVO vo = BeanMapper.map(entity, SettleVO.class);
        List<SettleDetailVO> detailList = vo.getSettleDetailList();
        if (!detailList.isEmpty()) {
            for (SettleDetailVO detail : detailList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0 ? String.valueOf(detail.getParentId()) : null);
                detail.setParentId(null != detail.getTpid() ? Long.valueOf(detail.getTpid()) : null);
            }
            vo.setSettleDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        //检查非自由态或驳回太单据不可删除
        List<Long> billIds = vos.stream().map(SettleVO::getId).collect(Collectors.toList());
        String checkResult = settleService.delCheck(billIds);
        if(StringUtils.isNotBlank(checkResult)) {
            return CommonResponse.error(checkResult);
        }
        //删除策划成本推送数据
        settleService.delSettleTargetCostInfo(billIds);
        //删除实际成本池数据
        settleService.delSettleCostInfo(billIds);
//        String delMsg = service.delBatch(billIds);
//        if(StringUtils.isNotBlank(delMsg)) {
//            return CommonResponse.error("结算单删除失败， 对应合同【" + delMsg +"】状态更新失败！");
//        }
        service.removeByIds(billIds, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 结算类型：0-过程，1-完工，2-节点
        param.getParams().put("settle_type", new Parameter(QueryParam.EQ, SettleTypeEnum.完工.getCode()));

        //查询本下
        Long orgId = InvocationInfoProxy.getOrgId();
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<SettleEntity> page = service.queryPage(param, false);
        IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleVO.class));
        List<SettleVO> records = pageData.getRecords();
        List<SettleVO> ans = pageData.getRecords();
        for (SettleVO vo : records) {
            if(vo.getSumApproveTaxMny() == null || Objects.equals(vo.getSumApproveTaxMny(), BigDecimal.ZERO)){
                vo.setSumApproveTaxMny(vo.getSumReportTaxMny());
            }
            //结算金额-中间计量
            vo.setTotalNodeTaxDifference(vo.getSumApproveTaxMny().subtract(vo.getTaxMny()));
            ans.add(vo);
        }
        pageData.setRecords(ans);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 结算类型：0-过程，1-完工，2-节点
        param.getParams().put("settle_type", new Parameter(QueryParam.EQ, SettleTypeEnum.完工.getCode()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SettleEntity> list = service.queryList(param);
        List<SettleVO> voList = BeanMapper.mapList(list, SettleVO.class);
        // 字段翻译
        voList.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            // fixme 签字状态待定
            vo.setSignStatusName(Objects.equals(vo.getSupplierSignStatus(), SupplierSignStatusEnum.乙方未签字.getCode()) ? "乙方未签字" : "乙方已签字");
            vo.setSignatureStatusName(SignatureStatusEnum.getEnumByCode(vo.getSignatureStatus()).getDescription());
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("finishSettle-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSettleData", method = RequestMethod.GET)
    public CommonResponse<IPage<SettleVO>> refSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettleEntity> page = service.queryPage(param, false);
        IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @Description queryUnusedContract 查询合同是否被完工使用
     * 完工结算时 判断上游业务：分包计量，领料结算，零工登记，奖罚扣款单；
     * 是否有审批中的单据，如果有不允许进行完工结算
     * @param contractId
     */
    @RequestMapping(value = "/queryUnusedContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType) {
        return service.queryUnusedContract(contractId, settleDate, settleType);
    }

    /**
     * 查询当前合同是否存在王国结算单据 自由态的也不行
     */
    @RequestMapping(value = "/queryFinishFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse queryFinishFlag(Long contractId) {
        return service.queryFinishFlag(contractId);
    }



    @RequestMapping(value = "/mnyCtrl", method=RequestMethod.POST)
    public CommonResponse<ParamsCheckVO> mnyCtrl(@RequestBody SettleVO settleVO) {
        ParamsCheckVO response = service.mnyCtrl(settleVO);
        if (response == null) {
            logger.error("最终结算金额控制失败");
            response = new ParamsCheckVO();
        }
        ParamsCheckVO responseData = paramCheck(settleVO, response, false);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    @RequestMapping(value = "/mnyCtrlById", method=RequestMethod.GET)
    public CommonResponse<ParamsCheckVO> mnyCtrlById(@RequestParam(value = "id") Long id) {
        SettleEntity settle = service.selectById(id);
        if (settle == null) {
            return CommonResponse.error("结算单不存在！");
        }
        SettleVO settleVO = BeanMapper.map(settle, SettleVO.class);
        ParamsCheckVO response = service.mnyCtrl(settleVO);
        if (response == null) {
            logger.error("最终结算金额控制失败");
            response = new ParamsCheckVO();
        }
        ParamsCheckVO responseData = paramCheck(settleVO, response, true);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    /**
     * 劳务/专业分包合同—完工结算  【合同量】控【完工结算量】  合同完工结算量 > 合同数量*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     * 1、末级清单控制
     * 2、合同数量：取最新版本合同数量；
     * 3、结算数量：含本期完工结算量；(根据合同清单维度)
     *
     * @param settleVO
     * @param responseData
     * @param flag
     * @return
     */
    private ParamsCheckVO paramCheck(@RequestBody SettleVO settleVO, ParamsCheckVO responseData, boolean flag) {
        String responseDataWarnType = responseData.getWarnType();
        int resWarnTypeInt = ParamCtrlUtil.getWarnTypeInt(responseDataWarnType, 1);
        // 校验  劳务/专业分包合同—完工结算  合同量】控【完工结算量】  合同完工结算量 > 合同数量*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
        ParamsCheckVO checkVO = service.numCtrl(settleVO, flag);
        String warnType = checkVO.getWarnType();
        if (StringUtils.isNotBlank(warnType) && !"none".equals(warnType)) {
            // 如果大于之前的提醒等级，则使用当前的提醒等级
            int changeWarnTypeInt = ParamCtrlUtil.getWarnTypeInt(warnType, 2);
            if (changeWarnTypeInt > resWarnTypeInt) {
                return checkVO;
            } else if(changeWarnTypeInt == resWarnTypeInt) {
                List<ParamsCheckDsVO> list = checkVO.getDataSource();
                if (CollectionUtils.isNotEmpty(list)) {
                    responseData.getDataSource().addAll(list);
                }
            }

        }
        return responseData;
    }


    /**
     * 完工结算策划成本推送
     *
     * @param id 结算单id
     *
     * @return CommonResponse
     */
    @GetMapping(value = "/pushTargetCost")
    public CommonResponse<String> pushTargetCost(@RequestParam("id") Long id) {
        SettleEntity settleEntity = service.selectById(id);
        SettleVO settleVO = service.getPushTargetCostSettleVO(settleEntity);

        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = BASE_HOST;
        }

        String linkUrl;
        if (settleVO.getContractType() == 0) {
            linkUrl = frontendBaseHost + "ejc-prosub-frontend/#/finishSettle/laborsub/card?id=" + settleVO.getId();
        } else {
            linkUrl = frontendBaseHost + "ejc-prosub-frontend/#/finishSettle/prosub/card?id=" + settleVO.getId();
        }
        ExecutionVO executionVO = service.targetCost(settleVO, linkUrl, settleVO.getContractType());
        logger.info("手动：完工结算策划成本推送数据： {}", JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        logger.info("手动：完工结算策划成本推送数据结果： {}", JSON.toJSONString(response));
        return response;
    }

}
