package com.ejianc.business.plan.controller;

import java.io.Serializable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.business.plan.service.IPlanChangeHisService;
import com.ejianc.business.plan.vo.PlanChangeHisVO;

/**
 * 分包总计划变更记录实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("planChangeHis")
public class PlanChangeHisController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPlanChangeHisService service;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanChangeHisVO> queryDetail(Long id) {
        PlanChangeHisVO vo = null;
        vo = service.queryDetail(id,true);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
