package com.ejianc.business.process.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 班组主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_team")
public class TeamEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否主合同：0-主合同 1-补充协议
    @TableField(value="compile_name")
    private String compileName; // 编制人
    @TableField(value="compile_id")
    private Long compileId; // 编制人id 
    @TableField(value="compile_date")
    private Date compileDate; // 编制日期
    @TableField(value="org_id")
    private Long orgId; // 项目组织ID
    @TableField(value="org_name")
    private String orgName; // 项目组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织id
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="commit_data")
    private Date commitData; // 提交日期
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="bill_code")
    private String billCode; // 编码
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名字
    @TableField(value = "contract_type")
    private Integer contractType; //合同类型：0-劳务合同 1-专业合同
    @TableField(value = "contract_type_name")
    private String contractTypeName;//合同类型名称

    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 项目名称（带入）
    @TableField(value="project_code")
    private String projectCode; // 项目编号

    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value = "team_users")
    private String teamUsers;//班组

    @TableField(exist=false)
    @SubEntity(serviceName="teamDetailService",pidName ="teamId")
    private List<TeamDetailEntity> teamDetailList = new ArrayList<>(); // 班组子表

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public String getTeamUsers() {
        return teamUsers;
    }

    public void setTeamUsers(String teamUsers) {
        this.teamUsers = teamUsers;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public List<TeamDetailEntity> getTeamDetailList() {
        return teamDetailList;
    }

    public void setTeamDetailList(List<TeamDetailEntity> teamDetailList) {
        this.teamDetailList = teamDetailList;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public String getCompileName() {
        return compileName;
    }

    public void setCompileName(String compileName) {
        this.compileName = compileName;
    }
    public Long getCompileId() {
        return compileId;
    }

    public void setCompileId(Long compileId) {
        this.compileId = compileId;
    }
    public Date getCompileDate() {
        return compileDate;
    }

    public void setCompileDate(Date compileDate) {
        this.compileDate = compileDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getCommitData() {
        return commitData;
    }

    public void setCommitData(Date commitData) {
        this.commitData = commitData;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    
}
