package com.ejianc.business.prosub.controller;

import com.ejianc.business.prosub.mapper.ContractManagementMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("contractManagement")
public class ContractManagementController {

    @Autowired
    private ContractManagementMapper mapper;

    @GetMapping(value = "/lwfbht")
    public CommonResponse<List<Map<String, Object>>>
    analysisSelect(@RequestParam(value = "id", required = false) Long projectId) {
        List<Map<String, Object>> ans = new ArrayList<>();
        //劳务分包合同
        Map<String, Object> contractMap0 = mapper.contractMapper(0);
        ans.add(contractMap0);
        //专业分包合同
        Map<String, Object> contractMap1 = mapper.contractMapper(1);
        ans.add(contractMap1);
        //物资采购合同
        Map<String, Object> promaterialMap0 = mapper.promaterialMapper(0);
        ans.add(promaterialMap0);
        //混凝土采购合同
        Map<String, Object> promaterialMap1 = mapper.promaterialMapper(1);
        ans.add(promaterialMap1);
        //周转材租赁合同
        Map<String, Object> prormatContracMapper = mapper.prormatContracMapper();
        ans.add(prormatContracMapper);
        //施工机械租赁合同
        Map<String, Object> rentContractMapper = mapper.rentContractMapper();
        ans.add(rentContractMapper);
        //处置合同
        Map<String, Object> otherContractMapper = mapper.otherContractMapper();
        ans.add(otherContractMapper);
        //统计最后数据
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/fbfqzspd")
    public CommonResponse<List<Map<String, Object>>> fbfqzspdSelect(@RequestParam(value = "id", required = false) Long projectId) {
        List<Map<String, Object>> ans = new ArrayList<>();
        //发包方签证索赔记录单
        Map<String, Object> claimRecordsMapper = mapper.claimRecordsMapper();
        ans.add(claimRecordsMapper);
        //发包方签证索赔办理
        Map<String, Object> incomeClaimMapper = mapper.incomeClaimMapper();
        ans.add(incomeClaimMapper);
        //形象进度单
        Map<String, Object> incomeProgressMapper = mapper.incomeProgressMapper();
        ans.add(incomeProgressMapper);
        //对发包方报量
        Map<String, Object> quoteMapper = mapper.incomeQuoteMapper();
        ans.add(quoteMapper);
        //竣工结算单
        Map<String, Object> incomeFinalizedMapper = mapper.incomeFinalizedMapper();
        ans.add(incomeFinalizedMapper);
        //项目预算书
        Map<String, Object> budgetMapper = mapper.incomeBudgetMapper();
        ans.add(budgetMapper);
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/wzgl")
    public CommonResponse<List<Map<String, Object>>> wzglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        List<Map<String, Object>> ans = new ArrayList<>();
        //分项需用计划
        Map<String, Object> promaterialPlanMapper = mapper.promaterialPlanMapper();
        ans.add(promaterialPlanMapper);
        //单项采购计划
        Map<String, Object> stringObjectMap = mapper.singlePlanMapper();
        ans.add(stringObjectMap);
        //配送计划
        Map<String, Object> promaterialOrderMapper = mapper.promaterialOrderMapper();
        ans.add(promaterialOrderMapper);
        //材料验收
        Map<String, Object> promaterialCheckMapper = mapper.promaterialCheckMapper();
        ans.add(promaterialCheckMapper);
        //材料入库
        Map<String, Object> checkStoreMapper = mapper.checkStoreMapper();
        ans.add(checkStoreMapper);
        //直入直出
        Map<String, Object> concreteCheckMapper = mapper.concreteCheckMapper();
        ans.add(concreteCheckMapper);
        //领料出库
        Map<String, Object> outStoreMapper = mapper.outStoreMapper();
        ans.add(outStoreMapper);
        //对账结算（通用）
        Map<String, Object> settlementMapper0 = mapper.promaterialSettlementMapper(0);
        ans.add(settlementMapper0);
        //对账结算（钢材）
        Map<String, Object> settlementMapper2 = mapper.promaterialSettlementMapper(2);
        ans.add(settlementMapper2);
        //对账结算（混泥土）
        Map<String, Object> settlementMapper1 = mapper.promaterialSettlementMapper(1);
        ans.add(settlementMapper1);
        //物资鉴定
        Map<String, Object> storeDefinitionMapper = mapper.storeDefinitionMapper();
        ans.add(storeDefinitionMapper);
        //处置申请
        Map<String, Object> storeApplyMapper = mapper.storeApplyMapper();
        ans.add(storeApplyMapper);
        //处置明细\
        Map<String, Object> disposeMapper = mapper.storeDisposeMapper();
        ans.add(disposeMapper);
        //对账结算
        Map<String, Object> storeSettleMapper = mapper.storeSettleMapper();
        ans.add(storeSettleMapper);
        //统计结果
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/fenbfswgl")
    public CommonResponse<List<Map<String, Object>>> fenbfswglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        List<Map<String, Object>> ans = new ArrayList<>();
        //分包招标控制价
        Map<String, Object> prosubControlMapper = mapper.prosubControlMapper();
        ans.add(prosubControlMapper);
        //项目分包施工指令单
        Map<String, Object> oldjobApplicationMapper = mapper.oldjobApplicationMapper();
        ans.add(oldjobApplicationMapper);
        //合同外分包签证办理
        Map<String, Object> oldjobRegistrationMapper = mapper.oldjobRegistrationMapper();
        ans.add(oldjobRegistrationMapper);
        //分包价格调整与增补
        Map<String, Object> adjustMapper = mapper.priceAdjustMapper();
        ans.add(adjustMapper);
        //分包单位扣罚款
        Map<String, Object> prosubDeductionMapper = mapper.prosubDeductionMapper();
        ans.add(prosubDeductionMapper);
        //分包形象进度审核表
        Map<String, Object> prosubProgressMapper = mapper.prosubProgressMapper();
        ans.add(prosubProgressMapper);
        // 分包中间计量
        Map<String, Object> prosubSettleMapper0 = mapper.prosubSettleMapper(0);
        ans.add(prosubSettleMapper0);
        // 分包结算
        Map<String, Object> prosubSettleMapper1 = mapper.prosubSettleMapper(1);
        ans.add(prosubSettleMapper1);
        //统计结果
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    private static void tjsj(List<Map<String, Object>> ans) {
        //统计最后数据
        long we = 0, mo = 0, to = 0;
        for (Map<String, Object> an : ans) {
            we += an.get("weekly") == null ? 0 : Long.parseLong(an.get("weekly").toString());
            mo += an.get("monthly") == null ? 0 : Long.parseLong(an.get("monthly").toString());
            to += an.get("total") == null ? 0 : Long.parseLong(an.get("total").toString());
        }
        Map<String, Object> tjjg = new HashMap<>();
        tjjg.put("weekly", we);
        tjjg.put("monthly", mo);
        tjjg.put("total", to);
        ans.add(tjjg);
    }


}
