package com.ejianc.business.prosub.controller;

import com.ejianc.business.prosub.mapper.ContractManagementMapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("contractManagement")
public class ContractManagementController {

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ContractManagementMapper mapper;

    @GetMapping(value = "/lwfbht")
    public CommonResponse<List<Map<String, Object>>>
    analysisSelect(@RequestParam(value = "id", required = false) Long projectId) {
        List<Map<String, Object>> ans = new ArrayList<>();
        List<Long> orgIds = getOrgIds();
        //劳务分包合同
        Map<String, Object> contractMap0 = mapper.contractMapper(0, orgIds);
        ans.add(contractMap0);
        //专业分包合同
        Map<String, Object> contractMap1 = mapper.contractMapper(1, orgIds);
        ans.add(contractMap1);
        //物资采购合同
        Map<String, Object> promaterialMap0 = mapper.promaterialMapper(0, orgIds);
        ans.add(promaterialMap0);
        //混凝土采购合同
        Map<String, Object> promaterialMap1 = mapper.promaterialMapper(1, orgIds);
        ans.add(promaterialMap1);
        //周转材租赁合同
        Map<String, Object> prormatContracMapper = mapper.prormatContracMapper(orgIds);
        ans.add(prormatContracMapper);
        //施工机械租赁合同
        Map<String, Object> rentContractMapper = mapper.rentContractMapper(orgIds);
        ans.add(rentContractMapper);
        //处置合同
        Map<String, Object> otherContractMapper = mapper.otherContractMapper(orgIds);
        ans.add(otherContractMapper);
        //统计最后数据
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    private List<Long> getOrgIds() {
        CommonResponse<List<OrgVO>> children = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        List<Long> orgIds = children.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        return orgIds;
    }

    @GetMapping(value = "/fbfqzspd")
    public CommonResponse<List<Map<String, Object>>> fbfqzspdSelect(@RequestParam(value = "id", required = false) Long projectId) {
        List<Map<String, Object>> ans = new ArrayList<>();
        List<Long> orgIds = getOrgIds();
        //发包方签证索赔记录单
        Map<String, Object> claimRecordsMapper = mapper.claimRecordsMapper(orgIds);
        ans.add(claimRecordsMapper);
        //发包方签证索赔办理
        Map<String, Object> incomeClaimMapper = mapper.incomeClaimMapper(orgIds);
        ans.add(incomeClaimMapper);
        //形象进度单
        Map<String, Object> incomeProgressMapper = mapper.incomeProgressMapper(orgIds);
        ans.add(incomeProgressMapper);
        //对发包方报量
        Map<String, Object> quoteMapper = mapper.incomeQuoteMapper(orgIds);
        ans.add(quoteMapper);
        //竣工结算单
        Map<String, Object> incomeFinalizedMapper = mapper.incomeFinalizedMapper(orgIds);
        ans.add(incomeFinalizedMapper);
        //项目预算书
        Map<String, Object> budgetMapper = mapper.incomeBudgetMapper(orgIds);
        ans.add(budgetMapper);
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/wzgl")
    public CommonResponse<List<Map<String, Object>>> wzglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        List<Map<String, Object>> ans = new ArrayList<>();
        List<Long> orgIds = getOrgIds();
        //分项需用计划
        Map<String, Object> promaterialPlanMapper = mapper.promaterialPlanMapper(orgIds);
        ans.add(promaterialPlanMapper);
        //单项采购计划
        Map<String, Object> stringObjectMap = mapper.singlePlanMapper(orgIds);
        ans.add(stringObjectMap);
        //配送计划
        Map<String, Object> promaterialOrderMapper = mapper.promaterialOrderMapper(orgIds);
        ans.add(promaterialOrderMapper);
        //材料验收
        Map<String, Object> promaterialCheckMapper = mapper.promaterialCheckMapper(orgIds);
        ans.add(promaterialCheckMapper);
        //材料入库
        Map<String, Object> checkStoreMapper = mapper.checkStoreMapper(orgIds);
        ans.add(checkStoreMapper);
        //直入直出
        Map<String, Object> concreteCheckMapper = mapper.concreteCheckMapper(orgIds);
        ans.add(concreteCheckMapper);
        //领料出库
        Map<String, Object> outStoreMapper = mapper.outStoreMapper(orgIds);
        ans.add(outStoreMapper);
        //对账结算（通用）
        Map<String, Object> settlementMapper0 = mapper.promaterialSettlementMapper(0, orgIds);
        ans.add(settlementMapper0);
        //对账结算（钢材）
        Map<String, Object> settlementMapper2 = mapper.promaterialSettlementMapper(2, orgIds);
        ans.add(settlementMapper2);
        //对账结算（混泥土）
        Map<String, Object> settlementMapper1 = mapper.promaterialSettlementMapper(1, orgIds);
        ans.add(settlementMapper1);
        //物资鉴定
        Map<String, Object> storeDefinitionMapper = mapper.storeDefinitionMapper(orgIds);
        ans.add(storeDefinitionMapper);
        //处置申请
        Map<String, Object> storeApplyMapper = mapper.storeApplyMapper(orgIds);
        ans.add(storeApplyMapper);
        //处置明细\
        Map<String, Object> disposeMapper = mapper.storeDisposeMapper(orgIds);
        ans.add(disposeMapper);
        //对账结算
        Map<String, Object> storeSettleMapper = mapper.storeSettleMapper(orgIds);
        ans.add(storeSettleMapper);
        //统计结果
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/fenbfswgl")
    public CommonResponse<List<Map<String, Object>>> fenbfswglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        List<Map<String, Object>> ans = new ArrayList<>();
        List<Long> orgIds = getOrgIds();
        //分包招标控制价
        Map<String, Object> prosubControlMapper = mapper.prosubControlMapper(orgIds);
        ans.add(prosubControlMapper);
        //项目分包施工指令单
        Map<String, Object> oldjobApplicationMapper = mapper.oldjobApplicationMapper(orgIds);
        ans.add(oldjobApplicationMapper);
        //合同外分包签证办理
        Map<String, Object> oldjobRegistrationMapper = mapper.oldjobRegistrationMapper(orgIds);
        ans.add(oldjobRegistrationMapper);
        //分包价格调整与增补
        Map<String, Object> adjustMapper = mapper.priceAdjustMapper(orgIds);
        ans.add(adjustMapper);
        //分包单位扣罚款
        Map<String, Object> prosubDeductionMapper = mapper.prosubDeductionMapper(orgIds);
        ans.add(prosubDeductionMapper);
        //分包形象进度审核表
        Map<String, Object> prosubProgressMapper = mapper.prosubProgressMapper(orgIds);
        ans.add(prosubProgressMapper);
        // 分包中间计量
        Map<String, Object> prosubSettleMapper0 = mapper.prosubSettleMapper(0, orgIds);
        ans.add(prosubSettleMapper0);
        // 分包结算
        Map<String, Object> prosubSettleMapper1 = mapper.prosubSettleMapper(1, orgIds);
        ans.add(prosubSettleMapper1);
        //统计结果
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/jsgli")
    public CommonResponse<List<Map<String, Object>>> jsgliSelect(@RequestParam(value = "id", required = false) Long projectId) {
        List<Map<String, Object>> ans = new ArrayList<>();
//        图纸登记
        List<Long> orgIds = getOrgIds();
        Map<String, Object> drawingRegistrationMapper = mapper.drawingRegistrationMapper(orgIds);
        ans.add(drawingRegistrationMapper);
//        图纸会审
        Map<String, Object> tecDrawingTriageMapper = mapper.tecDrawingTriageMapper(orgIds);
        ans.add(tecDrawingTriageMapper);
//        设计变更
        Map<String, Object> tecDesignChangeMapper = mapper.tecDesignChangeMapper(orgIds);
        ans.add(tecDesignChangeMapper);
//        施工方案
        Map<String, Object> constructionSchemeMapper = mapper.constructionSchemeMapper(orgIds);
        ans.add(constructionSchemeMapper);
//        施工方案交底
        Map<String, Object> disclosureMapper = mapper.constructionDisclosureMapper(orgIds);
        ans.add(disclosureMapper);
//        分项工程质量技术交底
        Map<String, Object> qualitiedDisclosureMapper = mapper.qualityDisclosureMapper(orgIds);
        ans.add(qualitiedDisclosureMapper);
//        分项工程安全技术交底
        Map<String, Object> safetyDisclosureMapper = mapper.safetyDisclosureMapper(orgIds);
        ans.add(safetyDisclosureMapper);
//        设计变更交底
        Map<String, Object> changeDisclosureMapper = mapper.changeDisclosureMapper(orgIds);
        ans.add(changeDisclosureMapper);
        //统计结果
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/zlgl")
    public CommonResponse<List<Map<String, Object>>> zlglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        List<Map<String, Object>> ans = new ArrayList<>();
        List<Long> orgIds = getOrgIds();
//        质量隐患检查
        Map<String, Object> sceneCheckMapper = mapper.sceneCheckMapper(orgIds);
        ans.add(sceneCheckMapper);
//        待整改
        Map<String, Object> sceneCheckDetailMapper1 = mapper.sceneCheckDetailMapper(1, orgIds);
        ans.add(sceneCheckDetailMapper1);
//        待复查
        Map<String, Object> sceneCheckDetailMapper2 = mapper.sceneCheckDetailMapper(2, orgIds);
        ans.add(sceneCheckDetailMapper2);
//        质量隐患检查台账
        Map<String, Object> sceneCheckListMapper = mapper.sceneCheckListMapper(0, orgIds);
        ans.add(sceneCheckListMapper);
//        QC小组注册
        Map<String, Object> qualityRegisterMapper = mapper.qualityRegisterMapper(orgIds);
        ans.add(qualityRegisterMapper);
//        QC小组课题登记
        Map<String, Object> qualitySubjectMapper = mapper.qualitySubjectMapper(orgIds);
        ans.add(qualitySubjectMapper);
//        QC小组活动成果
        Map<String, Object> qualityActivityMapper = mapper.qualityActivityMapper(orgIds);
        ans.add(qualityActivityMapper);
        //统计结果
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/aqjc")
    public CommonResponse<List<Map<String, Object>>> aqjcSelect(@RequestParam(value = "id", required = false) Long projectId) {
        //安全管理
        List<Map<String, Object>> ans = new ArrayList<>();
        List<Long> orgIds = getOrgIds();
//        安全隐患检查
        Map<String, Object> sceneCheckMapper = mapper.sceneCheckMapper(orgIds);
        ans.add(sceneCheckMapper);
//        待整改
        Map<String, Object> sceneCheckDetailMapper1 = mapper.sceneCheckDetailMapper(1, orgIds);
        ans.add(sceneCheckDetailMapper1);
//        待复查
        Map<String, Object> sceneCheckDetailMapper2 = mapper.sceneCheckDetailMapper(2, orgIds);
        ans.add(sceneCheckDetailMapper2);
//        安全隐患检查台账
        Map<String, Object> sceneCheckListMapper = mapper.sceneCheckListMapper(0, orgIds);
        ans.add(sceneCheckListMapper);
        //统计结果
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    private static void tjsj(List<Map<String, Object>> ans) {
        //统计最后数据
        long we = 0, mo = 0, to = 0;
        for (Map<String, Object> an : ans) {
            we += an.get("weekly") == null ? 0 : Long.parseLong(an.get("weekly").toString());
            mo += an.get("monthly") == null ? 0 : Long.parseLong(an.get("monthly").toString());
            to += an.get("total") == null ? 0 : Long.parseLong(an.get("total").toString());
        }
        Map<String, Object> tjjg = new HashMap<>();
        tjjg.put("weekly", we);
        tjjg.put("monthly", mo);
        tjjg.put("total", to);
        ans.add(tjjg);
    }


}
