package com.ejianc.business.process.service;

import com.ejianc.business.process.bean.RegistrationEntity;
import com.ejianc.business.process.vo.RegistrationVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;

/**
 * 零工登记主实体
 * 
 * @author generator
 * 
 */
public interface IRegistrationService extends IBaseService<RegistrationEntity> {



    CommonResponse<RegistrationVO> getCommonById(Long id);


    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    /**
     * 单据推送供应商
     *
     * @param entity 零工登记单
     * @param billTypeCode 零工登记单据类型编码
     * @param cooperateVO 零工登记协同设置
     * @return
     */
    boolean pushBillToSupCenter(RegistrationEntity entity, String billTypeCode, CooperateVO cooperateVO);

    /**
     * 零工登记单作废通知供方
     *
     * @param entity 要作废的零工登记单
     * @param billTypeCode 零工登记单单据类型编码
     * @return
     */
    boolean delPushBill(RegistrationEntity entity, String billTypeCode);

    ParamsCheckVO mnyCtrl(RegistrationVO registrationVO);

    /**
     * 更新零工申请登记状态
     * @param applicationId 零工申请单id
     * @param userFlag 登记状态
     */
    void updateUseFlag(Long applicationId, Integer userFlag,Integer visaState);
}
