package com.ejianc.business.prosub.dataModel.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.service.IPlanDetailService;
import com.ejianc.business.prosub.bean.ChangeDetailEntity;
import com.ejianc.business.prosub.bean.ChangeEntity;
import com.ejianc.business.prosub.bean.ContractDetailEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.dataModel.enums.DetailSourceTypeEnum;
import com.ejianc.business.prosub.dataModel.service.IDataModelService;
import com.ejianc.business.prosub.dataModel.vo.ContractDataModelVO;
import com.ejianc.business.prosub.enums.ChangeStatusEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.mapper.ContractDetailMapper;
import com.ejianc.business.prosub.service.IChangeDetailService;
import com.ejianc.business.prosub.service.IChangeService;
import com.ejianc.business.prosub.service.IContractDetailService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;


@Service("dataModelService")
public class DataModelServiceImpl implements IDataModelService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService contractService;

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private IChangeDetailService changeDetailService;

    @Autowired
    private ContractDetailMapper contractDetailMapper;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private ISettleDetailService settleDetailService;

    @Autowired
    private IChangeService changeService;

    @Autowired
    private IPlanDetailService planDetailService;

    @Autowired
    private IDutyApi dutyApi;




    @Override
    public List<ContractDataModelVO> queryListByContract(JSONObject param) {
        /*
            本代码很乱
            第一版是合同维度下主合同、变更、结算显示的信息都是一致的
            第二版是合同维度下主合同、变更、结算显示的信息都不一样，只显示本单据的清单内容
            所以，凑合看吧
         */
        Long contractId;
        List<SettleDetailEntity> settleDetailEntityList = new ArrayList<>();
        String billTypeCode = null;
        if (param != null){
            logger.info("合同情况入参：" + JSONObject.toJSONString(param));
            Object bill = param.get("bill");
            JSONObject content = new JSONObject((HashMap) bill);
            logger.info("获得单据内容：{}", JSONObject.toJSONString(content));
            billTypeCode = (String) param.get("billTypeCode");
            Long billTypeId = content.getLong("id");
            if (null == billTypeId){
                return new ArrayList<>();
            }
            logger.info("获得单据类型：{}", billTypeCode);
            if (StringUtils.isNotBlank(billTypeCode) && (billTypeCode.equals(ProsubBillTypeEnum.劳务分包合同.getBillTypeCode()) || billTypeCode.equals(ProsubBillTypeEnum.专业分包合同.getBillTypeCode()) || billTypeCode.equals(ProsubBillTypeEnum.特种设备租赁合同.getBillTypeCode()) || billTypeCode.equals(ProsubBillTypeEnum.其他分包合同.getBillTypeCode()))){
                //合同
                contractId = content.getLong("id");

            }else if (StringUtils.isNotBlank(billTypeCode) && (billTypeCode.equals(ProsubBillTypeEnum.劳务分包合同变更.getBillTypeCode()) || billTypeCode.equals(ProsubBillTypeEnum.专业分包合同变更.getBillTypeCode())
                    || billTypeCode.equals(ProsubBillTypeEnum.特种设备租赁合同变更.getBillTypeCode())  || billTypeCode.equals(ProsubBillTypeEnum.其他分包合同变更.getBillTypeCode())
            )){
                //变更
                contractId = content.getLong("contractId");
            }else {
                //结算
                JSONObject contractIdObject = new JSONObject((HashMap) content.get("contractId"));
                contractId = contractIdObject.getLong("id");
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("settleId", new Parameter(QueryParam.EQ, billTypeId));
                queryParam.getParams().put("settleNum", new Parameter(QueryParam.NE, null));
                settleDetailEntityList = settleDetailService.queryList(queryParam);
            }
            logger.info("获得合同id：{}", contractId);
        }else {
            //测试用   合同：yst数据测试--参数----勿动
//            contractId = 1552975212769120258L;

            //测试变更
//            contractId = 1572770436950167554L;

            //测试结算   合同：yst数据测试--参数----勿动
            contractId = 1552975212769120258L;
//            contractId = 1572767216966209538L;
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("settleId", new Parameter(QueryParam.EQ, 629279231448858629L));
//            queryParam.getParams().put("settleId", new Parameter(QueryParam.EQ, 627881504143982634L));
            queryParam.getParams().put("settleNum", new Parameter(QueryParam.NE, null));
            settleDetailEntityList = settleDetailService.queryList(queryParam);
            billTypeCode = ProsubBillTypeEnum.劳务分包合同过程结算.getBillTypeCode();
        }

        // 获得合同子表信息
        ContractEntity contractEntity = contractService.selectById(contractId);
        if (contractEntity == null){
            throw new BusinessException("获取合同信息有误，请检查请求参数contractId");
        }

        //如果当前合同在变更中，查询变更合同的状态是否在审批中，若在审批中则取变更合同的子表单据信息
        Boolean changeFlag = false;
        ChangeEntity changeEntity;
        Map<Long, Long> changeIdMap = new HashMap<>();
        if (ChangeStatusEnum.变更中.getCode().equals(contractEntity.getChangeStatus()) || billTypeCode.equals(ProsubBillTypeEnum.劳务分包合同.getBillTypeCode()) || billTypeCode.equals(ProsubBillTypeEnum.专业分包合同.getBillTypeCode())
                || billTypeCode.equals(ProsubBillTypeEnum.特种设备租赁合同.getBillTypeCode()) || billTypeCode.equals(ProsubBillTypeEnum.其他分包合同.getBillTypeCode())){
            if (contractEntity.getChangeId() != null){
                changeEntity = changeService.selectById(contractEntity.getChangeId());
                if (BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(changeEntity.getBillState()) || BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(changeEntity.getBillState())){
                    logger.info("当前合同处于变更中，且变更单的状态为审批中。");
                    changeFlag = true;
                    contractEntity = BeanMapper.map(changeEntity, ContractEntity.class);
                    logger.info("数据转换后的主合同:{}", JSONObject.toJSONString(contractEntity));
                    //设置变更合同子表id信息
                    for (ChangeDetailEntity changeDetailEntity : changeEntity.getDetailList()) {
                        changeIdMap.put(changeDetailEntity.getId(), changeDetailEntity.getSrcTblId());
                    }
                    logger.info("变更合同子表id信息：{}", JSONObject.toJSONString(changeIdMap));
                }
            }
        }

        List<ContractDetailEntity> detailEntityList = contractEntity.getDetailList();
        if (CollectionUtils.isEmpty(detailEntityList)){
            throw new BusinessException("获取合同子表信息有误，请检查请求参数contractId");
        }

        List<ContractDetailEntity> detailList = detailEntityList.stream().filter(item -> item.getDetailNum() != null).collect(Collectors.toList());
        //获取到所有末级清单信息
        logger.info("获取到所有末级清单信息:{}", JSONObject.toJSONString(detailList));

        //若是结算单来源，则过滤合同子表信息
        if ((ProsubBillTypeEnum.劳务分包合同过程结算.getBillTypeCode().equals(billTypeCode)
                || ProsubBillTypeEnum.劳务分包合同节点结算.getBillTypeCode().equals(billTypeCode)
                || ProsubBillTypeEnum.劳务分包合同完工结算.getBillTypeCode().equals(billTypeCode)) && CollectionUtils.isNotEmpty(settleDetailEntityList)){

            Map<Long, ContractDetailEntity> contractDetailListMap = new HashMap<>();
            for (ContractDetailEntity detailEntity : detailList) {
                if (changeFlag){
                    //变更中的合同取变更合同子表来源id及原合同子表id
                    contractDetailListMap.put(null != changeIdMap.get(detailEntity.getId()) ? changeIdMap.get(detailEntity.getId()) : detailEntity.getId(), detailEntity);
                }else {
                    contractDetailListMap.put(detailEntity.getId(), detailEntity);
                }
            }
            detailList = new ArrayList<>();
            List<Long> docIds = new ArrayList<>();
            List<Long> contractDetailIds = new ArrayList<>();
            for (SettleDetailEntity settleDetailEntity : settleDetailEntityList) {
                ContractDetailEntity detailEntity = new ContractDetailEntity();
                detailEntity.setId(settleDetailEntity.getContractDetailId());
                if (null != contractDetailListMap.get(settleDetailEntity.getContractDetailId())){
                    ContractDetailEntity sourceDetailEntity = contractDetailListMap.get(settleDetailEntity.getContractDetailId());
                    if (!(docIds.contains(sourceDetailEntity.getDocId()) && contractDetailIds.contains(settleDetailEntity.getContractDetailId()))){
                        detailEntity.setSourceType(sourceDetailEntity.getSourceType());
                        detailEntity.setDetailCode(sourceDetailEntity.getDetailCode());
                        detailEntity.setDetailName(sourceDetailEntity.getDetailName());
                        detailEntity.setDetailWorkContent(sourceDetailEntity.getDetailWorkContent());
                        detailEntity.setDetailMeasurementRules(sourceDetailEntity.getDetailMeasurementRules());
                        detailEntity.setDetailUnit(sourceDetailEntity.getDetailUnit());

                        detailEntity.setDocId(sourceDetailEntity.getDocId());
                        detailEntity.setContractId(contractId);
                        detailEntity.setDetailNum(sourceDetailEntity.getDetailNum());
                        detailEntity.setDetailMny(sourceDetailEntity.getDetailMny());
                        detailEntity.setDetailTaxMny(sourceDetailEntity.getDetailTaxMny());
                        docIds.add(sourceDetailEntity.getDocId());
                        contractDetailIds.add(settleDetailEntity.getContractDetailId());
                        detailList.add(detailEntity);
                    }
                }
            }
        }

        List<ContractDataModelVO> contractDataModelVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailList)){
            //审批中、已提交、审批通过 的合同可以给数量和金额赋值
            Boolean stateFlag = false;
            if (contractEntity.getBillState().equals(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode())
                    || contractEntity.getBillState().equals(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())
                    || contractEntity.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
                    || contractEntity.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())){
                stateFlag = true;
            }
            for (ContractDetailEntity detail : detailList) {
                //如果是变更而来的合同，把id换为合同的子表id
                if (changeFlag){
                    detail.setId(null != changeIdMap.get(detail.getId()) ? changeIdMap.get(detail.getId()) : detail.getId());
                }
                ContractDataModelVO contractDataModelVO = new ContractDataModelVO();
                contractDataModelVO.setSourceType(detail.getSourceType());
                contractDataModelVO.setSourceTypeName(DetailSourceTypeEnum.getByCode(detail.getSourceType()).getName());
                contractDataModelVO.setDetailCode(detail.getDetailCode());
                contractDataModelVO.setDetailName(detail.getDetailName());
                contractDataModelVO.setDetailWorkContent(detail.getDetailWorkContent());
                contractDataModelVO.setDetailMeasurementRules(detail.getDetailMeasurementRules());
                contractDataModelVO.setDetailUnit(detail.getDetailUnit());

                contractDataModelVO.setDocId(detail.getDocId());
                contractDataModelVO.setContractId(contractId);
                contractDataModelVO.setDetailId(detail.getId());
                //审批中、已提交、审批通过 的合同可以给数量和金额赋值
                if (stateFlag){
                    contractDataModelVO.setDetailNum(detail.getDetailNum());
                    contractDataModelVO.setDetailMny(detail.getDetailMny());
                    contractDataModelVO.setDetailTaxMny(detail.getDetailTaxMny());
                }
                contractDataModelVOList.add(contractDataModelVO);
            }
        }
        logger.info("得到的合同子表相关信息：{}", JSONObject.toJSONString(contractDataModelVOList));
        //已提交 或 已审批的合同再去找结算相关信息
        logger.info("合同状态：{}", BillStateEnum.getEnumByStateCode(contractEntity.getBillState()).getDescription());
        if (!(contractEntity.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
                || contractEntity.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) && !changeFlag){//且不是变更合同
            return contractDataModelVOList;
        }
        //设置结算信息
        contractDataModelVOList = this.setSettleData(contractDataModelVOList, contractId, detailList);
        this.setScale(contractDataModelVOList);
        return contractDataModelVOList;
    }

    private List<ContractDataModelVO> setSettleData(List<ContractDataModelVO> contractDataModelVOList, Long contractId, List<ContractDetailEntity> detailList) {
        //获取 审批中、已提交、审批通过 中的结算相关信息 给合同数据模型赋值
        QueryParam settleQuery = new QueryParam();
        settleQuery.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        settleQuery.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        List<SettleEntity> settleEntityList = settleService.queryList(settleQuery);
        logger.info("查出符合条件的结算单集合：{}", JSONObject.toJSONString(settleEntityList));
        if (CollectionUtils.isEmpty(settleEntityList)){
            return contractDataModelVOList;
        }
        //通过结算单id和合同清单id查出符合条件的结算单子表数据集合
        List<Long> settleIdList = settleEntityList.stream().map(SettleEntity::getId).collect(Collectors.toList());
        logger.info("查出符合条件的结算单id集合：{}", JSONObject.toJSONString(settleIdList));
        List<Long> contractDetailIdList = detailList.stream().map(ContractDetailEntity::getId).collect(Collectors.toList());
        logger.info("合同清单id集合：{}", JSONObject.toJSONString(contractDetailIdList));
        QueryParam settleDetailQuery = new QueryParam();
        settleDetailQuery.getParams().put("settleId", new Parameter(QueryParam.IN, settleIdList));
        settleDetailQuery.getParams().put("contractDetailId", new Parameter(QueryParam.IN, contractDetailIdList));
        List<SettleDetailEntity> settleDetailEntityList = settleDetailService.queryList(settleDetailQuery);
        if (CollectionUtils.isEmpty(settleDetailEntityList)){
            return contractDataModelVOList;
        }
        logger.info("查出符合条件的结算单末级清单集合：{}", JSONObject.toJSONString(settleDetailEntityList));
        //对结算子表数据依照结算类型进行分组
        Map<Integer, List<SettleDetailEntity>> settleDetailMapBySettleType = settleDetailEntityList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getSettleType));
        logger.info("依照结算类型分组后的数据：{}", JSONObject.toJSONString(settleDetailMapBySettleType));

        //对分组后的结算子表数据再依照来源id进行分组
        Map<Long, BigDecimal> processSettleNumMap = new HashMap<>();
        Map<Long, BigDecimal> processSettleTaxMnyMap = new HashMap<>();
        Map<Long, BigDecimal> processSettleMnyMap = new HashMap<>();

        Map<Long, BigDecimal> finishSettleNumMap = new HashMap<>();
        Map<Long, BigDecimal> finishSettleTaxMnyMap = new HashMap<>();
        Map<Long, BigDecimal> finishSettleMnyMap = new HashMap<>();

        Map<Long, BigDecimal> nodeSettleNumMap = new HashMap<>();
        Map<Long, BigDecimal> nodeSettleTaxMnyMap = new HashMap<>();
        Map<Long, BigDecimal> nodeSettleMnyMap = new HashMap<>();

        //过程结算
        if (CollectionUtils.isNotEmpty(settleDetailMapBySettleType.get(0))){
            List<SettleDetailEntity> processSettleDetailList = settleDetailMapBySettleType.get(0);
            //完工结算量集合
            processSettleNumMap = processSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO,
                    SettleDetailEntity::getSettleNum, BigDecimal::add)));
            //完工结算金额集合
            processSettleTaxMnyMap = processSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO,
                    SettleDetailEntity::getSettleTaxMny, BigDecimal::add)));
            processSettleMnyMap = processSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO,
                    SettleDetailEntity::getSettleMny, BigDecimal::add)));
        };
        //完工结算
        if (CollectionUtils.isNotEmpty(settleDetailMapBySettleType.get(1))){

            List<SettleDetailEntity> finishSettleDetailList = settleDetailMapBySettleType.get(1);
            //完工结算量集合
            finishSettleNumMap = finishSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO,
                    SettleDetailEntity::getSettleNum, BigDecimal::add)));
            //完工结算金额集合
            finishSettleTaxMnyMap = finishSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO,
                    SettleDetailEntity::getSettleTaxMny, BigDecimal::add)));
            finishSettleMnyMap = finishSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO,
                    SettleDetailEntity::getSettleMny, BigDecimal::add)));
        };
        //节点结算
        if (CollectionUtils.isNotEmpty(settleDetailMapBySettleType.get(2))){

            List<SettleDetailEntity> nodeSettleDetailList = settleDetailMapBySettleType.get(2);
            //完工结算量集合
            nodeSettleNumMap = nodeSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO,
                    SettleDetailEntity::getSettleNum, BigDecimal::add)));
            //完工结算金额集合
            nodeSettleTaxMnyMap = nodeSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO,
                    SettleDetailEntity::getSettleTaxMny, BigDecimal::add)));
            nodeSettleMnyMap = nodeSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO,
                    SettleDetailEntity::getSettleMny, BigDecimal::add)));
        };

        for (ContractDataModelVO vo : contractDataModelVOList) {
            //过程结算赋值
            if (processSettleNumMap.containsKey(vo.getDetailId())){
                vo.setTotalProcessNum(processSettleNumMap.get(vo.getDetailId()));
            }
            if (processSettleTaxMnyMap.containsKey(vo.getDetailId())){
                vo.setTotalProcessTaxMny(processSettleTaxMnyMap.get(vo.getDetailId()));
            }
            if (processSettleMnyMap.containsKey(vo.getDetailId())){
                vo.setTotalProcessMny(processSettleMnyMap.get(vo.getDetailId()));
            }
            //完工结算赋值
            if (finishSettleNumMap.containsKey(vo.getDetailId())){
                vo.setTotalFinishNum(finishSettleNumMap.get(vo.getDetailId()));
            }
            if (finishSettleTaxMnyMap.containsKey(vo.getDetailId())){
                vo.setTotalFinishTaxMny(finishSettleTaxMnyMap.get(vo.getDetailId()));
            }
            if (finishSettleMnyMap.containsKey(vo.getDetailId())){
                vo.setTotalFinishMny(finishSettleMnyMap.get(vo.getDetailId()));
            }
            //节点结算赋值
            if (nodeSettleNumMap.containsKey(vo.getDetailId())){
                vo.setTotalNodeNum(nodeSettleNumMap.get(vo.getDetailId()));
            }
            if (nodeSettleTaxMnyMap.containsKey(vo.getDetailId())){
                vo.setTotalNodeTaxMny(nodeSettleTaxMnyMap.get(vo.getDetailId()));
            }
            if (nodeSettleMnyMap.containsKey(vo.getDetailId())){
                vo.setTotalNodeMny(nodeSettleMnyMap.get(vo.getDetailId()));
            }
        }
        logger.info("得到结算信息赋值后的合同子表相关信息：{}", JSONObject.toJSONString(contractDataModelVOList));
        return contractDataModelVOList;
    }




    @Override
    public List<ContractDataModelVO> queryListByProject(JSONObject param) {
        Long projectId;
        List<Long> docIdList = new ArrayList<>();
        String billTypeCode = null;
        int contractType = 1;
        if (param != null){
            logger.info("更新环境后-合同情况入参：" + JSONObject.toJSONString(param));
            Object bill = param.get("bill");
            JSONObject content = new JSONObject((HashMap) bill);
            logger.info("获得单据内容：{}", JSONObject.toJSONString(content));
            billTypeCode = (String) param.get("billTypeCode");
            logger.info("获得单据类型：{}", billTypeCode);
            Long billTypeId = content.getLong("id");
            Integer supplementFlag = content.getInteger("supplementFlag");
            logger.info("获得单据id:{}", billTypeId);

            if (ProsubBillTypeEnum.劳务分包合同.getBillTypeCode().equals(billTypeCode)
                    || ProsubBillTypeEnum.专业分包合同.getBillTypeCode().equals(billTypeCode)
                    || ProsubBillTypeEnum.特种设备租赁合同.getBillTypeCode().equals(billTypeCode)
                    || ProsubBillTypeEnum.其他分包合同.getBillTypeCode().equals(billTypeCode)
                    || ProsubBillTypeEnum.劳务分包合同变更.getBillTypeCode().equals(billTypeCode)
                    || ProsubBillTypeEnum.专业分包合同变更.getBillTypeCode().equals(billTypeCode)
                    || ProsubBillTypeEnum.特种设备租赁合同变更.getBillTypeCode().equals(billTypeCode)
                    || ProsubBillTypeEnum.其他分包合同变更.getBillTypeCode().equals(billTypeCode)
                    ) {//合同

                if (ProsubBillTypeEnum.劳务分包合同.getBillTypeCode().equals(billTypeCode)
                        || ProsubBillTypeEnum.劳务分包合同变更.getBillTypeCode().equals(billTypeCode)){
                    contractType = 0;
                }
                if (ProsubBillTypeEnum.劳务分包合同.getBillTypeCode().equals(billTypeCode)
                        || ProsubBillTypeEnum.专业分包合同.getBillTypeCode().equals(billTypeCode)){
                    //主合同
                    if (0 == supplementFlag){
                        JSONObject projectIdObject = new JSONObject((HashMap) content.get("projectId"));
                        projectId = projectIdObject.getLong("id");
                    }else {
                        projectId = content.getLong("projectId");
                    }
                    logger.info("获得合同项目id：{}", projectId);

                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, billTypeId));
                    queryParam.getParams().put("detailNum", new Parameter(QueryParam.NE, null));
                    List<ContractDetailEntity> contractDetailEntityList = contractDetailService.queryList(queryParam);
                    if (CollectionUtils.isNotEmpty(contractDetailEntityList)){
                        docIdList = contractDetailEntityList.stream().map(ContractDetailEntity::getDocId).collect(Collectors.toList());
                    }
                }else {
                    //变更合同
                    projectId = content.getLong("projectId");
                    logger.info("获得变更过合同项目id：{}", projectId);

                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("changeId", new Parameter(QueryParam.EQ, billTypeId));
                    queryParam.getParams().put("detailNum", new Parameter(QueryParam.NE, null));
                    List<ChangeDetailEntity> changeDetailEntityList = changeDetailService.queryList(queryParam);
                    if (CollectionUtils.isNotEmpty(changeDetailEntityList)){
                        docIdList = changeDetailEntityList.stream().map(ChangeDetailEntity::getDocId).collect(Collectors.toList());
                    }
                }

            }else if (ProsubBillTypeEnum.劳务分包总计划.getBillTypeCode().equals(billTypeCode)
                    || ProsubBillTypeEnum.专业分包总计划.getBillTypeCode().equals(billTypeCode)) {//总计划
                if (ProsubBillTypeEnum.劳务分包总计划.getBillTypeCode().equals(billTypeCode)){
                    contractType = 0;
                }
                JSONObject projectIdObject = new JSONObject((HashMap) content.get("projectId"));
                projectId = projectIdObject.getLong("id");
                logger.info("获得总计划项目id：{}", projectId);

                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("planId", new Parameter(QueryParam.EQ, billTypeId));
                queryParam.getParams().put("planNum", new Parameter(QueryParam.NE, null));
                List<PlanDetailEntity> planDetailEntityList = planDetailService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(planDetailEntityList)){
                    docIdList = planDetailEntityList.stream().map(PlanDetailEntity::getDocId).collect(Collectors.toList());
                }
            }else {//结算
                JSONObject projectIdObject = new JSONObject((HashMap) content.get("projectId"));
                projectId = projectIdObject.getLong("id");
                logger.info("获得结算项目id：{}", projectId);
                if (ProsubBillTypeEnum.劳务分包合同过程结算.getBillTypeCode().equals(billTypeCode)
                        || ProsubBillTypeEnum.劳务分包合同节点结算.getBillTypeCode().equals(billTypeCode)
                        || ProsubBillTypeEnum.劳务分包合同完工结算.getBillTypeCode().equals(billTypeCode)){
                    contractType = 0;
                }

                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("settleId", new Parameter(QueryParam.EQ, billTypeId));
                queryParam.getParams().put("settleNum", new Parameter(QueryParam.NE, null));
                List<SettleDetailEntity> settleDetailEntityList = settleDetailService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(settleDetailEntityList)){
                    docIdList = settleDetailEntityList.stream().map(SettleDetailEntity::getDocId).collect(Collectors.toList());
                }
            }
            logger.info("页面档案id集合:{}", docIdList);
            logger.info("合同类型 0 劳务 1 专业:{}", contractType);
        }else {
            //测试用  假数据  合同：yst数据测试--参数----勿动
            projectId = 586573422415986776L;
            docIdList = Arrays.asList(1493470196962140161L, 1493470196953751554L);
            contractType = 0;

            //有总计划没合同  项目名称 姜易凯测试数据模型
            projectId = 592750047901925456L;
            docIdList = Arrays.asList(546727233671806980L, 1493128925534679041L, 1493128925698256897L, 1493128925635342337L);
            contractType = 1;

            //劳务分包总计划 李志杰测试项目2.0 总计划、合同都有
            projectId = 614864965224513589L;
            docIdList = Arrays.asList(1493470196911808513L, 1493470196932780034L, 1493470196945362946L, 1493470196953751554L, 1493470196962140161L, 1493470196970528770L);
            contractType = 0;

            //变更维度 数据模型测试-勿动 变更单
            projectId = 627804093024976938L;
            docIdList = Arrays.asList(1493470196911808513L, 1493470196953751554L, 1493470196962140161L, 620268264174010448L, 622147447699423321L, 1493470196932780034L);
            contractType = 0;
            billTypeCode = ProsubBillTypeEnum.劳务分包合同变更.getBillTypeCode();
        }
        //根据不同主类型查询对应的数据模型
        List<ContractDataModelVO> contractDataModelVOList = new ArrayList<>();
        if (ProsubBillTypeEnum.劳务分包合同.getBillTypeCode().equals(billTypeCode)
                || ProsubBillTypeEnum.专业分包合同.getBillTypeCode().equals(billTypeCode)){//主合同

            logger.info("主合同维度：单据类型：{}", billTypeCode);
            contractDataModelVOList = contractDetailMapper.queryContractDataModelByContract(projectId, docIdList, contractType);

        }else if ( ProsubBillTypeEnum.劳务分包合同变更.getBillTypeCode().equals(billTypeCode)
                || ProsubBillTypeEnum.专业分包合同变更.getBillTypeCode().equals(billTypeCode)) {//变更

            logger.info("变更维度：单据类型：{}", billTypeCode);
            contractDataModelVOList = contractDetailMapper.queryContractDataModelByChange(projectId, docIdList, contractType);

        }else if (ProsubBillTypeEnum.劳务分包总计划.getBillTypeCode().equals(billTypeCode)
                || ProsubBillTypeEnum.专业分包总计划.getBillTypeCode().equals(billTypeCode)) {//总计划

            logger.info("总计划维度：单据类型：{}", billTypeCode);
            contractDataModelVOList = contractDetailMapper.queryContractDataModelByPlan(projectId, docIdList, contractType);

        }else {
            logger.info("结算维度：单据类型：{}", billTypeCode);
            contractDataModelVOList = contractDetailMapper.queryContractDataModelBySettle(projectId, docIdList, contractType);
        }


        logger.info("根据项目维度查出的合同子表数据模型信息：{}", JSONObject.toJSONString(contractDataModelVOList));

        //目标量赋值
        if (CollectionUtils.isNotEmpty(contractDataModelVOList)){
            CommonResponse<Map<Long, DutyDetailItemVO>> mapCommonResponse = dutyApi.queryDocDutyDetailItem(projectId, (contractType == 0 ? 1 : 2));
            logger.info("查询目标量结果：{}", JSONObject.toJSONString(mapCommonResponse));
            if (mapCommonResponse.isSuccess()) {
                Map<Long, DutyDetailItemVO> targetMap = mapCommonResponse.getData();
                for (ContractDataModelVO contractDataModelVO : contractDataModelVOList) {
                    if (targetMap != null && targetMap.get(contractDataModelVO.getDocId()) != null) {
                        DutyDetailItemVO dutyDetailItemVO = targetMap.get(contractDataModelVO.getDocId());
                        //设置目标量、金额
                        contractDataModelVO.setTargetNum(dutyDetailItemVO.getAmount());
                        contractDataModelVO.setTargetMny(dutyDetailItemVO.getTaxMny());
                        //设置剩余目标量、金额
                        if (null != contractDataModelVO.getDetailNum() && null != contractDataModelVO.getTargetNum()){
                            contractDataModelVO.setTargetRemainderNum(contractDataModelVO.getTargetNum().subtract(contractDataModelVO.getDetailNum()));
                        }
                        if (null != contractDataModelVO.getDetailTaxMny() && null != contractDataModelVO.getTargetMny()){
                            contractDataModelVO.setTargetRemainderMny(contractDataModelVO.getTargetMny().subtract(contractDataModelVO.getDetailTaxMny()));
                        }

                    }
                }
            }
        }
        logger.info("项目维度合同明细数据模型信息返回：{}", JSONObject.toJSONString(contractDataModelVOList));
        this.setScale(contractDataModelVOList);
        return contractDataModelVOList;
    }

    //设置返回值小数位
    private void setScale(List<ContractDataModelVO> contractDataModelVOList) {
        if (CollectionUtils.isNotEmpty(contractDataModelVOList)){
            for (ContractDataModelVO contractDataModelVO : contractDataModelVOList) {
                contractDataModelVO.setDetailNum(null != contractDataModelVO.getDetailNum() ? contractDataModelVO.getDetailNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setDetailTaxMny(null != contractDataModelVO.getDetailTaxMny() ? contractDataModelVO.getDetailTaxMny().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTotalProcessNum(null != contractDataModelVO.getTotalProcessNum() ? contractDataModelVO.getTotalProcessNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTotalProcessTaxMny(null != contractDataModelVO.getTotalProcessTaxMny() ? contractDataModelVO.getTotalProcessTaxMny().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTotalFinishNum(null != contractDataModelVO.getTotalFinishNum() ? contractDataModelVO.getTotalFinishNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTotalFinishTaxMny(null != contractDataModelVO.getTotalFinishTaxMny() ? contractDataModelVO.getTotalFinishTaxMny().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTotalNodeNum(null != contractDataModelVO.getTotalNodeNum() ? contractDataModelVO.getTotalNodeNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTotalNodeTaxMny(null != contractDataModelVO.getTotalNodeTaxMny() ? contractDataModelVO.getTotalNodeTaxMny().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setPlanNum(null != contractDataModelVO.getPlanNum() ? contractDataModelVO.getPlanNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setPlanTaxMny(null != contractDataModelVO.getPlanTaxMny() ? contractDataModelVO.getPlanTaxMny().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTargetNum(null != contractDataModelVO.getTargetNum() ? contractDataModelVO.getTargetNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTargetMny(null != contractDataModelVO.getTargetMny() ? contractDataModelVO.getTargetMny().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTargetRemainderNum(null != contractDataModelVO.getTargetRemainderNum() ? contractDataModelVO.getTargetRemainderNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTargetRemainderMny(null != contractDataModelVO.getTargetRemainderMny() ? contractDataModelVO.getTargetRemainderMny().setScale(2, RoundingMode.HALF_UP) : null);
            }
        }
    }
}
