package com.ejianc.business.prosub.controller;

import com.ejianc.business.prosub.mapper.ContractManagementMapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("contractManagement")
public class ContractManagementController {

    private static final Logger log = LoggerFactory.getLogger(ContractManagementController.class);
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ContractManagementMapper mapper;

    @GetMapping(value = "/lwfbht")
    public CommonResponse<Map<String,Map<String, Object>>>
    analysisSelect(@RequestParam(value = "id", required = false) Long projectId) {
        Map<String,Map<String, Object>> ans = new HashMap<>();
        List<Long> orgIds = getOrgIds();
        //劳务分包合同
        Map<String, Object> contractMap0 = mapper.contractMapper(0, orgIds,projectId);
        ans.put("lwfbht",contractMap0);
        //专业分包合同
        Map<String, Object> contractMap1 = mapper.contractMapper(1, orgIds,projectId);
        ans.put("zyfbht",contractMap1);
        //物资采购合同
        Map<String, Object> promaterialMap0 = mapper.promaterialMapper(0, orgIds,projectId);
        ans.put("wzcght",promaterialMap0);
        //混凝土采购合同
        Map<String, Object> promaterialMap1 = mapper.promaterialMapper(1, orgIds,projectId);
        ans.put("hntcght",promaterialMap1);
        //周转材租赁合同
        Map<String, Object> prormatContracMapper = mapper.prormatContracMapper(orgIds,projectId);
        ans.put("zzczpht",prormatContracMapper);
        //施工机械租赁合同
        Map<String, Object> rentContractMapper = mapper.rentContractMapper(orgIds,projectId);
        ans.put("sgjxzlht",rentContractMapper);
        //处置合同
        Map<String, Object> otherContractMapper = mapper.otherContractMapper(orgIds,projectId);
        ans.put("czht",otherContractMapper);
        //统计最后数据
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    private List<Long> getOrgIds() {
        CommonResponse<List<OrgVO>> children = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        List<Long> orgIds = children.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        log.info("组织IDS--------------------");
        log.info("组织IDS:{}",orgIds);
        log.info("组织IDS--------------------");
        return orgIds;
    }

    @GetMapping(value = "/fbfqzspd")
    public CommonResponse<Map<String,Map<String, Object>>> fbfqzspdSelect(@RequestParam(value = "id", required = false) Long projectId) {
        Map<String,Map<String, Object>> ans = new HashMap<>();
        List<Long> orgIds = getOrgIds();
        //发包方签证索赔记录单
        Map<String, Object> claimRecordsMapper = mapper.claimRecordsMapper(orgIds,projectId);
        ans.put("fbqzspjld",claimRecordsMapper);
        //发包方签证索赔办理
        Map<String, Object> incomeClaimMapper = mapper.incomeClaimMapper(orgIds,projectId);
        ans.put("fbqzspjbli",incomeClaimMapper);
        //形象进度单
        Map<String, Object> incomeProgressMapper = mapper.incomeProgressMapper(orgIds,projectId);
        ans.put("xxjd",incomeProgressMapper);
        //对发包方报量
        Map<String, Object> quoteMapper = mapper.incomeQuoteMapper(orgIds,projectId);
        ans.put("dfbbl",quoteMapper);
        //竣工结算单
        Map<String, Object> incomeFinalizedMapper = mapper.incomeFinalizedMapper(orgIds,projectId);
        ans.put("jgjsd",incomeFinalizedMapper);
        //项目预算书
        Map<String, Object> budgetMapper = mapper.incomeBudgetMapper(orgIds,projectId);
        ans.put("xmyss",budgetMapper);
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/wzgl")
    public CommonResponse<Map<String,Map<String, Object>>> wzglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        Map<String,Map<String, Object>> ans = new HashMap<>();
        List<Long> orgIds = getOrgIds();
        //分项需用计划
        Map<String, Object> promaterialPlanMapper = mapper.promaterialPlanMapper(orgIds,projectId);
        ans.put("fxxyjh",promaterialPlanMapper);
        //单项采购计划
        Map<String, Object> stringObjectMap = mapper.singlePlanMapper(orgIds,projectId);
        ans.put("dxcgjh",stringObjectMap);
        //配送计划
        Map<String, Object> promaterialOrderMapper = mapper.promaterialOrderMapper(orgIds,projectId);
        ans.put("psjh",promaterialOrderMapper);
        //材料验收
        Map<String, Object> promaterialCheckMapper = mapper.promaterialCheckMapper(orgIds,projectId);
        ans.put("clys",promaterialCheckMapper);
        //材料入库
        Map<String, Object> checkStoreMapper = mapper.checkStoreMapper(orgIds,projectId);
        ans.put("clrk",checkStoreMapper);
        //直入直出
        Map<String, Object> concreteCheckMapper = mapper.concreteCheckMapper(orgIds,projectId);
        ans.put("zrzc",concreteCheckMapper);
        //领料出库
        Map<String, Object> outStoreMapper = mapper.outStoreMapper(orgIds,projectId);
        ans.put("llrk",outStoreMapper);
        //对账结算（通用）
        Map<String, Object> settlementMapper0 = mapper.promaterialSettlementMapper(0, orgIds,projectId);
        ans.put("dzjsty",settlementMapper0);
        //对账结算（钢材）
        Map<String, Object> settlementMapper2 = mapper.promaterialSettlementMapper(2, orgIds,projectId);
        ans.put("dzjsgc",settlementMapper2);
        //对账结算（混泥土）
        Map<String, Object> settlementMapper1 = mapper.promaterialSettlementMapper(1, orgIds,projectId);
        ans.put("dzjshnt",settlementMapper1);
        //物资鉴定
        Map<String, Object> storeDefinitionMapper = mapper.storeDefinitionMapper(orgIds,projectId);
        ans.put("wzjd",storeDefinitionMapper);
        //处置申请
        Map<String, Object> storeApplyMapper = mapper.storeApplyMapper(orgIds,projectId);
        ans.put("czsq",storeApplyMapper);
        //处置明细\
        Map<String, Object> disposeMapper = mapper.storeDisposeMapper(orgIds,projectId);
        ans.put("czmxi",disposeMapper);
        //对账结算
        Map<String, Object> storeSettleMapper = mapper.storeSettleMapper(orgIds,projectId);
        ans.put("dzjsd",storeSettleMapper);
        //统计结果
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/fenbfswgl")
    public CommonResponse<Map<String,Map<String, Object>>> fenbfswglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        Map<String,Map<String, Object>> ans = new HashMap<>();
        List<Long> orgIds = getOrgIds();
        //分包招标控制价
        Map<String, Object> prosubControlMapper = mapper.prosubControlMapper(orgIds,projectId);
        ans.put("fbzbkzt",prosubControlMapper);
        //项目分包施工指令单
        Map<String, Object> oldjobApplicationMapper = mapper.oldjobApplicationMapper(orgIds,projectId);
        ans.put("xmfbsgzld",oldjobApplicationMapper);
        //合同外分包签证办理
        Map<String, Object> oldjobRegistrationMapper = mapper.oldjobRegistrationMapper(orgIds,projectId);
        ans.put("ftwfbqzbl",oldjobRegistrationMapper);
        //分包价格调整与增补
        Map<String, Object> adjustMapper = mapper.priceAdjustMapper(orgIds,projectId);
        ans.put("fbjgtzyzb",adjustMapper);
        //分包单位扣罚款
        Map<String, Object> prosubDeductionMapper = mapper.prosubDeductionMapper(orgIds,projectId);
        ans.put("fbdwkkd",prosubDeductionMapper);
        //分包形象进度审核表
        Map<String, Object> prosubProgressMapper = mapper.prosubProgressMapper(orgIds,projectId);
        ans.put("fbxxjdshb",prosubProgressMapper);
        // 分包中间计量
        Map<String, Object> prosubSettleMapper0 = mapper.prosubSettleMapper(0, orgIds,projectId);
        ans.put("fbzjjjl",prosubSettleMapper0);
        // 分包结算
        Map<String, Object> prosubSettleMapper1 = mapper.prosubSettleMapper(1, orgIds,projectId);
        ans.put("fbjsd",prosubSettleMapper1);
        //统计结果
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/jsgli")
    public CommonResponse<Map<String,Map<String, Object>>> jsgliSelect(@RequestParam(value = "id", required = false) Long projectId) {
        Map<String,Map<String, Object>> ans = new HashMap<>();
//        图纸登记
        List<Long> orgIds = getOrgIds();
        Map<String, Object> drawingRegistrationMapper = mapper.drawingRegistrationMapper(orgIds,projectId);
        ans.put("tzdjd",drawingRegistrationMapper);
//        图纸会审
        Map<String, Object> tecDrawingTriageMapper = mapper.tecDrawingTriageMapper(orgIds,projectId);
        ans.put("tzhsd",tecDrawingTriageMapper);
//        设计变更
        Map<String, Object> tecDesignChangeMapper = mapper.tecDesignChangeMapper(orgIds,projectId);
        ans.put("sjbgd",tecDesignChangeMapper);
//        施工方案
        Map<String, Object> constructionSchemeMapper = mapper.constructionSchemeMapper(orgIds,projectId);
        ans.put("sgfad",constructionSchemeMapper);
//        施工方案交底
        Map<String, Object> disclosureMapper = mapper.constructionDisclosureMapper(orgIds,projectId);
        ans.put("sgfajd",disclosureMapper);
//        分项工程质量技术交底
        Map<String, Object> qualitiedDisclosureMapper = mapper.qualityDisclosureMapper(orgIds,projectId);
        ans.put("fxgczljd",qualitiedDisclosureMapper);
//        分项工程安全技术交底
        Map<String, Object> safetyDisclosureMapper = mapper.safetyDisclosureMapper(orgIds,projectId);
        ans.put("fxgcanquanjd",safetyDisclosureMapper);
//        设计变更交底
        Map<String, Object> changeDisclosureMapper = mapper.changeDisclosureMapper(orgIds,projectId);
        ans.put("sjbgjd",changeDisclosureMapper);
        //统计结果
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/zlgl")
    public CommonResponse<Map<String,Map<String, Object>>> zlglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        Map<String,Map<String, Object>> ans = new HashMap<>();
        List<Long> orgIds = getOrgIds();
//        质量隐患检查
        Map<String, Object> sceneCheckMapper = mapper.sceneCheckMapper(orgIds,projectId);
        ans.put("zlyhjc",sceneCheckMapper);
//        待整改
        Map<String, Object> sceneCheckDetailMapper1 = mapper.sceneCheckDetailMapper(1, orgIds,projectId);
        ans.put("zldzg",sceneCheckDetailMapper1);
//        待复查
        Map<String, Object> sceneCheckDetailMapper2 = mapper.sceneCheckDetailMapper(2, orgIds,projectId);
        ans.put("zldfcsjbgjd",sceneCheckDetailMapper2);
//        质量隐患检查台账
        Map<String, Object> sceneCheckListMapper = mapper.sceneCheckListMapper(orgIds,projectId);
        ans.put("zlyhjctz",sceneCheckListMapper);
//        QC小组注册
        Map<String, Object> qualityRegisterMapper = mapper.qualityRegisterMapper(orgIds,projectId);
        ans.put("qcxzzc",qualityRegisterMapper);
//        QC小组课题登记
        Map<String, Object> qualitySubjectMapper = mapper.qualitySubjectMapper(orgIds,projectId);
        ans.put("qcxzktdj",qualitySubjectMapper);
//        QC小组活动成果
        Map<String, Object> qualityActivityMapper = mapper.qualityActivityMapper(orgIds,projectId);
        ans.put("qcxzhdcg",qualityActivityMapper);
        //统计结果
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/aqjc")
    public CommonResponse<Map<String,Map<String, Object>>> aqjcSelect(@RequestParam(value = "id", required = false) Long projectId) {
        //安全管理
        Map<String,Map<String, Object>> ans = new HashMap<>();
        List<Long> orgIds = getOrgIds();
//        安全隐患检查
        Map<String, Object> sceneCheckMapper = mapper.sceneCheckMapper(orgIds,projectId);
        ans.put("aqyhjc",sceneCheckMapper);
//        待整改
        Map<String, Object> sceneCheckDetailMapper1 = mapper.sceneCheckDetailMapper(1, orgIds,projectId);
        ans.put("aqdzg",sceneCheckDetailMapper1);
//        待复查
        Map<String, Object> sceneCheckDetailMapper2 = mapper.sceneCheckDetailMapper(2, orgIds,projectId);
        ans.put("aqdfc",sceneCheckDetailMapper2);
//        安全隐患检查台账
        Map<String, Object> sceneCheckListMapper = mapper.safetySceneCheckListMapper(orgIds,projectId);
        ans.put("aqyhjctz",sceneCheckListMapper);
        //统计结果
        tjsj(ans);
        return CommonResponse.success("查询成功", ans);
    }

    private static void tjsj(Map<String,Map<String, Object>> ans) {
        //统计最后数据
        long we = 0, mo = 0, to = 0;
        for (Map<String, Object> value : ans.values()) {
            we += value.get("weekly") == null ? 0 : Long.parseLong(value.get("weekly").toString());
            mo += value.get("monthly") == null ? 0 : Long.parseLong(value.get("monthly").toString());
            to += value.get("total") == null ? 0 : Long.parseLong(value.get("total").toString());

        }
        Map<String, Object> tjjg = new HashMap<>();
        tjjg.put("weekly", we);
        tjjg.put("monthly", mo);
        tjjg.put("total", to);
        ans.put("ansjguoji",tjjg);
    }


}
