package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.bean.ApplicationDetailEntity;
import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.enums.ApplicationStateEnum;
import com.ejianc.business.process.service.IApplicationDetailService;
import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.process.vo.ApplicationDetailVO;
import com.ejianc.business.process.vo.ApplicationVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 零工申请实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("application")
public class ApplicationController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "APP_JOB";

    @Autowired
    private IApplicationService service;

    @Autowired
    private IApplicationDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IContractService contractService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ApplicationVO> saveOrUpdate(@RequestBody ApplicationVO saveOrUpdateVO) {
    	ApplicationEntity entity = BeanMapper.map(saveOrUpdateVO, ApplicationEntity.class);
    	if(entity.getId() == null){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(!billCode.isSuccess()) {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //新增设置
            entity.setBillCode(billCode.getData());
            //新增 零工是否登记 设置为未被引用
            entity.setUseFlag(0);
            //新增 单据状态为 自由态
            entity.setBillState(0);
            entity.setCommandState(ApplicationStateEnum.申请中.getCode());
        }
    	service.saveOrUpdate(entity, false);
    	ApplicationVO vo = BeanMapper.map(entity, ApplicationVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id 申请
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplicationVO> queryDetail(Long id) {
    	ApplicationEntity entity = service.selectById(id);
    	ApplicationVO vo = BeanMapper.map(entity, ApplicationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplicationVO> vos) {
        service.removeByIds(vos.stream().map(ApplicationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    /**
     * @Description closeOrder 更新签证办理状态
     */
    @RequestMapping(value = "/UPDVisaType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse UPDVisaType(HttpServletRequest request) {
        logger.info("开始定时任务更新签证办理状态：----");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();//
        calendar.setTime(date);
        calendar.add(Calendar.DATE, -7);//取七天前的时间
        logger.info("日期为:" + df.format(calendar.getTime()));
        LambdaUpdateWrapper<ApplicationEntity> lw = Wrappers.lambdaUpdate();
        lw.eq(ApplicationEntity::getVisaState,ApplicationStateEnum.七天内未办理.getCode())
                .lt(ApplicationEntity::getActualEndDate,df.format(calendar.getTime()))
                .set(ApplicationEntity::getVisaState,ApplicationStateEnum.超时未办理.getCode());
        service.update(lw);
        logger.info("定时任务更新签证办理状态：----11");
        return CommonResponse.success("定时任务更新签证办理状态成功！");
    }

    @RequestMapping(value = "/UPDFinish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> UPDFinish(@RequestBody ApplicationVO vo) {
        Assert.notNull(vo.getId(), "项目指令单id不能为空！");
        LambdaUpdateWrapper<ApplicationEntity> uw = Wrappers.lambdaUpdate();
        uw.eq(ApplicationEntity::getId,vo.getId())
                .set(ApplicationEntity::getCommandState, ApplicationStateEnum.已完工.getCode())
                .set(ApplicationEntity::getVisaState, ApplicationStateEnum.七天内未办理.getCode())
                .set(ApplicationEntity::getSureDate, new Date())
                .set(ApplicationEntity::getSurePeople, sessionManager.getUserContext().getUserId())
                .set(ApplicationEntity::getSurePeopleName, sessionManager.getUserContext().getUserName())
                .set(ApplicationEntity::getActualBeginDate, vo.getActualBeginDate())
                .set(ApplicationEntity::getActualEndDate, vo.getActualEndDate())
                .set(ApplicationEntity::getRemark, vo.getRemark());
        service.update(uw);
        return CommonResponse.success("更新成功！");
    }
    /**
     * @Description queryList 查询列表
     */
    @RequestMapping(value = "/queryPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ApplicationVO>> queryPage(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("useWorkDetail");
        List<ApplicationEntity> dataList =new ArrayList<>();
        IPage<ApplicationEntity> page;
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("create_time", QueryParam.DESC);
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        //移动端查询
        if (StringUtils.isNotBlank(authOrgIds)) {
            //移动端有默认项目的存在，故传递默认项目对应项目部Id时，查询其本下数据，若未传递，则返回空数据
            if(null == param.getParams().get("orgId")) {
                page = new Page<>(param.getPageIndex(), param.getPageSize(), 0);
            } else {
                page = service.queryPage(param, false);
                dataList = page.getRecords();
            }
        } else {
            //pc端查询
            //查询本下范围内日的合同
            Long orgId = InvocationInfoProxy.getOrgId();
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            page = service.queryPage(param, false);
            dataList = page.getRecords();
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if(null == param.getOrderMap().get("createTime")) {
            orderMap.put("create_time", QueryParam.DESC);
        }
        param.setOrderMap(orderMap);
        IPage<ApplicationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ApplicationVO> applicationVOS = BeanMapper.mapList(dataList, ApplicationVO.class);
        applicationVOS.forEach(application ->{
            application.setUseFlagStr(application.getUseFlag()==1?"零工已登记":"零工未登记");
        } );
        pageData.setRecords(applicationVOS);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }



    /**
     * @Description queryList 查询列表
     */
    @RequestMapping(value = "/queryApplication", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ApplicationVO>> queryApplication(@RequestBody QueryParam param) {
        // 模糊查询
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("taxMny");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useWorkTypeName");

        List<ApplicationEntity> dataList;
        IPage<ApplicationEntity> page;
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        // 过滤生效的单据
        ArrayList<Integer> billState = new ArrayList<>();
        billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billState));

        param.getOrderMap().put("create_time", QueryParam.DESC);
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        page = service.queryPage(param, false);
        dataList = page.getRecords();
        IPage<ApplicationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ApplicationVO> applicationVOS = BeanMapper.mapList(dataList, ApplicationVO.class);
        applicationVOS.forEach(application ->{
            application.setUseFlagStr(application.getUseFlag()==1?"零工已登记":"零工未登记");
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("applicationId",new Parameter(QueryParam.EQ,application.getId()));
            List<ApplicationDetailEntity> applicationDetailEntities = detailService.queryList(queryParam,false);
            if (!applicationDetailEntities.isEmpty()){
                application.setDetailList(BeanMapper.mapList(applicationDetailEntities, ApplicationDetailVO.class));
            }
        });
        pageData.setRecords(applicationVOS);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ApplicationVO>> refPicKingData(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText,
            @RequestParam(value = "searchObject", required = false)String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("taxMny");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useWorkTypeName");
        List<ApplicationEntity> dataList;
        IPage<ApplicationEntity> page;
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        // 过滤生效的单据
        ArrayList<Integer> billState = new ArrayList<>();
        billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billState));
        param.getParams().put("use_flag", new Parameter(QueryParam.EQ, 0));
        //实际结束日期不为空说明已进行完工
        param.getParams().put("actual_end_date", new Parameter(QueryParam.NE, null));

        if(StringUtils.isNotBlank(condition)) {
            JSONObject json = JSONObject.parseObject(condition);
            if(json.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, json.getLong("projectId")));
            }
            if(json.containsKey("orgId")) {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(json.getLong("orgId"));
                if (!orgResp.isSuccess()) {
                    throw new BusinessException("查询失败，获取组织信息失败！");
                }
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        } else {
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
                if (!orgResp.isSuccess()) {
                    throw new BusinessException("查询失败，获取组织信息失败！");
                }
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        param.getOrderMap().put("create_time", QueryParam.DESC);
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        page = service.queryPage(param, false);
        dataList = page.getRecords();
        IPage<ApplicationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ApplicationVO> applicationVOS = BeanMapper.mapList(dataList, ApplicationVO.class);
        applicationVOS.forEach(application ->{
            application.setUseFlagStr(application.getUseFlag()==1?"零工已登记":"零工未登记");
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("applicationId",new Parameter(QueryParam.EQ,application.getId()));
            List<ApplicationDetailEntity> applicationDetailEntities = detailService.queryList(queryParam,false);
            if (!applicationDetailEntities.isEmpty()){
                application.setDetailList(BeanMapper.mapList(applicationDetailEntities, ApplicationDetailVO.class));
            }
        });
        pageData.setRecords(applicationVOS);
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ApplicationVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    @RequestMapping(value = "/mnyCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> mnyCtrl(@RequestBody ApplicationVO applicationVO) {
        return CommonResponse.success("参数校验成功！", service.mnyCtrl(applicationVO));
    }

    @RequestMapping(value = "/mnyCtrlById", method=RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> mnyCtrlById(@RequestParam(value = "id") Long id) {
        ApplicationEntity entity = service.selectById(id);
        if (entity == null) {
            return CommonResponse.error("结算单不存在！");
        }
        return CommonResponse.success("参数校验成功！", service.mnyCtrl(BeanMapper.map(entity, ApplicationVO.class)));
    }

    /**
     * 文件导出
     *
     * @param param
     * @param response
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("taxMny");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useWorkTypeName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("useWorkDetail");
        //查询本下范围内日的数据
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<ApplicationEntity> pageData = service.queryPage(param, false);
//        导出数据
        logger.info("导出数据----{}", JSONObject.toJSONString(pageData));
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<ApplicationVO> list = BeanMapper.mapList(pageData.getRecords(), ApplicationVO.class);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            DecimalFormat decimalFormat = new DecimalFormat("#,###.00");
            decimalFormat.setRoundingMode(RoundingMode.HALF_DOWN);

            for (ApplicationVO item:list){
                item.setBillStateStr(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
                item.setContractTypeStr(item.getContractType().equals(0)?"劳务分包合同":"专业分包合同");
                item.setTimeStr(sdf.format(item.getCreateTime()));
                item.setUseFlagStr(null != item.getUseFlag() && item.getUseFlag().equals(1) ? "零工已登记" : "零工未登记");
            }
            Map<String, Object> beans = new HashMap<>(list.size());
            beans.put("records", list);
            ExcelExport.getInstance().exportWithTrans("application-export.xlsx", beans, response);
        }
    }


    /**
     * @return
     * @param id 合同Id
     */
    @RequestMapping(value = "/contractApplicationRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> contractApplicationRecord(@RequestParam Long id) {
        JSONObject resp = new JSONObject();

        ContractEntity contract = contractService.selectById(id);

        QueryWrapper<ApplicationEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contract.getId());
        query.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        query.orderByDesc("create_time");

        List<ApplicationEntity> list = service.list(query);
        resp.put("applicationList", BeanMapper.mapList(list, ApplicationVO.class));

        BigDecimal totalApplicationTaxMny = BigDecimal.ZERO;
        for(ApplicationEntity item : list) {
            totalApplicationTaxMny = totalApplicationTaxMny.add(item.getTaxMny());
        }

        resp.put("contractTaxMny", contract.getContractTaxMny());
        resp.put("totalApplicationTaxMny", totalApplicationTaxMny);
        resp.put("applicationRatio", totalApplicationTaxMny.divide(contract.getContractTaxMny(), 8, BigDecimal.ROUND_HALF_UP));

        return CommonResponse.success("查询详情数据成功！", resp);
    }

}
