package com.ejianc.business.prosub.settlePayment.controller;

import java.io.Serializable;

import com.ejianc.business.prosub.settlePayment.SettlePaymentDetailVO;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.settle.service.INodeSettleService;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;

import com.ejianc.business.prosub.settlePayment.bean.SettlePaymentEntity;
import com.ejianc.business.prosub.settlePayment.service.ISettlePaymentService;
import com.ejianc.business.prosub.settlePayment.SettlePaymentVO;

/**
 * 节点结算支付比例确认单主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("settlePayment")
public class SettlePaymentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "LABOR_SETTLE_PAYMENT";//劳务节点结算确认单单据编码
    private static final String PRO_BILL_CODE = "PRO_SETTLE_PAYMENT";//专业节点结算确认单单据编码

    @Autowired
    private ISettlePaymentService service;

    @Autowired
    private INodeSettleService nodeSettleService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlePaymentVO> saveOrUpdate(@RequestBody SettlePaymentVO saveOrUpdateVO) {
    	SettlePaymentEntity entity = BeanMapper.map(saveOrUpdateVO, SettlePaymentEntity.class);
        Boolean flag = nodeSettleService.addSettlePaymentFlag(entity.getSettleId(), entity.getId());
        if (!flag){
            return CommonResponse.error("该结算已存在未生效的结算支付比例确认单！");
        }

        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(entity.getContractType() == 0 ? BILL_CODE : PRO_BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        service.saveOrUpdate(entity, false);
        SettlePaymentVO vo = BeanMapper.map(service.selectById(entity.getId()), SettlePaymentVO.class);
        // 获取结算明细
        List<SettlePaymentDetailVO> voList = vo.getSettlePaymentDetailList();
        if (!voList.isEmpty()) {
            for (SettlePaymentDetailVO detail : voList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0 ? String.valueOf(detail.getParentId()) : null);
            }
            vo.setSettlePaymentDetailList(TreeNodeBUtil.buildTree(voList));
        }
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlePaymentVO> queryDetail(Long id) {
    	SettlePaymentEntity entity = service.selectById(id);
    	SettlePaymentVO vo = BeanMapper.map(entity, SettlePaymentVO.class);
        // 获取结算明细
        List<SettlePaymentDetailVO> voList = vo.getSettlePaymentDetailList();
        if (!voList.isEmpty()) {
            for (SettlePaymentDetailVO detail : voList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0 ? String.valueOf(detail.getParentId()) : null);
            }
            vo.setSettlePaymentDetailList(TreeNodeBUtil.buildTree(voList));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlePaymentVO> vos) {
        service.removeByIds(vos.stream().map(SettlePaymentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }



    /**
     * @Author
     * @Description  新增根据结算主键查询节点结算付款比例确认单需要的信息 新增节点结算付款比例确认单
     * @param settleId
     * @Return
     */
    @RequestMapping(value = "/addConvertBySettleId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlePaymentVO> addConvertBySettleId(Long settleId) {
        SettlePaymentVO vo = service.addConvertBySettleId(settleId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }
}
