package com.ejianc.business.prosub.controller;

import com.ejianc.business.prosub.mapper.ContractManagementMapper;
import com.ejianc.business.prosub.vo.ProjectObjectVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("contractManagement")
public class ContractManagementController {

    private static final Logger log = LoggerFactory.getLogger(ContractManagementController.class);
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ContractManagementMapper mapper;

    @GetMapping("/gmkzysj")
    public CommonResponse<List<Map<String,String>>> gmkzysjSelect(){
        List<Map<String,String>> ans = new ArrayList<>();
        Map<String,String> lwfbht = new HashMap<>();
        lwfbht.put("modeName","合同管理");
        lwfbht.put("modeDataUrl","lwfbht");
        lwfbht.put("modeDaraReqType","GET");
        ans.add(lwfbht);
        Map<String,String> fbfqzspd = new HashMap<>();
        lwfbht.put("modeName","发包方商务管理");
        lwfbht.put("modeDataUrl","fbfqzspd");
        lwfbht.put("modeDaraReqType","GET");
        ans.add(fbfqzspd);
        Map<String,String> wzgl = new HashMap<>();
        lwfbht.put("modeName","物资管理");
        lwfbht.put("modeDataUrl","wzgl");
        lwfbht.put("modeDaraReqType","GET");
        ans.add(wzgl);
        Map<String,String> fenbfswgl = new HashMap<>();
        lwfbht.put("modeName","分包商务管理");
        lwfbht.put("modeDataUrl","fenbfswgl");
        lwfbht.put("modeDaraReqType","GET");
        ans.add(fenbfswgl);
        Map<String,String> jsgli = new HashMap<>();
        lwfbht.put("modeName","技术管理");
        lwfbht.put("modeDataUrl","jsgli");
        lwfbht.put("modeDaraReqType","GET");
        ans.add(jsgli);
        Map<String,String> zljl = new HashMap<>();
        lwfbht.put("modeName","质量管理");
        lwfbht.put("modeDataUrl","zljl");
        lwfbht.put("modeDaraReqType","GET");
        ans.add(zljl);
        Map<String,String> aqjc = new HashMap<>();
        lwfbht.put("modeName","安全管理");
        lwfbht.put("modeDataUrl","aqjc");
        lwfbht.put("modeDaraReqType","GET");
        ans.add(aqjc);
        return CommonResponse.success("查询成功", ans);
    }
    @GetMapping(value = "/lwfbht")
    public CommonResponse<ProjectObjectVo> analysisSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = ProjectObjectVo.build("合同管理");
        List<Long> orgIds = getOrgIds();
        //劳务分包合同
        Map<String, Object> contractMap0 = mapper.contractMapper(0, orgIds,projectId);
        objectVo.put("劳务分包合同",contractMap0);
        //专业分包合同
        Map<String, Object> contractMap1 = mapper.contractMapper(1, orgIds,projectId);
        objectVo.put("专业分包合同",contractMap1);
        //物资采购合同
        Map<String, Object> promaterialMap0 = mapper.promaterialMapper(0, orgIds,projectId);
        objectVo.put("物资采购合同",promaterialMap0);
        //混凝土采购合同
        Map<String, Object> promaterialMap1 = mapper.promaterialMapper(1, orgIds,projectId);
        objectVo.put("混凝土采购合同",promaterialMap1);
        //周转材租赁合同
        Map<String, Object> prormatContracMapper = mapper.prormatContracMapper(orgIds,projectId);
        objectVo.put("周转材租赁合同",prormatContracMapper);
        //施工机械租赁合同
        Map<String, Object> rentContractMapper = mapper.rentContractMapper(orgIds,projectId);
        objectVo.put("施工机械租赁合同",rentContractMapper);
        //处置合同
        Map<String, Object> otherContractMapper = mapper.otherContractMapper(orgIds,projectId);
        objectVo.put("处置合同",otherContractMapper);
        //统计最后数据
        objectVo.add();
        return CommonResponse.success("查询成功", objectVo);
    }

    private List<Long> getOrgIds() {
        CommonResponse<List<OrgVO>> children = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        List<Long> orgIds = children.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        log.info("组织IDS--------------------");
        log.info("组织IDS:{}",orgIds);
        log.info("组织IDS--------------------");
        return orgIds;
    }

    @GetMapping(value = "/fbfqzspd")
    public CommonResponse<ProjectObjectVo> fbfqzspdSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = ProjectObjectVo.build("发包方商务管理");
        List<Long> orgIds = getOrgIds();
        //发包方签证索赔记录单
        Map<String, Object> claimRecordsMapper = mapper.claimRecordsMapper(orgIds,projectId);
        objectVo.put("发包方签证索赔记录单",claimRecordsMapper);
        //发包方签证索赔办理
        Map<String, Object> incomeClaimMapper = mapper.incomeClaimMapper(orgIds,projectId);
        objectVo.put("发包方签证索赔办理",incomeClaimMapper);
        //形象进度单
        Map<String, Object> incomeProgressMapper = mapper.incomeProgressMapper(orgIds,projectId);
        objectVo.put("形象进度单",incomeProgressMapper);
        //对发包方报量
        Map<String, Object> quoteMapper = mapper.incomeQuoteMapper(orgIds,projectId);
        objectVo.put("对发包方报量",quoteMapper);
        //竣工结算单
        Map<String, Object> incomeFinalizedMapper = mapper.incomeFinalizedMapper(orgIds,projectId);
        objectVo.put("竣工结算单",incomeFinalizedMapper);
        //项目预算书
        Map<String, Object> budgetMapper = mapper.incomeBudgetMapper(orgIds,projectId);
        objectVo.put("项目预算书",budgetMapper);
        //数据统计
        objectVo.add();
        return CommonResponse.success("查询成功", objectVo);
    }

    @GetMapping(value = "/wzgl")
    public CommonResponse<ProjectObjectVo> wzglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = ProjectObjectVo.build("物资管理");
        List<Long> orgIds = getOrgIds();
        //分项需用计划
        Map<String, Object> promaterialPlanMapper = mapper.promaterialPlanMapper(orgIds,projectId);
        objectVo.put("分项需用计划",promaterialPlanMapper);
        //单项采购计划
        Map<String, Object> stringObjectMap = mapper.singlePlanMapper(orgIds,projectId);
        objectVo.put("单项采购计划",stringObjectMap);
        //配送计划
        Map<String, Object> promaterialOrderMapper = mapper.promaterialOrderMapper(orgIds,projectId);
        objectVo.put("配送计划",promaterialOrderMapper);
        //材料验收
        Map<String, Object> promaterialCheckMapper = mapper.promaterialCheckMapper(orgIds,projectId);
        objectVo.put("材料验收",promaterialCheckMapper);
        //材料入库
        Map<String, Object> checkStoreMapper = mapper.checkStoreMapper(orgIds,projectId);
        objectVo.put("材料入库",checkStoreMapper);
        //直入直出
        Map<String, Object> concreteCheckMapper = mapper.concreteCheckMapper(orgIds,projectId);
        objectVo.put("直入直出",concreteCheckMapper);
        //领料出库
        Map<String, Object> outStoreMapper = mapper.outStoreMapper(orgIds,projectId);
        objectVo.put("领料出库",outStoreMapper);
        //对账结算（通用）
        Map<String, Object> settlementMapper0 = mapper.promaterialSettlementMapper(0, orgIds,projectId);
        objectVo.put("对账结算（通用）",settlementMapper0);
        //对账结算（钢材）
        Map<String, Object> settlementMapper2 = mapper.promaterialSettlementMapper(2, orgIds,projectId);
        objectVo.put("对账结算（钢材）",settlementMapper2);
        //对账结算（混泥土）
        Map<String, Object> settlementMapper1 = mapper.promaterialSettlementMapper(1, orgIds,projectId);
        objectVo.put("对账结算（混泥土）",settlementMapper1);
        //物资鉴定
        Map<String, Object> storeDefinitionMapper = mapper.storeDefinitionMapper(orgIds,projectId);
        objectVo.put("物资鉴定",storeDefinitionMapper);
        //处置申请
        Map<String, Object> storeApplyMapper = mapper.storeApplyMapper(orgIds,projectId);
        objectVo.put("处置申请",storeApplyMapper);
        //处置明细
        Map<String, Object> disposeMapper = mapper.storeDisposeMapper(orgIds,projectId);
        objectVo.put("处置明细",disposeMapper);
        //对账结算
        Map<String, Object> storeSettleMapper = mapper.storeSettleMapper(orgIds,projectId);
        objectVo.put("对账结算",storeSettleMapper);
        //统计结果
        objectVo.add();
        return CommonResponse.success("查询成功", objectVo);
    }

    @GetMapping(value = "/fenbfswgl")
    public CommonResponse<ProjectObjectVo> fenbfswglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = ProjectObjectVo.build("分包商务管理");
        List<Long> orgIds = getOrgIds();
        //分包招标控制价
        Map<String, Object> prosubControlMapper = mapper.prosubControlMapper(orgIds,projectId);
        objectVo.put("分包招标控制价",prosubControlMapper);
        //项目分包施工指令单
        Map<String, Object> oldjobApplicationMapper = mapper.oldjobApplicationMapper(orgIds,projectId);
        objectVo.put("项目分包施工指令单",oldjobApplicationMapper);
        //合同外分包签证办理
        Map<String, Object> oldjobRegistrationMapper = mapper.oldjobRegistrationMapper(orgIds,projectId);
        objectVo.put("合同外分包签证办理",oldjobRegistrationMapper);
        //分包价格调整与增补
        Map<String, Object> adjustMapper = mapper.priceAdjustMapper(orgIds,projectId);
        objectVo.put("分包价格调整与增补",adjustMapper);
        //分包单位扣罚款
        Map<String, Object> prosubDeductionMapper = mapper.prosubDeductionMapper(orgIds,projectId);
        objectVo.put("分包单位扣罚款",prosubDeductionMapper);
        //分包形象进度审核表
        Map<String, Object> prosubProgressMapper = mapper.prosubProgressMapper(orgIds,projectId);
        objectVo.put("分包形象进度审核表",prosubProgressMapper);
        // 分包中间计量
        Map<String, Object> prosubSettleMapper0 = mapper.prosubSettleMapper(0, orgIds,projectId);
        objectVo.put("分包中间计量",prosubSettleMapper0);
        // 分包结算
        Map<String, Object> prosubSettleMapper1 = mapper.prosubSettleMapper(1, orgIds,projectId);
        objectVo.put("分包结算",prosubSettleMapper1);
        //统计结果
        objectVo.add();
        return CommonResponse.success("查询成功", objectVo);
    }

    @GetMapping(value = "/jsgli")
    public CommonResponse<ProjectObjectVo> jsgliSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = ProjectObjectVo.build("技术管理");
//        图纸登记
        List<Long> orgIds = getOrgIds();
        Map<String, Object> drawingRegistrationMapper = mapper.drawingRegistrationMapper(orgIds,projectId);
        objectVo.put("图纸登记",drawingRegistrationMapper);
//        图纸会审
        Map<String, Object> tecDrawingTriageMapper = mapper.tecDrawingTriageMapper(orgIds,projectId);
        objectVo.put("图纸会审",tecDrawingTriageMapper);
//        设计变更
        Map<String, Object> tecDesignChangeMapper = mapper.tecDesignChangeMapper(orgIds,projectId);
        objectVo.put("设计变更",tecDesignChangeMapper);
//        施工方案
        Map<String, Object> constructionSchemeMapper = mapper.constructionSchemeMapper(orgIds,projectId);
        objectVo.put("施工方案",constructionSchemeMapper);
//        施工方案交底
        Map<String, Object> disclosureMapper = mapper.constructionDisclosureMapper(orgIds,projectId);
        objectVo.put("施工方案交底",disclosureMapper);
//        分项工程质量技术交底
        Map<String, Object> qualitiedDisclosureMapper = mapper.qualityDisclosureMapper(orgIds,projectId);
        objectVo.put("分项工程质量技术交底",qualitiedDisclosureMapper);
//        分项工程安全技术交底
        Map<String, Object> safetyDisclosureMapper = mapper.safetyDisclosureMapper(orgIds,projectId);
        objectVo.put("分项工程安全技术交底",safetyDisclosureMapper);
//        设计变更交底
        Map<String, Object> changeDisclosureMapper = mapper.changeDisclosureMapper(orgIds,projectId);
        objectVo.put("设计变更交底",changeDisclosureMapper);
        //统计结果
        objectVo.add();
        return CommonResponse.success("查询成功", objectVo);
    }

    @GetMapping(value = "/zljl")
    public CommonResponse<ProjectObjectVo> zlglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = ProjectObjectVo.build("质量管理");
        List<Long> orgIds = getOrgIds();
//        质量隐患检查
        Map<String, Object> sceneCheckMapper = mapper.sceneCheckMapper(orgIds,projectId);
        objectVo.put("质量隐患检查",sceneCheckMapper);
//        待整改
        Map<String, Object> sceneCheckDetailMapper1 = mapper.sceneCheckDetailMapper(1, orgIds,projectId);
        objectVo.put("待整改",sceneCheckDetailMapper1);
//        待复查
        Map<String, Object> sceneCheckDetailMapper2 = mapper.sceneCheckDetailMapper(2, orgIds,projectId);
        objectVo.put("待复查",sceneCheckDetailMapper2);
//        质量隐患检查台账
        Map<String, Object> sceneCheckListMapper = mapper.sceneCheckListMapper(orgIds,projectId);
        objectVo.put("质量隐患检查台账",sceneCheckListMapper);
//        QC小组注册
        Map<String, Object> qualityRegisterMapper = mapper.qualityRegisterMapper(orgIds,projectId);
        objectVo.put("QC小组注册",qualityRegisterMapper);
//        QC小组课题登记
        Map<String, Object> qualitySubjectMapper = mapper.qualitySubjectMapper(orgIds,projectId);
        objectVo.put("QC小组课题登记",qualitySubjectMapper);
//        QC小组活动成果
        Map<String, Object> qualityActivityMapper = mapper.qualityActivityMapper(orgIds,projectId);
        objectVo.put("QC小组活动成果",qualityActivityMapper);
        //统计结果
        objectVo.add();
        return CommonResponse.success("查询成功", objectVo);
    }

    @GetMapping(value = "/aqjc")
    public CommonResponse<ProjectObjectVo> aqjcSelect(@RequestParam(value = "id", required = false) Long projectId) {
        //安全管理
        ProjectObjectVo objectVo = ProjectObjectVo.build("安全管理");
        List<Long> orgIds = getOrgIds();
//        安全隐患检查
        Map<String, Object> sceneCheckMapper = mapper.sceneCheckMapper(orgIds,projectId);
        objectVo.put("安全隐患检查",sceneCheckMapper);
//        待整改
        Map<String, Object> sceneCheckDetailMapper1 = mapper.sceneCheckDetailMapper(1, orgIds,projectId);
        objectVo.put("待整改",sceneCheckDetailMapper1);
//        待复查
        Map<String, Object> sceneCheckDetailMapper2 = mapper.sceneCheckDetailMapper(2, orgIds,projectId);
        objectVo.put("待复查",sceneCheckDetailMapper2);
//        安全隐患检查台账
        Map<String, Object> sceneCheckListMapper = mapper.safetySceneCheckListMapper(orgIds,projectId);
        objectVo.put("安全隐患检查台账",sceneCheckListMapper);
        //统计结果
        objectVo.add();
        return CommonResponse.success("查询成功", objectVo);
    }



}
