package com.ejianc.business.process.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.process.bean.ProgressDetailEntity;
import com.ejianc.business.process.vo.ProgressDetailVO;
import com.ejianc.business.process.vo.ProgressVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.process.mapper.ProgressMapper;
import com.ejianc.business.process.bean.ProgressEntity;
import com.ejianc.business.process.service.IProgressService;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

/**
 * 分包形象进度审核表
 * 
 * @author generator
 * 
 */
@Service("progressService")
public class ProgressServiceImpl extends BaseServiceImpl<ProgressMapper, ProgressEntity> implements IProgressService{

    @Override
    public ProgressVO queryDetailByConDesc(Long contractId) {
        LambdaQueryWrapper<ProgressEntity> qw = Wrappers.lambdaQuery();
        qw.eq(ProgressEntity::getContractId,contractId)
                .eq(ProgressEntity::getDr,0)
                .in(ProgressEntity::getBillState, Arrays.asList(1,3))
                .orderByDesc(ProgressEntity::getCreateTime)
                .last("limit 1");
        ProgressEntity entity = super.getOne(qw);
        ProgressVO vo = null;
        if (null!=entity&&null!=entity.getEndTime()) {
            vo = BeanMapper.map(entity, ProgressVO.class);
            Calendar instance = Calendar.getInstance();
            instance.setTime(entity.getEndTime());
            instance.add(Calendar.DATE, 1);
            vo.setEndTimeAdd1(instance.getTime());

            //获取子表信息
            ProgressEntity progressEntity = super.selectById(vo.getId());
            List<ProgressDetailEntity> progressDetailList = progressEntity.getProgressDetailList();
            for (ProgressDetailEntity progressDetailEntity : progressDetailList){
                progressDetailEntity.setSumProgress(progressDetailEntity.getCurrentProgress());
                progressDetailEntity.setSumProgressRecord(progressDetailEntity.getCurrentProgress());
                progressDetailEntity.setCurrentProgress(null);
            }
            List<ProgressDetailVO> progressDetailVOS = BeanMapper.mapList(progressDetailList, ProgressDetailVO.class);
            vo.setProgressDetailList(progressDetailVOS);


        }

        return vo;
    }
}
