package com.ejianc.business.process.service;


import com.ejianc.business.process.bean.PicKingEntity;
import com.ejianc.business.process.vo.PicKingVO;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;


public interface IPickingService extends IBaseService<PicKingEntity> {

    /**
     * 根据分类依据与合同查询 当前合同下已经生效的领料结算 并查询其汇总表中的物质累计数量
     * @param pickingId
     * @param classifyCondition
     * @return
     */
    BigDecimal queryTotalNum(Long pickingId,String classifyCondition);



    /**
     * 单据推送到供方协同服务
     *
     * @param measureEntity 待推送单据
     * @param billTypeCode 待推送单据的单据类型编码
     * @param cooperate 待推送单据的协同配置信息
     * @return
     */
    boolean pushBillToSupCenter(PicKingEntity picKingEntity, String billTypeCode, CooperateVO cooperate);

    /**
     * 同步单据供供应商签字信息
     *
     * @param request
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    /**
     * 将推送至供方的单据作废
     *
     * @param measureEntity
     * @param billTypeCode
     * @return
     */
    boolean delPushBill(PicKingEntity picKingEntity, String billTypeCode);


    /**
     * 查询当前合同下领料出库合同退库
     * @param contractId
     * @param projectId
     * @return
     */
    CommonResponse<PicKingVO> queryPicking(Long contractId, Long projectId);

    void deletePicking(Long id);
}
