/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.enums.SignatureStatusEnum;
import com.ejianc.business.settle.service.IFinishSettleService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"finishSettle"})
public class FinishSettleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFinishSettleService service;
    @Autowired
    private ISettleService settleService;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        SettleVO vo = this.service.saveFinishSettle(saveOrUpdateVO);
        List voList = vo.getSettleDetailList();
        if (!voList.isEmpty()) {
            for (SettleDetailVO detail : voList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0L ? String.valueOf(detail.getParentId()) : null);
            }
            vo.setSettleDetailList(TreeNodeBUtil.buildTree((List)voList));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleVO vo;
        List detailList;
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            CommonResponse.error((String)"\u67e5\u8be2\u8be6\u60c5\u5f02\u5e38\uff01");
        }
        if (!(detailList = (vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class)).getSettleDetailList()).isEmpty()) {
            for (SettleDetailVO detail : detailList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0L ? String.valueOf(detail.getParentId()) : null);
                detail.setParentId(null != detail.getTpid() ? Long.valueOf(detail.getTpid()) : null);
            }
            vo.setSettleDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        List<Long> billIds = vos.stream().map(SettleVO::getId).collect(Collectors.toList());
        String checkResult = this.settleService.delCheck(billIds);
        if (StringUtils.isNotBlank((CharSequence)checkResult)) {
            return CommonResponse.error((String)checkResult);
        }
        this.settleService.delSettleTargetCostInfo(billIds);
        this.settleService.delSettleCostInfo(billIds);
        this.service.removeByIds(billIds, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("settle_type", new Parameter("eq", (Object)SettleTypeEnum.\u5b8c\u5de5.getCode()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        List records = pageData.getRecords();
        ArrayList<SettleVO> ans = new ArrayList<SettleVO>();
        for (SettleVO vo : records) {
            this.logger.info("/ejc-prosub-web/finishSettle/queryList: 1=>{}", (Object)vo.getSumApproveTaxMny());
            this.logger.info("/ejc-prosub-web/finishSettle/queryList: 2=>{}", (Object)vo.getSumReportTaxMny());
            if (vo.getSumApproveTaxMny() == null || vo.getSumApproveTaxMny().compareTo(BigDecimal.ZERO) == 0) {
                vo.setSumApproveTaxMny(vo.getSumReportTaxMny());
            }
            this.logger.info("/ejc-prosub-web/finishSettle/queryList:3=>{}", (Object)vo.getTaxMny());
            vo.setTotalNodeTaxDifference(vo.getSumApproveTaxMny().subtract(vo.getTaxMny()));
            this.logger.info("/ejc-prosub-web/finishSettle/queryList:4=>{}", (Object)vo.getTotalNodeTaxDifference());
            ans.add(vo);
        }
        pageData.setRecords(ans);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("settle_type", new Parameter("eq", (Object)SettleTypeEnum.\u5b8c\u5de5.getCode()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, SettleVO.class);
        voList.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vo.setSignStatusName(Objects.equals(vo.getSupplierSignStatus(), SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode()) ? "\u4e59\u65b9\u672a\u7b7e\u5b57" : "\u4e59\u65b9\u5df2\u7b7e\u5b57");
            vo.setSignatureStatusName(SignatureStatusEnum.getEnumByCode(vo.getSignatureStatus()).getDescription());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("finishSettle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSettleData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<SettleVO>> refSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryUnusedContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType) {
        return this.service.queryUnusedContract(contractId, settleDate, settleType);
    }

    @RequestMapping(value={"/queryFinishFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse queryFinishFlag(Long contractId) {
        return this.service.queryFinishFlag(contractId);
    }

    @RequestMapping(value={"/mnyCtrl"}, method={RequestMethod.POST})
    public CommonResponse<ParamsCheckVO> mnyCtrl(@RequestBody SettleVO settleVO) {
        ParamsCheckVO response = this.service.mnyCtrl(settleVO);
        if (response == null) {
            this.logger.error("\u6700\u7ec8\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u5931\u8d25");
            response = new ParamsCheckVO();
        }
        ParamsCheckVO responseData = this.paramCheck(settleVO, response, false);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    @RequestMapping(value={"/mnyCtrlById"}, method={RequestMethod.GET})
    public CommonResponse<ParamsCheckVO> mnyCtrlById(@RequestParam(value="id") Long id) {
        SettleEntity settle = (SettleEntity)((Object)this.service.selectById(id));
        if (settle == null) {
            return CommonResponse.error((String)"\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728\uff01");
        }
        SettleVO settleVO = (SettleVO)BeanMapper.map((Object)((Object)settle), SettleVO.class);
        ParamsCheckVO response = this.service.mnyCtrl(settleVO);
        if (response == null) {
            this.logger.error("\u6700\u7ec8\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u5931\u8d25");
            response = new ParamsCheckVO();
        }
        ParamsCheckVO responseData = this.paramCheck(settleVO, response, true);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    private ParamsCheckVO paramCheck(@RequestBody SettleVO settleVO, ParamsCheckVO responseData, boolean flag) {
        String responseDataWarnType = responseData.getWarnType();
        int resWarnTypeInt = ParamCtrlUtil.getWarnTypeInt(responseDataWarnType, 1);
        ParamsCheckVO checkVO = this.service.numCtrl(settleVO, flag);
        String warnType = checkVO.getWarnType();
        if (StringUtils.isNotBlank((CharSequence)warnType) && !"none".equals(warnType)) {
            List list;
            int changeWarnTypeInt = ParamCtrlUtil.getWarnTypeInt(warnType, 2);
            if (changeWarnTypeInt > resWarnTypeInt) {
                return checkVO;
            }
            if (changeWarnTypeInt == resWarnTypeInt && CollectionUtils.isNotEmpty((Collection)(list = checkVO.getDataSource()))) {
                responseData.getDataSource().addAll(list);
            }
        }
        return responseData;
    }

    @GetMapping(value={"/pushTargetCost"})
    public CommonResponse<String> pushTargetCost(@RequestParam(value="id") Long id) {
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(id));
        SettleVO settleVO = this.service.getPushTargetCostSettleVO(settleEntity);
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BASE_HOST;
        String linkUrl = settleVO.getContractType() == 0 ? frontendBaseHost + "ejc-prosub-frontend/#/finishSettle/laborsub/card?id=" + settleVO.getId() : frontendBaseHost + "ejc-prosub-frontend/#/finishSettle/prosub/card?id=" + settleVO.getId();
        ExecutionVO executionVO = this.service.targetCost(settleVO, linkUrl, settleVO.getContractType());
        this.logger.info("\u624b\u52a8\uff1a\u5b8c\u5de5\u7ed3\u7b97\u7b56\u5212\u6210\u672c\u63a8\u9001\u6570\u636e\uff1a {}", (Object)JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        this.logger.info("\u624b\u52a8\uff1a\u5b8c\u5de5\u7ed3\u7b97\u7b56\u5212\u6210\u672c\u63a8\u9001\u6570\u636e\u7ed3\u679c\uff1a {}", (Object)JSON.toJSONString((Object)response));
        return response;
    }
}

