/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.prosub.bean.ChangeEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.ProsubBillTypeChangeCodeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeCodeEnum;
import com.ejianc.business.prosub.service.IChangeService;
import com.ejianc.business.prosub.service.IContractFileService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="contractFileService")
public class ContractFileServiceImpl
implements IContractFileService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IChangeService changeService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject updateSignedFileInfo(Long billId, String billType) {
        BaseEntity entity;
        JSONObject resp = new JSONObject();
        ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
        ContractVO cv = new ContractVO();
        if ("contract".equals(billType)) {
            entity = (ContractEntity)((Object)this.contractService.selectById(billId));
            Assert.notNull((Object)entity, (String)"\u67e5\u8be2\u4e0d\u5230\u4e3b\u5408\u540c\u8be6\u60c5");
            cv.setContractId(entity.getId());
            cv.setContractName(entity.getContractName());
            cv.setSourceType(billType);
            String billTypeCodeStr = ProsubBillTypeCodeEnum.getEnumByContractType((Integer)entity.getContractType()).getDescription();
            cv.setBillType(billTypeCodeStr);
            cvs.add(cv);
        } else {
            entity = (ChangeEntity)((Object)this.changeService.selectById(billId));
            Assert.notNull((Object)entity, (String)"\u67e5\u8be2\u4e0d\u5230\u53d8\u66f4\u5408\u540c\u8be6\u60c5");
            cv.setContractId(entity.getId());
            cv.setContractName(entity.getContractName());
            cv.setSourceType(billType);
            String changeBillTypeCodeStr = ProsubBillTypeChangeCodeEnum.getEnumByContractType((Integer)entity.getContractType()).getDescription();
            cv.setBillType(changeBillTypeCodeStr);
            cvs.add(cv);
        }
        CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
        if (!signResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5355\u636eid-{}\uff0cbillType-{}\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: {}", new Object[]{billId, billType, signResp.getMsg()});
        } else {
            List fileList = (List)signResp.getData();
            if (CollectionUtils.isEmpty((Collection)fileList)) {
                this.logger.error("\u672a\u83b7\u53d6\u5230\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f");
            } else {
                SignMgrPreviewVO signedFileInfo = (SignMgrPreviewVO)((List)signResp.getData()).get(0);
                if ("contract".equals(billType)) {
                    ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(billId));
                    contract.setSignedFileId(signedFileInfo.getFileId());
                    this.contractService.saveOrUpdate((Object)contract, false);
                } else {
                    ChangeEntity contractChange = (ChangeEntity)((Object)this.changeService.selectById(billId));
                    contractChange.setChangeSignedFileId(signedFileInfo.getFileId());
                    this.changeService.saveOrUpdate((Object)contractChange, false);
                }
                resp.put("fileId", (Object)signedFileInfo.getFileId());
                resp.put("filePath", (Object)signedFileInfo.getFilePath());
                resp.put("fileTruePath", (Object)signedFileInfo.getTruePath());
            }
        }
        return resp;
    }
}

