/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"oddjobWorkTable"})
public class OddjobWorkTableController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;

    @ResponseBody
    @RequestMapping(value={"/getQueryParam"}, method={RequestMethod.GET})
    public CommonResponse<QueryParam> getQueryParam(HttpServletRequest req) {
        try {
            Long orgId;
            String leftTreeId = req.getParameter("leftTreeId");
            if (StringUtils.isNotEmpty((String)leftTreeId)) {
                this.logger.info("leftTreeId:::" + leftTreeId);
                orgId = Long.valueOf(leftTreeId);
            } else {
                orgId = InvocationInfoProxy.getOrgId();
            }
            QueryParam queryParam = new QueryParam();
            OrgVO orgVO = new OrgVO();
            orgVO.setId(orgId);
            CommonResponse oneByOrgVO = this.orgApi.findOneByOrgVO(orgVO);
            if (!oneByOrgVO.isSuccess()) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(((OrgVO)oneByOrgVO.getData()).getOrgType())) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                CommonResponse orgResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                queryParam.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            this.logger.info("\u8fd4\u56de\u4fe1\u606f queryParam:" + JSONObject.toJSONString((Object)queryParam));
            return CommonResponse.success((Object)queryParam);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }
}

