package com.ejianc.business.prosub.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.prosub.mapper.ContractManagementMapper;
import com.ejianc.business.prosub.service.IContractManagementService;
import com.ejianc.business.prosub.vo.ProjectObjectVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

@RestController
@RequestMapping("contractManagement")
public class ContractManagementController {

    private static final Logger log = LoggerFactory.getLogger(ContractManagementController.class);
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IContractManagementService service;

    @GetMapping("/gmkzysj")
    public CommonResponse<List<Map<String, String>>> gmkzysjSelect() {
        List<Map<String, String>> ans = new ArrayList<>();
        Map<String, String> lwfbht = new HashMap<>();
        lwfbht.put("modeName", "合同管理");
        lwfbht.put("modeDataUrl", "lwfbht");
        lwfbht.put("modeDaraReqType", "GET");
        ans.add(lwfbht);
        Map<String, String> fbfqzspd = new HashMap<>();
        fbfqzspd.put("modeName", "发包方商务管理");
        fbfqzspd.put("modeDataUrl", "fbfqzspd");
        fbfqzspd.put("modeDaraReqType", "GET");
        ans.add(fbfqzspd);
        Map<String, String> wzgl = new HashMap<>();
        wzgl.put("modeName", "物资管理");
        wzgl.put("modeDataUrl", "wzgl");
        wzgl.put("modeDaraReqType", "GET");
        ans.add(wzgl);
        Map<String, String> fenbfswgl = new HashMap<>();
        fenbfswgl.put("modeName", "分包商务管理");
        fenbfswgl.put("modeDataUrl", "fenbfswgl");
        fenbfswgl.put("modeDaraReqType", "GET");
        ans.add(fenbfswgl);
        Map<String, String> jsgli = new HashMap<>();
        jsgli.put("modeName", "技术管理");
        jsgli.put("modeDataUrl", "jsgli");
        jsgli.put("modeDaraReqType", "GET");
        ans.add(jsgli);
        Map<String, String> zljl = new HashMap<>();
        zljl.put("modeName", "质量管理");
        zljl.put("modeDataUrl", "zljl");
        zljl.put("modeDaraReqType", "GET");
        ans.add(zljl);
        Map<String, String> aqjc = new HashMap<>();
        aqjc.put("modeName", "安全管理");
        aqjc.put("modeDataUrl", "aqjc");
        aqjc.put("modeDaraReqType", "GET");
        ans.add(aqjc);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/lwfbht")
    public CommonResponse<String> analysisSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = service.analysisSelect(projectId);

        String jsonString = JSONObject.toJSONString(objectVo);
        return CommonResponse.success("查询成功", jsonString);
    }

    private List<Long> getOrgIds() {
        CommonResponse<List<OrgVO>> children = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        List<Long> orgIds = children.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        log.info("组织IDS--------------------");
        log.info("组织IDS:{}", orgIds.isEmpty() ? "没有组织ID":"有组织ID");
        log.info("组织IDS--------------------");
        return orgIds;
    }

    @GetMapping(value = "/fbfqzspd")
    public CommonResponse<String> fbfqzspdSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = service.fbfqzspdSelect(projectId);
        String jsonString = JSONObject.toJSONString(objectVo);
        return CommonResponse.success("查询成功", jsonString);
    }

    @GetMapping(value = "/wzgl")
    public CommonResponse<String> wzglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = service.wzglSelect(projectId);
        return CommonResponse.success("查询成功", JSONObject.toJSONString(objectVo));
    }

    @GetMapping(value = "/fenbfswgl")
    public CommonResponse<String> fenbfswglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = service.fenbfswglSelect(projectId);

        return CommonResponse.success("查询成功", JSONObject.toJSONString(objectVo));
    }

    @GetMapping(value = "/jsgli")
    public CommonResponse<String> jsgliSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = service.jsgliSelect(projectId);
        return CommonResponse.success("查询成功", JSONObject.toJSONString(objectVo));
    }

    @GetMapping(value = "/zljl")
    public CommonResponse<String> zlglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = service.zlglSelect(projectId);
        return CommonResponse.success("查询成功", JSONObject.toJSONString(objectVo));
    }

    @GetMapping(value = "/aqjc")
    public CommonResponse<String> aqjcSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = service.aqjcSelect(projectId);
        return CommonResponse.success("查询成功", JSONObject.toJSONString(objectVo));
    }


    @GetMapping("/yunyingtongji")
    public CommonResponse<String> yunyingtongjiSelect() throws ExecutionException, InterruptedException {
        //1.查询所有项目名称
        Map<String, Long> orgVo = getOrgVo();
        //CompletableFuture<ProjectObjectVo> latch = new CompletableFuture<>();
        List<ProjectObjectVo> projectObjectVos = service.yunyingtongjiSelect(orgVo);
        return CommonResponse.success("查询成功",
                JSONObject.toJSONString(projectObjectVos));
    }
    private Map<String,Long> getOrgVo() {
        CommonResponse<List<OrgVO>> children = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        Map<String,Long> map = new HashMap<>();
        children.getData().forEach(an -> {
            if (!an.getIsParent()) {
                map.put(an.getName(),an.getId());
            }
        });
        return map;
    }

}

