/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contract.relieve.service.IContractRelieveService;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.process.bean.AdjustEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.service.IAdjustService;
import com.ejianc.business.process.service.IMeasureDetailService;
import com.ejianc.business.prosub.bean.ContractDetailEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.PerformanceStatusEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.enums.SignatureStatusEnum;
import com.ejianc.business.prosub.service.IContractDetailService;
import com.ejianc.business.prosub.service.IContractOtherCostService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.service.impl.ContractDetailServiceImpl;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.prosub.vo.ContractDetailVO;
import com.ejianc.business.prosub.vo.ContractOtherCostVO;
import com.ejianc.business.prosub.vo.ContractPaymentResultVO;
import com.ejianc.business.prosub.vo.ContractPaymentVO;
import com.ejianc.business.prosub.vo.ContractSettleDetailsReportVO;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springside.modules.nosql.redis.JedisTemplate;

@Controller
@RequestMapping(value={"contract"})
public class ContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractService service;
    @Autowired
    private IContractDetailService detailService;
    @Autowired
    private IShareLabsubApi labsubApi;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    @Autowired
    private IShareProsubApi prosubApi;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IContractOtherCostService otherCostService;
    @Autowired
    private IParamCheckApi paramCheckApi;
    private final String LABORSUB_Bill_CODE = "BT211108000000002";
    private final String PROSUB_Bill_CODE = "BT220216000000003";
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private IMeasureDetailService measureDetailService;
    @Autowired
    private IContractRelieveService contractRelieveService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IAdjustService adjustService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    private final String PUSH_POOL_PREFIX = "pushContract::";
    private final String FILLING_TYPE_STATE = "P-eg7rBO0134";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ContractDetailServiceImpl contractDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        ContractVO vo = this.service.insertOrUpdate(saveorUpdateVO, authority, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)this.service.queryDetail(vo.getId()));
    }

    @GetMapping(value={"/getContractFileMgrInfo"})
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value="contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(contractId));
        CommonResponse categoryResp = this.templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if (!categoryResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5408\u540c\u7c7b\u522bI\u7684-{}\u67e5\u8be2\u5bf9\u5e94\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)contractEntity.getContractCategoryId(), (Object)categoryResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25");
        }
        TemplateCategoryVO category = (TemplateCategoryVO)categoryResp.getData();
        resp.put("contactId", (Object)contractEntity.getId());
        if (null != contractEntity.getContractType() && contractEntity.getContractType().equals(0)) {
            resp.put("contractBillTypeCode", (Object)"BT211108000000002");
        }
        if (null == contractEntity.getContractType() || !contractEntity.getContractType().equals(1)) {
            resp.put("contractBillTypeCode", (Object)"BT220216000000003");
        }
        if (null != contractEntity.getContractType() && contractEntity.getContractType().equals(2)) {
            resp.put("contractBillTypeCode", (Object)ProsubBillTypeEnum.\u7279\u79cd\u8bbe\u5907\u79df\u8d41\u5408\u540c.getBillTypeCode());
        }
        if (null != contractEntity.getContractType() && contractEntity.getContractType().equals(3)) {
            resp.put("contractBillTypeCode", (Object)ProsubBillTypeEnum.\u5176\u4ed6\u5206\u5305\u5408\u540c.getBillTypeCode());
        }
        resp.put("contractCategoryId", (Object)category.getId());
        resp.put("boBillType", (Object)category.getBillTypeCode());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        ContractVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        return this.service.deleteByIds(vos);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap beans = new HashMap();
        param.setPageSize(-1);
        Object contractType = ((Parameter)param.getParams().get("contractType")).getValue();
        Integer contractTypeInt = null;
        if (contractType == null) {
            throw new IllegalArgumentException("contractType\u4e0d\u80fd\u4e3anull");
        }
        try {
            String strValue = contractType.toString();
            contractTypeInt = Integer.parseInt(strValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("contractType\u4e0d\u662f\u6709\u6548\u7684\u6574\u6570\u683c\u5f0f");
        }
        CommonResponse<JSONObject> commonResponse = this.pageList(param);
        List contractVOList = new ArrayList();
        if (null != commonResponse.getData() && null != (contractVOList = (List)((JSONObject)commonResponse.getData()).get((Object)"records")) && contractVOList.size() > 0) {
            contractVOList.forEach(c -> {
                if (StringUtils.isBlank((String)c.getPerformanceStatus())) {
                    c.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getDescription());
                } else {
                    this.logger.info("\u5408\u540c\u72b6\u6001\uff1a{}", (Object)c.getPerformanceStatus());
                    this.logger.info("\u72b6\u6001\u7801\uff1a", (Object)PerformanceStatusEnum.getEnumByCode(c.getPerformanceStatus()).getDescription());
                    c.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode(c.getPerformanceStatus()).getDescription());
                }
                if (StringUtils.isBlank((String)c.getSignatureStatus())) {
                    c.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getDescription());
                } else {
                    c.setSignatureStatus(SignatureStatusEnum.getEnumByCode(c.getSignatureStatus()).getDescription());
                }
                c.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription());
            });
        }
        beans.put("records", contractVOList);
        String exitsName = null;
        if (contractTypeInt == 0 || contractTypeInt == 1) {
            exitsName = "prosubContract-export.xlsx";
        }
        if (contractTypeInt == 2) {
            exitsName = "equipmentsubContract-export.xlsx";
        }
        if (contractTypeInt == 3) {
            exitsName = "othersubContract-export.xlsx";
        }
        ExcelExport.getInstance().export(exitsName, beans, response);
    }

    @RequestMapping(value={"/downloadExcelModel"})
    @ResponseBody
    public void downloadExcelModel(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Contract-import-template.xlsx", (String)"\u5408\u540c\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/downloadEquipmentExcelModel"})
    @ResponseBody
    public void downloadEquipmentExcelModel(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"ContractEquipment-import-template.xlsx", (String)"\u7279\u79cd\u8bbe\u5907\u5408\u540c\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/downloadOtherExcelModel"})
    @ResponseBody
    public void downloadOtherExcelModel(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"ContractOther-import-template.xlsx", (String)"\u5176\u4ed6\u5206\u5305\u5408\u540c\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response, 0);
        return commonResponse;
    }

    @RequestMapping(value={"/excelImportOne"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportOne(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response, 1);
        return commonResponse;
    }

    @RequestMapping(value={"/excelImportEquipment"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportEquipment(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImportEquipment(request, response, 2);
        return commonResponse;
    }

    @RequestMapping(value={"/excelImportOther"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportOther(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImportEquipment(request, response, 3);
        return commonResponse;
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        LinkedHashMap orderMap = new LinkedHashMap();
        if (param.getOrderMap().containsKey("createTime") && null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        String filingTypeConfig = this.service.getFilingTypeConfig();
        IPage pageData = this.service.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        page.put("filingTypeConfig", (Object)filingTypeConfig);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @ResponseBody
    @RequestMapping(value={"/prosubContractRef"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> prosubContractRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        String filingTypeConfig;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        if (null == condition || StringUtils.isBlank((String)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("orgId") && null == conditionMap.get("projectId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u9879\u76eeid \u6216 \u7ec4\u7ec7id\u4e3a\u7a7a\uff01");
        }
        if (null != conditionMap.get("orgId") && null == conditionMap.get("orgType")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        if (null != conditionMap.get("contractType")) {
            queryParam.getParams().put("contractType", new Parameter("eq", conditionMap.get("contractType")));
        }
        if (null != conditionMap.get("categoryId")) {
            CommonResponse categoryVOResp = this.templateCategoryApi.querySelfAndChildById(Long.valueOf(conditionMap.get("categoryId").toString()));
            if (!categoryVOResp.isSuccess()) {
                return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List categoryIds = ((List)categoryVOResp.getData()).stream().map(item -> item.getId()).collect(Collectors.toList());
            switch (categoryIds.size()) {
                case 0: {
                    JSONObject page = new JSONObject();
                    page.put("records", new ArrayList());
                    page.put("total", (Object)0);
                    page.put("current", (Object)queryParam.getPageIndex());
                    page.put("size", (Object)queryParam.getPageSize());
                    page.put("pages", (Object)0);
                    return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u6570\u636e\u6210\u529f\uff01", (Object)page);
                }
                case 1: {
                    queryParam.getParams().put("contractCategoryId", new Parameter("eq", categoryIds.get(0)));
                    break;
                }
                default: {
                    queryParam.getParams().put("contractCategoryId", new Parameter("in", categoryIds));
                }
            }
        }
        if (null != conditionMap.get("projectId")) {
            Long projectId = Long.parseLong(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        } else {
            Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                queryParam.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        if (conditionMap.containsKey("contractId")) {
            ArrayList<Long> contractIds = new ArrayList<Long>();
            contractIds.add(Long.parseLong(conditionMap.get("contractId").toString()));
            queryParam.getParams().put("id", new Parameter("not_in", contractIds));
        }
        if ("2".equals(filingTypeConfig = this.service.getFilingTypeConfig())) {
            queryParam.getParams().put("filingStatus", new Parameter("eq", (Object)1));
        } else if ("1".equals(filingTypeConfig)) {
            this.logger.info("conditionMap\u4e2d\u7684\u503c\u4e3a\uff1a", (Object)JSONObject.toJSONString((Object)conditionMap));
            this.logger.info(conditionMap.containsKey("contractFilingType") ? "condition\u5305\u542bcontractFilingType\u503c\u4e3a" + conditionMap.get("contractFilingType").toString() : "condition\u4e0d\u5305\u542bcontractFilingType");
            if (conditionMap.containsKey("contractFilingType") && "settle".equals(conditionMap.get("contractFilingType").toString())) {
                queryParam.getParams().put("filingStatus", new Parameter("eq", (Object)1));
            }
        }
        queryParam.getParams().put("performance_status", new Parameter("eq", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode()));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != queryParam.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", queryParam.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        queryParam.setOrderMap(orderMap);
        this.logger.info("\u5206\u5305\u5408\u540c\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u6761\u4ef6---------->" + JSONObject.toJSONString((Object)queryParam.getParams()));
        orderMap.put("create_time", "desc");
        queryParam.setOrderMap(orderMap);
        IPage pageData = this.service.queryPage(queryParam, false);
        this.logger.info("\u5206\u5305\u5408\u540c\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u7ed3\u679c\u6761\u6570---------->" + pageData.getRecords().size());
        List contractVOList = BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVO.class);
        if (CollectionUtils.isNotEmpty((Collection)contractVOList)) {
            List ids = contractVOList.stream().map(ContractVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper qw = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.in(AdjustEntity::getContractId, ids)).in(AdjustEntity::getBillState, Arrays.asList(1, 3))).eq(BaseEntity::getDr, (Object)0);
            List list = this.adjustService.list((Wrapper)qw);
            HashMap<Long, BigDecimal> mnyMap = new HashMap<Long, BigDecimal>();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (AdjustEntity adjustEntity : list) {
                    mnyMap.merge(adjustEntity.getContractId(), ComputeUtil.nullToZero((BigDecimal)adjustEntity.getApproveMny()), BigDecimal::add);
                }
            }
            for (ContractVO vo : contractVOList) {
                vo.setSumAdjustMny((BigDecimal)mnyMap.get(vo.getId()));
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", (Object)contractVOList);
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @ResponseBody
    @RequestMapping(value={"/prosubContractDetailRef"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> prosubContractDetailRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("detailName");
        fuzzyFields.add("detailWorkContent");
        fuzzyFields.add("detailMeasurementRules");
        if (null == condition || StringUtils.isBlank((String)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("contractId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
        }
        String calcLastTotalNum = null != conditionMap.get("calcLastTotalNum") ? conditionMap.get("calcLastTotalNum").toString() : null;
        queryParam.getParams().put("contract_id", new Parameter("eq", conditionMap.get("contractId")));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("detail_price", new Parameter("ne", null));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time", "desc");
        queryParam.setOrderMap(orderMap);
        this.logger.info("\u5206\u5305\u5408\u540c\u660e\u7ec6\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u6761\u4ef6---------->" + JSONObject.toJSONString((Object)queryParam.getParams()));
        IPage pageData = this.detailService.queryPage(queryParam, false);
        this.logger.info("\u5206\u5305\u5408\u540c\u660e\u7ec6\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u7ed3\u679c\u6761\u6570---------->" + pageData.getRecords().size());
        JSONObject page = new JSONObject();
        List records = BeanMapper.mapList((Iterable)pageData.getRecords(), JSONObject.class);
        ArrayList<Long> detailIds = new ArrayList<Long>();
        HashMap detailHasParentMap = new HashMap();
        records.stream().forEach(item -> {
            detailIds.add(item.getLong("id"));
            if (null != item.get((Object)"parentId")) {
                if (null == detailHasParentMap.get(item.getLong("parentId"))) {
                    detailHasParentMap.put(item.getLong("parentId"), new ArrayList());
                }
                ((List)detailHasParentMap.get(item.getLong("parentId"))).add(item);
            }
        });
        if (!detailHasParentMap.isEmpty()) {
            List parents = (List)this.detailService.listByIds(new ArrayList(detailHasParentMap.keySet()));
            for (ContractDetailEntity parent : parents) {
                ((List)detailHasParentMap.get(parent.getId())).forEach(child -> child.put("pTag", (Object)(parent.getDetailCode() + "-" + parent.getDetailName())));
            }
        }
        if ("true".equals(calcLastTotalNum) && !detailIds.isEmpty()) {
            Map<Long, BigDecimal> calcResult = this.measureDetailService.queryLastWorkNumByIds(detailIds);
            records.stream().forEach(r -> r.put("lastTotalNum", calcResult.get(r.getLong("id"))));
        }
        page.put("records", (Object)records);
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u660e\u7ec6\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @ResponseBody
    @RequestMapping(value={"/getContractDetailRef"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> getContractDetailRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("equipmentSpec");
        fuzzyFields.add("equipmentUnitName");
        if (null == condition || StringUtils.isBlank((String)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("contractId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
        }
        queryParam.getParams().put("contract_id", new Parameter("eq", conditionMap.get("contractId")));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("equipment_code", new Parameter("sql", (Object)"equipment_id is not null"));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time", "desc");
        queryParam.setOrderMap(orderMap);
        this.logger.info("\u5206\u5305\u5408\u540c\u660e\u7ec6\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u6761\u4ef6---------->" + JSONObject.toJSONString((Object)queryParam.getParams()));
        IPage pageData = this.detailService.queryPage(queryParam, false);
        this.logger.info("\u5206\u5305\u5408\u540c\u660e\u7ec6\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u7ed3\u679c\u6761\u6570---------->" + pageData.getRecords().size());
        JSONObject page = new JSONObject();
        List records = BeanMapper.mapList((Iterable)pageData.getRecords(), JSONObject.class);
        page.put("records", (Object)records);
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u660e\u7ec6\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @ResponseBody
    @RequestMapping(value={"/contractDetailRef"}, method={RequestMethod.GET})
    public CommonResponse<List<ContractDetailVO>> contractDetailRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        List contractDetailList;
        List resList = new ArrayList();
        if (null == condition || StringUtils.isBlank((String)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("contractId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById((Serializable)conditionMap.get("contractId")));
        if (null != contractEntity && CollectionUtils.isNotEmpty(contractEntity.getDetailList()) && CollectionUtils.isNotEmpty((Collection)(contractDetailList = BeanMapper.mapList(contractEntity.getDetailList(), ContractDetailVO.class)))) {
            for (ContractDetailVO detail : contractDetailList) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            resList = TreeNodeBUtil.buildTree((List)contractDetailList);
        }
        this.logger.info("\u8fd4\u56de\u5408\u540c\u660e\u7ec6\u6570\u636e\u6210\u529f\uff1a", (Object)JSONObject.toJSONString(resList));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", resList);
    }

    @ResponseBody
    @RequestMapping(value={"/queryPayment"}, method={RequestMethod.GET})
    public CommonResponse<List<ContractPaymentVO>> queryPayment(@RequestParam(value="contractId") String contractId) {
        List contractPayments = new ArrayList();
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById((Serializable)((Object)contractId)));
        if (null != contractEntity && CollectionUtils.isNotEmpty(contractEntity.getDetailList())) {
            contractPayments = BeanMapper.mapList(contractEntity.getPaymentList(), ContractPaymentVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", contractPayments);
    }

    @ResponseBody
    @RequestMapping(value={"/contractPaymentRef"}, method={RequestMethod.GET})
    public CommonResponse<List<ContractPaymentVO>> contractPaymentRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        List contractPayments = new ArrayList();
        if (null == condition || StringUtils.isBlank((String)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("contractId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById((Serializable)conditionMap.get("contractId")));
        if (null != contractEntity && CollectionUtils.isNotEmpty(contractEntity.getDetailList())) {
            contractPayments = BeanMapper.mapList(contractEntity.getPaymentList(), ContractPaymentVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", contractPayments);
    }

    @RequestMapping(value={"/querySupplementRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> querySupplementRecord(Long id) {
        ContractVO vo = this.service.querySupplementRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateSupplement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateSupplement(@RequestBody ContractVO supplement) {
        if (supplement.getMainContractId() == null) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e3b\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdateSupplement(supplement, false));
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> addConvertByConId(Long contractId) {
        ContractVO vo = this.service.addConvertByConId(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addSupplementFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = this.service.addSupplementFlag(id);
        if (flag.booleanValue()) {
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff0c\u8be5\u5408\u540c\u53ef\u4ee5\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u80fd\u65b0\u589e\uff01");
    }

    @RequestMapping(value={"/addRelieveFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> addRelieveFlag(Long id) {
        Boolean flag = this.contractRelieveService.isCanRelieve(id);
        return CommonResponse.success((String)"\u6821\u9a8c\u8be5\u5408\u540c\u65b0\u589e\u5408\u540c\u89e3\u9664\u5355\u636e\u6210\u529f\uff01", (Object)flag);
    }

    @RequestMapping(value={"/signatureProcess"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.service.selectById(id));
        if (contractEntity != null) {
            contractEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
            contractEntity.setFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
            contractEntity.setEffectiveDate(new Date());
            this.service.saveOrUpdate((Object)contractEntity);
        }
        return CommonResponse.success();
    }

    @ResponseBody
    @RequestMapping(value={"/prosubContractOtherCostRef"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> prosubContractOtherCostRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        if (null == condition || StringUtils.isBlank((String)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("contractId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540cid\u4e3a\u7a7a\uff01");
        }
        queryParam.getParams().put("contract_id", new Parameter("eq", conditionMap.get("contractId")));
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time", "desc");
        queryParam.setOrderMap(orderMap);
        this.logger.info("\u5206\u5305\u5408\u540c\u5176\u4ed6\u8d39\u7528\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u6761\u4ef6---------->" + JSONObject.toJSONString((Object)queryParam.getParams()));
        IPage pageData = this.otherCostService.queryPage(queryParam, false);
        this.logger.info("\u5206\u5305\u5408\u540c\u5176\u4ed6\u8d39\u7528\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u7ed3\u679c\u6761\u6570---------->" + pageData.getRecords().size());
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractOtherCostVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u5176\u4ed6\u8d39\u7528\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @PostMapping(value={"/testPushContract"})
    @ResponseBody
    public CommonResponse<ContractPoolVO> testPushContract(@RequestBody ContractVO contractVO) {
        ContractEntity contract = (ContractEntity)((Object)this.service.selectById(contractVO.getId()));
        boolean pushContractResult = this.service.pushContract((ContractVO)BeanMapper.map((Object)((Object)contract), ContractVO.class));
        if (pushContractResult) {
            return CommonResponse.success((String)"\u5408\u540c\u6570\u636e\u63a8\u9001\u5408\u540c\u6c60\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)"\u5408\u540c\u6570\u636e\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01");
    }

    @PostMapping(value={"/deleteContractFile"})
    @ResponseBody
    public CommonResponse<Integer> deleteContractFile(@RequestBody ContractVO contractVO) {
        Integer contractVersion = this.service.deleteContractFileById(contractVO.getId());
        if (null != contractVersion && contractVersion.equals(-1)) {
            return CommonResponse.error((String)"\u5408\u540c\u5220\u9664\u5408\u540c\u9644\u4ef6\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u5408\u540c\u5220\u9664\u5408\u540c\u9644\u4ef6\u6210\u529f\uff01", (Object)contractVersion);
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ContractVO contractVO, HttpServletRequest req) {
        ContractVO cv;
        if (null != contractVO.getSupplementFlag() && 1 == contractVO.getSupplementFlag()) {
            cv = this.service.saveOrUpdateSupplement(contractVO, true);
        } else {
            String authority = req.getHeader("authority");
            cv = this.service.insertOrUpdate(contractVO, authority, true);
        }
        ExecutionVO executionVO = this.service.targetCost(cv, this.service.getLinkUrl(cv), cv.getContractType(), this.getContractBillType(cv.getId(), cv.getContractType()));
        this.logger.error("\u5206\u5305\u5408\u540c\uff0c\u7b56\u5212\u6210\u672c\u6570\u636e\u6821\u9a8c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)executionVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        this.logger.info("\u5206\u5305\u5408\u540c\uff0c\u7b56\u5212\u6210\u672c\u6570\u636e\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            this.logger.error("\u7b56\u5212\u6210\u672c\u53c2\u6570\u63a7\u5236\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f-{}", (Object)response.getMsg());
            return response;
        }
        ParamsCheckVO responseData = this.paramCheck(contractVO, (CommonResponse<ParamsCheckVO>)response, false);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.service.selectById(id));
        ContractVO cv = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
        String linkUrl = null != cv.getSupplementFlag() && 1 == cv.getSupplementFlag() ? this.service.getSupplementLinkUrl(cv) : this.service.getLinkUrl(cv);
        ExecutionVO executionVO = this.service.targetCost(cv, linkUrl, cv.getContractType(), this.getContractBillType(cv.getId(), cv.getContractType()));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        this.logger.info("\u5206\u5305\u5408\u540c\uff0c\u7b56\u5212\u6210\u672c\u6570\u636e\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            this.logger.error("\u7b56\u5212\u6210\u672c\u53c2\u6570\u63a7\u5236\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f-{}", (Object)response.getMsg());
            return response;
        }
        ParamsCheckVO responseData = this.paramCheck(cv, (CommonResponse<ParamsCheckVO>)response, true);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    private String getContractBillType(Long contractId, Integer contractType) {
        switch (contractType) {
            case 0: {
                return ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode();
            }
            case 1: {
                return ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode();
            }
            case 2: {
                return ProsubBillTypeEnum.\u7279\u79cd\u8bbe\u5907\u79df\u8d41\u5408\u540c.getBillTypeCode();
            }
            case 3: {
                return ProsubBillTypeEnum.\u5176\u4ed6\u5206\u5305\u5408\u540c.getBillTypeCode();
            }
        }
        this.logger.error("\u5408\u540cid-{}\u9519\u8bef\u7684\u5408\u540c\u7c7b\u578b:{}", (Object)contractId, (Object)contractType);
        throw new BusinessException("\u9519\u8bef\u7684\u5408\u540c\u7c7b\u578b");
    }

    @RequestMapping(value={"/queryLabProSettleDetails"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractSettleDetailsReportVO>> queryLabProSettleDetails(@RequestBody QueryParam queryParam) {
        IPage<ContractSettleDetailsReportVO> details = this.service.queryLabProSettleDetails(queryParam, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", details);
    }

    @RequestMapping(value={"/exportLabProSettleDetails"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportLabProSettleDetails(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        IPage<ContractSettleDetailsReportVO> details = this.service.queryLabProSettleDetails(queryParam, true);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", details.getRecords());
        ExcelExport.getInstance().export("labProSettleDetails-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryLabProSettleDetailsList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractSettleDetailsReportVO>> queryLabProSettleDetailsList(Integer pageNumber, Integer pageSize, @RequestParam(required=false) String detailWorkContent, @RequestParam(required=false) String detailRule, @RequestParam String contractDetailId, @RequestParam String contractType, @RequestParam String settleType) {
        QueryParam queryParam = new QueryParam();
        if (pageNumber == null || pageNumber < 1) {
            pageNumber = 0;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        queryParam.setPageIndex(pageNumber - 1);
        queryParam.setPageSize(pageSize.intValue());
        IPage<ContractSettleDetailsReportVO> pageData = this.service.queryLabProSettleDetailsList(pageNumber - 1, pageSize, Long.parseLong(contractDetailId), Integer.parseInt(settleType), Integer.parseInt(contractType), detailWorkContent, detailRule);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", pageData);
    }

    private String getBillTypeCodeString(Integer contractType) {
        String billTypeCode = null;
        if (contractType == 0) {
            billTypeCode = ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode();
        }
        if (contractType == 1) {
            billTypeCode = ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode();
        }
        if (contractType == 2) {
            billTypeCode = ProsubBillTypeEnum.\u7279\u79cd\u8bbe\u5907\u79df\u8d41\u5408\u540c.getBillTypeCode();
        }
        if (contractType == 3) {
            billTypeCode = ProsubBillTypeEnum.\u5176\u4ed6\u5206\u5305\u5408\u540c.getBillTypeCode();
        }
        return billTypeCode;
    }

    private String getContractTypeString(Integer contractType) {
        String billTypeCode = null;
        if (contractType == 0) {
            billTypeCode = ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode();
        }
        if (contractType == 1) {
            billTypeCode = ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode();
        }
        if (contractType == 2) {
            billTypeCode = ContractTypeEnum.\u7279\u79cd\u8bbe\u5907\u79df\u8d41\u5408\u540c.getTypeCode();
        }
        if (contractType == 3) {
            billTypeCode = ContractTypeEnum.\u5176\u4ed6\u5206\u5305\u5408\u540c.getTypeCode();
        }
        return billTypeCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/pushContractToPool"})
    @ResponseBody
    public CommonResponse<ContractVO> pushContractToPool(@RequestBody Long contractId) {
        CommonResponse transDataResp;
        ContractVO vo;
        JedisTemplate jedisTemplate;
        block21: {
            String mobileRoutePath;
            String routePath;
            String cardType;
            ContractPoolVO data;
            ContractEntity dbEntity;
            block24: {
                block23: {
                    jedisTemplate = this.cacheManager.getJedisTemplate();
                    String contractIdStr = jedisTemplate.get("pushContract::" + contractId.toString());
                    if (StringUtils.isNotBlank((String)contractIdStr)) {
                        return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u6570\u636e\u5df2\u5904\u4e8e\u540c\u6b65\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
                    }
                    jedisTemplate.set("pushContract::" + contractId.toString(), contractId.toString());
                    dbEntity = (ContractEntity)((Object)this.service.selectById(contractId));
                    if (null == dbEntity) {
                        jedisTemplate.del(new String[]{"pushContract::" + contractId.toString()});
                        return CommonResponse.error((String)("\u5408\u540c\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c\u672a\u627e\u5230Id-" + contractId + "\u5339\u914d\u7684\u5408\u540c"));
                    }
                    vo = (ContractVO)BeanMapper.map((Object)((Object)dbEntity), ContractVO.class);
                    data = new ContractPoolVO();
                    BeanConvertorUtil.convert((Object)vo, (Object)data);
                    data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
                    String billTypeCode = this.getContractTypeString(vo.getContractType());
                    data.setSourceType(billTypeCode);
                    cardType = "";
                    routePath = "";
                    mobileRoutePath = "";
                    if (vo.getAddType() != 1) break block23;
                    switch (vo.getContractType()) {
                        case 0: {
                            cardType = "laborSubDirectCard";
                            routePath = "laborSubList";
                            mobileRoutePath = "labContract";
                            break block24;
                        }
                        case 1: {
                            cardType = "proSubDirectCard";
                            routePath = "proSubList";
                            mobileRoutePath = "proContract";
                            break block24;
                        }
                        case 2: {
                            cardType = "otherSubDirectCard";
                            routePath = "otherSubList";
                            mobileRoutePath = "otherContract";
                            break block24;
                        }
                        case 3: {
                            cardType = "equipmentSubDirectCard";
                            routePath = "equipmentSubList";
                            mobileRoutePath = "equipmentContract";
                            break block24;
                        }
                        default: {
                            this.logger.error("\u5408\u540cid-{}\u9519\u8bef\u7684\u5408\u540c\u7c7b\u578b\uff1a{}", (Object)vo.getId(), (Object)vo.getContractType());
                            throw new BusinessException("\u9519\u8bef\u7684\u5408\u540c\u7c7b\u578b");
                        }
                    }
                }
                if (vo.getAddType() == 0) {
                    switch (vo.getContractType()) {
                        case 0: {
                            cardType = "proSubCard";
                            routePath = "proSubList";
                            mobileRoutePath = "labContract";
                            break;
                        }
                        case 1: {
                            cardType = "laborSubCard";
                            routePath = "laborSubList";
                            mobileRoutePath = "proContract";
                            break;
                        }
                        case 2: {
                            cardType = "otherSubDirectCard";
                            routePath = "otherSubList";
                            mobileRoutePath = "otherContract";
                            break;
                        }
                        case 3: {
                            cardType = "equipmentSubDirectCard";
                            routePath = "equipmentSubList";
                            mobileRoutePath = "equipmentContract";
                            break;
                        }
                        default: {
                            this.logger.error("\u5408\u540cid-{}\u9519\u8bef\u7684\u5408\u540c\u7c7b\u578b\uff1a{}", (Object)vo.getId(), (Object)vo.getContractType());
                            throw new BusinessException("\u9519\u8bef\u7684\u5408\u540c\u7c7b\u578b");
                        }
                    }
                }
            }
            data.setMobileCardUrl("ejc-prosub-mobile/#/" + mobileRoutePath + "/card?id=" + vo.getId());
            data.setPcCardUrl("/ejc-prosub-frontend/#/" + routePath + "/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus());
            data.setAddType(Integer.valueOf(0));
            this.logger.info("\u63a8\u9001\u5408\u540c\u6c60 \u8f6c\u6362 \u5bf9\u8c61\uff1a\u2014\u2014\u2014\u2014\u2014\u2014{}", (Object)JSONObject.toJSONString((Object)data));
            transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (!transDataResp.isSuccess()) break block21;
            if (BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(dbEntity.getBillPushFlag())) {
                dbEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                this.service.saveOrUpdate((Object)dbEntity);
            }
            CommonResponse commonResponse = CommonResponse.success((String)"\u5408\u540c\u63a8\u9001\u6210\u529f", (Object)vo);
            jedisTemplate.del(new String[]{"pushContract::" + contractId.toString()});
            return commonResponse;
        }
        try {
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)JSONObject.toJSONString((Object)transDataResp));
        }
        catch (Exception e) {
            try {
                this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
            }
            catch (Throwable throwable) {
                jedisTemplate.del(new String[]{"pushContract::" + contractId.toString()});
                throw throwable;
            }
            jedisTemplate.del(new String[]{"pushContract::" + contractId.toString()});
        }
        jedisTemplate.del(new String[]{"pushContract::" + contractId.toString()});
        return CommonResponse.error((String)"\u5408\u540c\u63a8\u9001\u5931\u8d25", (Object)vo);
    }

    private ParamsCheckVO paramCheck(ContractVO contractVO, CommonResponse<ParamsCheckVO> response, boolean flag) {
        CommonResponse ctrlOutConMnyRes;
        Integer contractType = contractVO.getContractType();
        ParamsCheckVO responseData = (ParamsCheckVO)response.getData();
        ParamsCheckVO resp = new ParamsCheckVO();
        ArrayList<ParamsCheckVO> allCheck = new ArrayList<ParamsCheckVO>();
        if (null != contractVO.getSupplementFlag() && 1 == contractVO.getSupplementFlag()) {
            this.logger.info("\u3010\u5408\u540c\u91d1\u989d\u3011\u63a7\u3010\u8865\u5145\u534f\u8bae\u91d1\u989d\u3011 start");
            allCheck.addAll(this.service.supplementMnyCtrl(contractVO));
            this.logger.info("\u3010\u5408\u540c\u91d1\u989d\u3011\u63a7\u3010\u8865\u5145\u534f\u8bae\u91d1\u989d\u3011 end");
        }
        this.logger.info("\u3010\u603b\u8ba1\u5212\u91cf\u3011\u63a7\u3010\u5408\u540c\u91cf\u3011 start");
        allCheck.addAll(this.service.planNumCtrlContractNum(contractVO));
        this.logger.info("\u3010\u603b\u8ba1\u5212\u91cf\u3011\u63a7\u3010\u5408\u540c\u91cf\u3011 end");
        this.logger.info("\u3010\u3010\u603b\u8ba1\u5212\u91d1\u989d\u3011\u63a7\u3010\u5408\u540c\u91d1\u989d\u3011 start");
        allCheck.addAll(this.service.planMnyCtrlContractMny(contractVO));
        this.logger.info("\u3010\u3010\u603b\u8ba1\u5212\u91d1\u989d\u3011\u63a7\u3010\u5408\u540c\u91d1\u989d\u3011 end");
        this.logger.info("\u5386\u53f2\u4ef7\u63a7 \u5408\u540c\u4ef7 start");
        allCheck.addAll(this.service.historyPriceCtrlContractPrice(contractVO));
        this.logger.info("\u5386\u53f2\u4ef7\u63a7 \u5408\u540c\u4ef7 end");
        this.logger.info("\u76ee\u6807\u6210\u672c\u4ef7\u63a7 \u5408\u540c\u4ef7 start");
        allCheck.addAll(this.service.targetCostPriceCtrlContractPrice(contractVO));
        this.logger.info("\u76ee\u6807\u6210\u672c\u4ef7\u63a7 \u5408\u540c\u4ef7 end");
        this.logger.info("allCheck:{}", (Object)JSONObject.toJSONString(allCheck));
        if (contractType != null && contractType == 0) {
            this.logger.info("\u3010\u65bd\u5de5\u5408\u540c\u91d1\u989d - \u4e13\u4e1a\u5408\u540c\u91d1\u989d\u3011\u63a7\u3010\u52b3\u52a1\u5206\u5305\u5408\u540c\u91d1\u989d\u3011 start");
            allCheck.addAll(this.service.contractionMnyCtrlLabConMny(contractVO));
            this.logger.info("\u3010\u65bd\u5de5\u5408\u540c\u91d1\u989d - \u4e13\u4e1a\u5408\u540c\u91d1\u989d\u3011\u63a7\u3010\u52b3\u52a1\u5206\u5305\u5408\u540c\u91d1\u989d\u3011 end");
        }
        if ((ctrlOutConMnyRes = this.paramCheckApi.paramsCheck(contractVO.getProjectId(), contractVO.getId(), contractVO.getContractTaxMny(), contractVO.getOrgId())).isSuccess() && ctrlOutConMnyRes.getData() != null) {
            allCheck.addAll((Collection)ctrlOutConMnyRes.getData());
        }
        Map<String, List<ParamsCheckVO>> checkListMap = allCheck.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            resp.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            resp.setWarnType("warn");
        } else {
            resp.setWarnType("none");
        }
        if (null == responseData.getWarnType() || ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) < ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
            for (ParamsCheckVO paramsCheckVO : result) {
                resp.getDataSource().addAll(paramsCheckVO.getDataSource());
            }
        } else if (ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) == ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
            if (CollectionUtils.isNotEmpty((Collection)responseData.getDataSource())) {
                resp.getDataSource().addAll(responseData.getDataSource());
            }
            for (ParamsCheckVO paramsCheckVO : result) {
                resp.getDataSource().addAll(paramsCheckVO.getDataSource());
            }
        } else {
            return responseData;
        }
        return resp;
    }

    @RequestMapping(value={"/queryPaymentApplyList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractPaymentResultVO> query(Long id) {
        ContractPaymentResultVO vo = this.service.queryPaymentApplyList(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/handlePrintDetail"})
    @ResponseBody
    public CommonResponse<JSONObject> handlePrintDetail(@RequestBody String detailJsonStr) {
        String contractKey = null;
        String detailKey = null;
        String numKey = null;
        if (StringUtils.isBlank((String)detailJsonStr)) {
            return CommonResponse.success(null);
        }
        JSONObject data = JSONObject.parseObject((String)detailJsonStr);
        if (null == data) {
            return CommonResponse.success(null);
        }
        JSONObject detailJson = data.getJSONObject("detailJson");
        switch (data.getString("billType")) {
            case "BT211108000000002": 
            case "BT220216000000003": {
                contractKey = "Contract";
                detailKey = "ContractDetail";
                numKey = "detailNum";
                break;
            }
            case "BT220216000000004": 
            case "BT211108000000003": {
                contractKey = "Change";
                detailKey = "ChangeDetail";
                numKey = "detailNum";
                break;
            }
            case "BT220114000000002": 
            case "BT220307000000007": {
                contractKey = "ProcessSettle";
                detailKey = "ProcessSettleDetail";
                numKey = "settleNum";
                break;
            }
            case "BT220114000000003": 
            case "BT220307000000008": {
                contractKey = "NodeSettle";
                detailKey = "NodeSettleDetail";
                numKey = "settleNum";
                break;
            }
            case "BT220114000000004": 
            case "BT220307000000009": {
                contractKey = "FinishSettle";
                detailKey = "FinishSettleDetail";
                numKey = "settleNum";
                break;
            }
            default: {
                return CommonResponse.error((String)"\u9519\u8bef\u7684\u5355\u636e\u7c7b\u578b");
            }
        }
        if (null == detailJson) {
            return CommonResponse.success(null);
        }
        JSONObject contract = detailJson.getJSONObject(contractKey);
        JSONArray detail = contract.getJSONArray(detailKey);
        String finalNumKey = numKey;
        if (null != detail && detail.size() > 0) {
            contract.put(detailKey, detail.stream().filter(item -> StringUtils.isNotBlank((String)JSONObject.parseObject((String)JSONObject.toJSONString((Object)item)).getString(finalNumKey))).collect(Collectors.toList()));
            detailJson.put(contractKey, (Object)contract);
        }
        return CommonResponse.success((Object)detailJson);
    }

    @GetMapping(value={"/pushTargetCost"})
    @ResponseBody
    public CommonResponse<String> pushTargetCost(@RequestParam(value="id") Long id) {
        this.service.pushTargetCost(id);
        return CommonResponse.success((String)"\u624b\u52a8\uff1a\u5206\u5305\u5408\u540c\u7b56\u5212\u6210\u672c\u63a8\u9001\u6570\u636e\u6210\u529f\uff01");
    }

    @ResponseBody
    @RequestMapping(value={"/proContractRef"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> proContractRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        if (null == condition || StringUtils.isBlank((String)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("orgId") && null == conditionMap.get("projectId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u9879\u76eeid \u6216 \u7ec4\u7ec7id\u4e3a\u7a7a\uff01");
        }
        if (null != conditionMap.get("orgId") && null == conditionMap.get("orgType")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        if (null == conditionMap.get("contractType")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5408\u540c\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        queryParam.getParams().put("contractType", new Parameter("eq", conditionMap.get("contractType")));
        if (null != conditionMap.get("supplementFlag")) {
            queryParam.getParams().put("supplementFlag", new Parameter("eq", conditionMap.get("supplementFlag")));
        }
        if (null != conditionMap.get("changeStatus")) {
            queryParam.getParams().put("changeStatus", new Parameter("eq", conditionMap.get("changeStatus")));
        }
        if (null != conditionMap.get("projectId")) {
            Long projectId = Long.parseLong(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        } else {
            Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                queryParam.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        queryParam.getParams().put("filing_status", new Parameter("eq", (Object)0));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != queryParam.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", queryParam.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        queryParam.setOrderMap(orderMap);
        this.logger.info("\u5206\u5305\u5408\u540c\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u6761\u4ef6---------->" + JSONObject.toJSONString((Object)queryParam.getParams()));
        orderMap.put("create_time", "desc");
        queryParam.setOrderMap(orderMap);
        IPage pageData = this.service.queryPage(queryParam, false);
        this.logger.info("\u5206\u5305\u5408\u540c\u67e5\u8be2\u53c2\u7167-\u67e5\u8be2\u7ed3\u679c\u6761\u6570---------->" + pageData.getRecords().size());
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"contract-import.xlsx", (String)"\u5206\u5305\u660e\u7ec6\u8868");
    }

    @RequestMapping(value={"/downloadOther"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadOther(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"contractOther-import.xlsx", (String)"\u5176\u4ed6\u5206\u5305\u660e\u7ec6\u8868");
    }

    @RequestMapping(value={"/downloadEquipment"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadEquipment(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"contractEquipment-import.xlsx", (String)"\u7279\u79cd\u8bbe\u5907\u660e\u7ec6\u8868");
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importData(Integer type, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ContractDetailVO> successList = new ArrayList<ContractDetailVO>();
        ArrayList<ContractDetailVO> errorList = new ArrayList<ContractDetailVO>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        HashMap<String, List> codeMap = new HashMap<String, List>();
        HashMap<String, List> codeMap1 = new HashMap<String, List>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        DecimalFormat decimalFormat = new DecimalFormat("0.00000000");
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                BigDecimal taxRate1;
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String detailCode = (String)datas.get(0);
                this.logger.info("detailCode--" + detailCode);
                this.logger.info("int----" + i);
                String detailName = (String)datas.get(1);
                String detailNum = (String)datas.get(2);
                String detailTaxRate = (String)datas.get(3);
                String detailTaxPrice = (String)datas.get(4);
                String detailTaxMny = (String)datas.get(5);
                String memo = (String)datas.get(6);
                ContractDetailVO detailVO = new ContractDetailVO();
                detailVO.setDetailName(detailName);
                detailVO.setDetailCode(detailCode);
                detailVO.setTreeIndex(String.valueOf(i));
                if (StringUtils.isBlank((String)detailCode)) {
                    detailVO.setErrorMessage("\u6e05\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    List data;
                    CommonResponse listCommonResponse = null;
                    CommonResponse listCommonResponse1 = null;
                    if (type == 0) {
                        listCommonResponse = this.labsubApi.queryItemListByCodes(Arrays.asList(detailCode));
                        if (listCommonResponse.isSuccess()) {
                            data = (List)listCommonResponse.getData();
                            if (data == null) {
                                detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                                detailVO.setIsMatch("\u672a\u5339\u914d");
                            } else {
                                codeMap.put(detailCode, data);
                                for (LabsubItemVO labsubItemVO : data) {
                                    if (labsubItemVO.getTrawlingCode().equals(detailCode) && labsubItemVO.getTrawlingName().equals(detailName)) {
                                        detailVO.setDetailWorkContent(labsubItemVO.getJobContent());
                                        detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                        detailVO.setDetailUnit(labsubItemVO.getUnitName());
                                        detailVO.setDetailCode(detailCode);
                                        detailVO.setDetailName(detailName);
                                        detailVO.setDocCategoryId(labsubItemVO.getCategoryId());
                                        detailVO.setDocId(labsubItemVO.getId());
                                        detailVO.setIsMatch("\u5df2\u5339\u914d");
                                        continue;
                                    }
                                    detailVO.setIsMatch("\u672a\u5339\u914d");
                                    detailVO.setErrorMessage("\u6e05\u5355\u7f16\u7801\u4e0e\u6863\u6848\u7f16\u7801\u672a\u5339\u914d");
                                    errorsMsgBuilder.append("\u672a\u5339\u914d");
                                }
                            }
                        } else {
                            detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                            errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                        }
                    } else if (type == 1) {
                        listCommonResponse1 = this.prosubApi.queryItemListByCodes(Arrays.asList(detailCode));
                        if (listCommonResponse1.isSuccess()) {
                            data = (List)listCommonResponse1.getData();
                            if (data == null) {
                                detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                                detailVO.setIsMatch("\u672a\u5339\u914d");
                            } else {
                                codeMap1.put(detailCode, data);
                                for (LabsubItemVO labsubItemVO : data) {
                                    if (labsubItemVO.getTrawlingCode().equals(detailCode) && labsubItemVO.getTrawlingName().equals(detailName)) {
                                        detailVO.setDetailWorkContent(labsubItemVO.getJobContent());
                                        detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                        detailVO.setDetailUnit(labsubItemVO.getUnitName());
                                        detailVO.setDetailCode(detailCode);
                                        detailVO.setDetailName(detailName);
                                        detailVO.setDocCategoryId(labsubItemVO.getCategoryId());
                                        detailVO.setDocId(labsubItemVO.getId());
                                        detailVO.setIsMatch("\u5df2\u5339\u914d");
                                        continue;
                                    }
                                    detailVO.setIsMatch("\u672a\u5339\u914d");
                                    errorsMsgBuilder.append("\u672a\u5339\u914d");
                                }
                            }
                        } else {
                            detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                            errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                        }
                    } else if (type == 3) {
                        detailVO.setDetailCode(detailCode);
                    }
                }
                if (type == 3) {
                    if (StringUtils.isBlank((String)detailName)) {
                        detailVO.setErrorMessage("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                        errorsMsgBuilder.append("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    } else {
                        detailVO.setDetailName(detailName);
                    }
                }
                if (StringUtils.isBlank((String)detailNum)) {
                    detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        taxRate1 = new BigDecimal(detailNum);
                        detailVO.setDetailNum(taxRate1);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                if (StringUtils.isBlank((String)detailTaxRate)) {
                    detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        taxRate1 = new BigDecimal(detailTaxRate);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            detailVO.setDetailTaxRate(taxRate1);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                BigDecimal tax = ComputeUtil.safeDiv((BigDecimal)new BigDecimal(detailTaxRate), (BigDecimal)new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                BigDecimal num = new BigDecimal(detailNum);
                if (StringUtils.isNotBlank((String)detailTaxPrice)) {
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setDetailTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailPrice(price);
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)num, (BigDecimal)price);
                    detailVO.setDetailMny(mny);
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailTaxMny(taxMny);
                    BigDecimal tax1 = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)tax);
                    detailVO.setDetailTax(tax1);
                }
                if (StringUtils.isNotBlank((String)detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setDetailTaxMny(taxMny);
                    BigDecimal mny = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailMny(mny);
                    BigDecimal taxPrice = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)num);
                    detailVO.setDetailTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailPrice(price);
                    BigDecimal detailTax = ComputeUtil.safeMultiply((BigDecimal)tax, (BigDecimal)mny);
                    detailVO.setDetailTax(detailTax);
                }
                if (StringUtils.isNotBlank((String)memo)) {
                    detailVO.setDetailMemo(memo);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/importOtherData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importOtherData(Integer type, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ContractDetailVO> successList = new ArrayList<ContractDetailVO>();
        ArrayList<ContractDetailVO> errorList = new ArrayList<ContractDetailVO>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        HashMap codeMap = new HashMap();
        HashMap codeMap1 = new HashMap();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        DecimalFormat decimalFormat = new DecimalFormat("0.00000000");
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                BigDecimal taxRate1;
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String detailName = (String)datas.get(0);
                String detailWorkContent = (String)datas.get(1);
                String detailMeasurementRules = (String)datas.get(2);
                String detailUnit = (String)datas.get(3);
                String detailNum = (String)datas.get(4);
                String detailTaxRate = (String)datas.get(5);
                String detailTaxPrice = (String)datas.get(6);
                String detailTaxMny = (String)datas.get(7);
                String memo = (String)datas.get(8);
                ContractDetailVO detailVO = new ContractDetailVO();
                detailVO.setDetailName(detailName);
                detailVO.setTreeIndex(String.valueOf(i));
                if (StringUtils.isBlank((String)detailName)) {
                    detailVO.setErrorMessage("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setDetailName(detailName);
                }
                if (StringUtils.isBlank((String)detailWorkContent)) {
                    detailVO.setErrorMessage("\u5de5\u4f5c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5de5\u4f5c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setDetailWorkContent(detailWorkContent);
                }
                if (StringUtils.isBlank((String)detailMeasurementRules)) {
                    detailVO.setErrorMessage("\u8ba1\u91cf\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u8ba1\u91cf\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setDetailMeasurementRules(detailMeasurementRules);
                }
                if (StringUtils.isBlank((String)detailUnit)) {
                    detailVO.setErrorMessage("\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setDetailUnit(detailUnit);
                }
                if (StringUtils.isBlank((String)detailNum)) {
                    detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        taxRate1 = new BigDecimal(detailNum);
                        detailVO.setDetailNum(taxRate1);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                if (StringUtils.isBlank((String)detailTaxRate)) {
                    detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        taxRate1 = new BigDecimal(detailTaxRate);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            detailVO.setDetailTaxRate(taxRate1);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                BigDecimal tax = ComputeUtil.safeDiv((BigDecimal)new BigDecimal(detailTaxRate), (BigDecimal)new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                BigDecimal num = new BigDecimal(detailNum);
                if (StringUtils.isNotBlank((String)detailTaxPrice)) {
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setDetailTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailPrice(price);
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)num, (BigDecimal)price);
                    detailVO.setDetailMny(mny);
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailTaxMny(taxMny);
                    BigDecimal tax1 = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)tax);
                    detailVO.setDetailTax(tax1);
                }
                if (StringUtils.isNotBlank((String)detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setDetailTaxMny(taxMny);
                    BigDecimal mny = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailMny(mny);
                    BigDecimal taxPrice = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)num);
                    detailVO.setDetailTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailPrice(price);
                    BigDecimal detailTax = ComputeUtil.safeMultiply((BigDecimal)tax, (BigDecimal)mny);
                    detailVO.setDetailTax(detailTax);
                }
                if (StringUtils.isNotBlank((String)memo)) {
                    detailVO.setDetailMemo(memo);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/importEquipmentData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importEquipmentData(Integer type, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ContractDetailVO> successList = new ArrayList<ContractDetailVO>();
        ArrayList<ContractDetailVO> errorList = new ArrayList<ContractDetailVO>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        HashMap<String, List> codeMap = new HashMap<String, List>();
        HashMap codeMap1 = new HashMap();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                BigDecimal taxRate1;
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String detailCode = (String)datas.get(0);
                String detailName = (String)datas.get(1);
                String detailNewNum = (String)datas.get(2);
                String useTime = (String)datas.get(3);
                String detailTaxRate = (String)datas.get(4);
                String detailTaxPrice = (String)datas.get(5);
                String detailTaxMny = (String)datas.get(6);
                String memo = (String)datas.get(7);
                ContractDetailVO detailVO = new ContractDetailVO();
                detailVO.setDetailName(detailName);
                detailVO.setDetailCode(detailCode);
                detailVO.setTreeIndex(String.valueOf(i));
                if (StringUtils.isBlank((String)detailCode)) {
                    detailVO.setErrorMessage("\u6e05\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    CommonResponse listCommonResponse = null;
                    Object listCommonResponse1 = null;
                    if (MapUtils.isEmpty(codeMap) || codeMap.get(detailCode) == null) {
                        listCommonResponse = this.labsubApi.queryItemListByCodes(Arrays.asList(detailCode));
                        if (listCommonResponse.isSuccess()) {
                            List data = (List)listCommonResponse.getData();
                            if (data == null) {
                                detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                                detailVO.setIsMatch("\u672a\u5339\u914d");
                            } else {
                                codeMap.put(detailCode, data);
                                for (LabsubItemVO labsubItemVO : data) {
                                    if (labsubItemVO.getTrawlingCode().equals(detailCode) && labsubItemVO.getTrawlingName().equals(detailName)) {
                                        detailVO.setDetailWorkContent(labsubItemVO.getJobContent());
                                        detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                        detailVO.setDetailUnit(labsubItemVO.getUnitName());
                                        detailVO.setDetailCode(detailCode);
                                        detailVO.setDetailName(detailName);
                                        detailVO.setEquipmentId(labsubItemVO.getEquipmentId());
                                        detailVO.setEquipmentName(labsubItemVO.getEquipmentName());
                                        detailVO.setEquipmentCode(labsubItemVO.getEquipmentCode());
                                        detailVO.setDocId(labsubItemVO.getId());
                                        detailVO.setDocCategoryId(labsubItemVO.getCategoryId());
                                        detailVO.setIsMatch("\u5df2\u5339\u914d");
                                        continue;
                                    }
                                    detailVO.setIsMatch("\u672a\u5339\u914d");
                                    detailVO.setErrorMessage("\u6e05\u5355\u7f16\u7801\u4e0e\u6863\u6848\u7f16\u7801\u672a\u5339\u914d");
                                    errorsMsgBuilder.append("\u672a\u5339\u914d");
                                }
                            }
                        } else {
                            detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                            errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                        }
                    } else {
                        detailVO.setErrorMessage("\u6e05\u5355\u7f16\u53f7\u91cd\u590d\uff01");
                        errorsMsgBuilder.append("\u6e05\u5355\u7f16\u53f7\u91cd\u590d\uff01");
                    }
                }
                if (StringUtils.isBlank((String)detailNewNum)) {
                    detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        taxRate1 = new BigDecimal(detailNewNum);
                        detailVO.setDetailNewNum(taxRate1);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                if (StringUtils.isBlank((String)useTime)) {
                    detailVO.setErrorMessage("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        BigDecimal useTimeData = new BigDecimal(useTime);
                        if (useTimeData.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            detailVO.setUseTime(useTimeData);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                detailVO.setDetailNum(ComputeUtil.safeMultiply((BigDecimal)detailVO.getUseTime(), (BigDecimal)detailVO.getDetailNewNum()));
                if (StringUtils.isBlank((String)detailTaxRate)) {
                    detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        taxRate1 = new BigDecimal(detailTaxRate);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            detailVO.setDetailTaxRate(taxRate1);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                BigDecimal tax = ComputeUtil.safeDiv((BigDecimal)new BigDecimal(detailTaxRate), (BigDecimal)new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                BigDecimal detailNewNumData = new BigDecimal(detailNewNum);
                BigDecimal num = ComputeUtil.safeMultiply((BigDecimal)detailNewNumData, (BigDecimal)detailVO.getUseTime());
                if (StringUtils.isNotBlank((String)detailTaxPrice)) {
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setDetailTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailPrice(price);
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)num, (BigDecimal)price);
                    detailVO.setDetailMny(mny);
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailTaxMny(taxMny);
                    BigDecimal tax1 = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)tax);
                    detailVO.setDetailTax(tax1);
                }
                if (StringUtils.isNotBlank((String)detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setDetailTaxMny(taxMny);
                    BigDecimal mny = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailMny(mny);
                    BigDecimal taxPrice = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)num);
                    detailVO.setDetailTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailPrice(price);
                    BigDecimal detailTax = ComputeUtil.safeMultiply((BigDecimal)tax, (BigDecimal)mny);
                    detailVO.setDetailTax(detailTax);
                }
                if (StringUtils.isNotBlank((String)memo)) {
                    detailVO.setDetailMemo(memo);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

