package com.ejianc.business.control.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.control.bean.ControlChangeEntity;
import com.ejianc.business.control.service.IControlChangeService;
import com.ejianc.business.control.service.IControlService;
import com.ejianc.business.control.vo.*;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包招标控制价审核表-变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("controlChange")
public class ControlChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IControlChangeService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IControlService controlService;

    @Autowired
    private IExecutionApi executionApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ControlChangeVO> saveOrUpdate(@RequestBody ControlChangeVO saveOrUpdateVO) {
        ControlChangeVO vo = service.saveOrUpdate(saveOrUpdateVO, false);

        if(CollectionUtils.isNotEmpty(vo.getControlDetailList())){
            List<ControlDetailChangeVO> contractDetailVOS = vo.getControlDetailList().stream().sorted(Comparator.comparing(ControlDetailChangeVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailTwoList())){
            List<ControlDetailChangeTwoVO> contractDetailVOS = vo.getControlDetailTwoList().stream().sorted(Comparator.comparing(ControlDetailChangeTwoVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailTwoList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailThreeList())){
            List<ControlDetailChangeThreeVO> contractDetailVOS = vo.getControlDetailThreeList().stream().sorted(Comparator.comparing(ControlDetailChangeThreeVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailThreeList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailFourList())){
            List<ControlDetailChangeFourVO> contractDetailVOS = vo.getControlDetailFourList().stream().sorted(Comparator.comparing(ControlDetailChangeFourVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailFourList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailFiveList())){
            List<ControlDetailChangeFiveVO> contractDetailVOS = vo.getControlDetailFiveList().stream().sorted(Comparator.comparing(ControlDetailChangeFiveVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailFiveList(contractDetailVOS);
        }
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 单据管控-
     *
     * @return
     */
    @RequestMapping(value = "/checkParams", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody ControlChangeVO vo) {
        ParamsCheckVO paramsCheckVO=null;
        CommonResponse<ParamsCheckVO> response = new CommonResponse<>();
        if (ControlVO.招标方式_项目招标.equals(vo.getType())){
            ControlChangeVO cv = service.saveOrUpdate(vo, true);
//        策划成本控制
            ExecutionVO executionVO = controlService.targetCost(BeanMapper.map(cv, ControlVO.class),service.getLinkUrl(cv.getId(), cv.getSubType()),cv.getSubType(),
                    ProsubBillTypeEnum.分包招标控制价变更.getBillTypeCode());
            logger.error("合同变更，策划成本数据校验参数：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            response = executionApi.ctrlCheckVO(executionVO);
            logger.error("合同变更，策划成本数据校验结果：{}" , JSONObject.toJSONString(response));

            if (!response.isSuccess()) {
                logger.error("策划成本参数控制失败，返回信息-{}", response.getMsg());
                return response;
            }


            paramsCheckVO = service.checkParams(vo, response,null);
        }
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ControlChangeVO> queryDetail(Long id) {
    	ControlChangeEntity entity = service.selectById(id);
    	ControlChangeVO vo = BeanMapper.map(entity, ControlChangeVO.class);
        if(CollectionUtils.isNotEmpty(vo.getControlDetailList())){
            List<ControlDetailChangeVO> contractDetailVOS = vo.getControlDetailList().stream().sorted(Comparator.comparing(ControlDetailChangeVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailTwoList())){
            List<ControlDetailChangeTwoVO> contractDetailVOS = vo.getControlDetailTwoList().stream().sorted(Comparator.comparing(ControlDetailChangeTwoVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailTwoList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailThreeList())){
            List<ControlDetailChangeThreeVO> contractDetailVOS = vo.getControlDetailThreeList().stream().sorted(Comparator.comparing(ControlDetailChangeThreeVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailThreeList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailFourList())){
            List<ControlDetailChangeFourVO> contractDetailVOS = vo.getControlDetailFourList().stream().sorted(Comparator.comparing(ControlDetailChangeFourVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailFourList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailFiveList())){
            List<ControlDetailChangeFiveVO> contractDetailVOS = vo.getControlDetailFiveList().stream().sorted(Comparator.comparing(ControlDetailChangeFiveVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailFiveList(contractDetailVOS);
        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ControlChangeVO> vos) {
        service.deleteChangeControl(vos.stream().map(ControlChangeVO::getId).collect(Collectors.toList()));

//        if(ListUtil.isNotEmpty(vos)){
//            for (ControlChangeVO vo : vos) {
//                // 参数是单据类型编码字符串 根据需求是否打开下面代码
//                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
//                if(!resp.isSuccess()){
//                    return CommonResponse.error("删除失败！"+resp.getMsg());
//                }*/
//            }
//        }
//        service.removeByIds(vos.stream().map(ControlChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ControlChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ControlChangeEntity> page = service.queryPage(param,false);
        IPage<ControlChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ControlChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ControlChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ControlChange-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refControlChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ControlChangeVO>> refControlChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ControlChangeEntity> page = service.queryPage(param,false);
        IPage<ControlChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ControlChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
