package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ClaimVO;
import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.bean.RegistrationEntity;
import com.ejianc.business.process.enums.ApplicationStateEnum;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.enums.UseFlagEnum;

import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.process.service.IRegistrationDetailService;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.business.process.vo.RegistrationDetailVO;
import com.ejianc.business.process.vo.RegistrationVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 零工登记主实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("registration")
public class RegistrationController  {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "RESG_JOB";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IRegistrationService service;
    @Autowired
    private IRegistrationDetailService detailService;
    @Autowired
    private IApplicationService applicationService;
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    private final String billTypeCode = "BT211230000000003";

    @Autowired
    private IContractService contractService;

    @Autowired
    private IProincomeContractApi proincomeContractApi;

    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/oddRegist/card";
    
    /**
     * @Description saveOrUpdate 新增或者修改 校验 当前清单是否存在
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RegistrationVO> saveOrUpdate(@RequestBody RegistrationVO saveorUpdateVO) {
    	RegistrationEntity entity = BeanMapper.map(saveorUpdateVO, RegistrationEntity.class);
    	if(entity.getBillCode() == null) {
            CommonResponse<String> billCode = billCodeApi.generateBillCode(BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveorUpdateVO));
            if (!billCode.isSuccess()) {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //设置 登记初始状态
            entity.setBillCode(billCode.getData());
        }
            entity.setSupplierSignStatus(SupplierSignStatusEnum.乙方未签字.getCode());
            entity.setBillState(0);
            //设置当前登记类型为 零工登记
            entity.setRegionType(0);
        entity.setSettleFlag(0);
    	if (entity.getFileIds()!=null){
            boolean b = entity.getAttachIds().addAll(entity.getFileIds());
        }

//        List<RegistrationDetailEntity> detailList = entity.getDetailList();
//        if (CollectionUtils.isNotEmpty(detailList)) {
//            Map<String, Long> idMap = new HashMap<>();
//            for (RegistrationDetailEntity cdEntity : detailList) {
//                idMap.put(cdEntity.getTid(), cdEntity.getId());
//            }
//            for (RegistrationDetailEntity cdEntity : detailList) {
//                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
//                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
//                }
//            }
//            detailService.saveOrUpdateBatch(detailList);
//        }

        //索赔签证办理引用状态处理
        if(null != entity.getVisaSlip()) {
            ClaimVO updateVo = new ClaimVO();
            updateVo.setId(entity.getVisaSlip());
            if(null != entity.getIncomeFlag() && entity.getIncomeFlag()) {
                updateVo.setRegistrationUseFlag(1);
            } else {
                updateVo.setRegistrationUseFlag(0);
                //清空发包方变更签证单Id
                entity.setVisaSlip(null);
            }

            CommonResponse<String> updateResp = proincomeContractApi.updateRegistrationUseFlag(updateVo);
            if(!updateResp.isSuccess()) {
                return CommonResponse.error("操作失败，更新发包方变更签证单引用状态失败！");
            }
        }

        // 保存即占用，会写零工申请登记状态为已登记
        if (entity.getApplicationId() != null) {
            ApplicationEntity applicationEntity = applicationService.selectById(entity.getApplicationId());
            if (ApplicationStateEnum.超时未办理.getCode() ==applicationEntity.getVisaState()){
                service.updateUseFlag(entity.getApplicationId(), UseFlagEnum.零工已登记.getCode(), null);
            }else {
                service.updateUseFlag(entity.getApplicationId(), UseFlagEnum.零工已登记.getCode(), ApplicationStateEnum.办理中.getCode());
            }
        }

        service.saveOrUpdate(entity, false);


    	return CommonResponse.success("保存或修改单据成功！", BeanMapper.map(entity, RegistrationVO.class));
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id 登记
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RegistrationVO> queryDetail(Long id) {
    	RegistrationEntity entity = service.selectById(id);
    	RegistrationVO vo = BeanMapper.map(entity, RegistrationVO.class);
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("registrationId", new Parameter(QueryParam.EQ, id));
//        queryParam.getOrderMap().put("treeIndex", "asc");
//        List<RegistrationDetailEntity> detailEntityListDb = detailService.queryList(queryParam, false);
//        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
//            for (RegistrationDetailEntity cdEntity : detailEntityListDb) {
//                cdEntity.setTid(cdEntity.getId().toString());
//                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
//                cdEntity.setRowState("edit");
//            }
//            List<RegistrationDetailVO> resultMapList = BeanMapper.mapList(detailEntityListDb, RegistrationDetailVO.class);
//            sortIntMethod(resultMapList);
//            vo.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
//
//        } else {
//            vo.setDetailList(BeanMapper.mapList(detailEntityListDb, RegistrationDetailVO.class));
//        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    private static void sortIntMethod(List<RegistrationDetailVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                RegistrationDetailVO o1Detail = objectMapper.convertValue(o1, RegistrationDetailVO.class);
                RegistrationDetailVO o2Detail = objectMapper.convertValue(o2, RegistrationDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                String[] strs2 = o2Detail.getTreeIndex().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RegistrationVO> vos) {
        //删除登记单 应该 回写申请状态
        for (RegistrationVO vo :vos){
            RegistrationEntity registrationEntity = service.selectById(vo.getId());
            if(registrationEntity != null && null != registrationEntity.getApplicationId()){
                ApplicationEntity applicationEntity = applicationService.selectById(registrationEntity.getApplicationId());
                if(null != applicationEntity) {
                    applicationEntity.setUseFlag(0);
                    if (applicationEntity.getVisaState()==ApplicationStateEnum.办理中.getCode()){
                        applicationEntity.setVisaState(ApplicationStateEnum.七天内未办理.getCode());
                    }
                    applicationService.saveOrUpdate(applicationEntity);
                }
            }

            if(null != registrationEntity.getVisaSlip()) {
                ClaimVO updateVo = new ClaimVO();
                updateVo.setId(registrationEntity.getVisaSlip());
                updateVo.setRegistrationUseFlag(0);

                CommonResponse<String> updateResp = proincomeContractApi.updateRegistrationUseFlag(updateVo);
                if(!updateResp.isSuccess()) {
                    return CommonResponse.error("操作失败，更新发包方变更签证单引用状态失败！");
                }
            }
        }
        service.removeByIds(vos.stream().map(RegistrationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    /**
     * @Description queryList 查询列表
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RegistrationVO>> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useWorkDetail");
        List<RegistrationEntity> dataList =new ArrayList<>();
        IPage<RegistrationEntity> page;
        param.getOrderMap().put("create_time", QueryParam.DESC);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        //移动端查询
        if (StringUtils.isNotBlank(authOrgIds)) {
            //移动端有默认项目的存在，故传递默认项目对应项目部Id时，查询其本下数据，若未传递，则返回空数据
            if(null == param.getParams().get("orgId")) {
                page = new Page<>(param.getPageIndex(), param.getPageSize(), 0);
            } else {
                page = service.queryPage(param, false);
                dataList = page.getRecords();
            }
        } else {
            //pc端查询
            //查询本下范围内日的合同
            Long orgId = InvocationInfoProxy.getOrgId();
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            page = service.queryPage(param, false);
            dataList = page.getRecords();
        }

        IPage<RegistrationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(dataList, RegistrationVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRegistrationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RegistrationVO>> refPicKingData(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText,
            @RequestParam(value = "searchObject", required = false)String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useWorkDetail");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState",new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        )));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if(StringUtils.isNotEmpty(condition)){
            JSONObject _con = JSONObject.parseObject(condition);
            //获取到日期 和 合同id 封装参数到查询条件
            if (_con.containsKey("contractId")){
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.getLong("contractId")));
            }
            if (_con.containsKey("endDate")){
                param.getParams().put("regionDate", new Parameter(QueryParam.LE, _con.get("endDate")));
            }
            if (_con.containsKey("settleFlag")){
                param.getParams().put("settleFlag", new Parameter(QueryParam.EQ, 0));
            }
        }
        IPage<RegistrationEntity> page = service.queryPage(param,false);
        IPage<RegistrationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RegistrationVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
    @GetMapping("queryDetailByAppId")
    @ResponseBody
    public CommonResponse<RegistrationVO> queryDetailByAppId(@RequestParam(value = "id") Long id) {
        RegistrationVO vo = null;
        ApplicationEntity entity = applicationService.selectById(id);
        if (null != entity) {
            vo = BeanMapper.map(entity, RegistrationVO.class);
            vo.setApplicationId(id);
            vo.setApplicationCode(entity.getBillCode());
            vo.setCreateUserCode(null);
            vo.setCreateTime(null);
            vo.setUpdateUserCode(null);
            vo.setUpdateTime(null);
            vo.setBillState(null);
            vo.setVersion(1);
            vo.setId(IdWorker.getId());
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id),"BT211230000000002","ygbefore", String.valueOf(vo.getId()), "BT211230000000003","ygbefore");
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id),"BT211230000000002","ygafter", String.valueOf(vo.getId()), "BT211230000000003","ygafter");
        }
        return CommonResponse.success("查询详情成功！", vo);
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }

    @GetMapping(value = "/getBillShareLink")
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        RegistrationEntity entity = service.selectById(id);

        if(SupplierSignStatusEnum.乙方未签字.getCode().equals(entity.getSupplierSignStatus()) && BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billTypeCode, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                //未曾成功推送单据，则先向供方推送单据
                boolean pushResult = service.pushBillToSupCenter(BeanMapper.map(entity, RegistrationEntity.class), billTypeCode, cooperateResp.getData());
                if(!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                } else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }

        return shareCooperateApi.getShareLink(id, billTypeCode, entity.getSupplierId().toString(), mobileBillShareFrontUrl, null);
    }

    /**
     * 文件导出 只导出本组织的
     *
     * @param param    无
     * @param response 当前组织签章设置
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        //查询本下范围内日的数据
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useWorkDetail");
        //查询所有满足的数据 按照创建时间倒叙
        param.getOrderMap().put("create_time", QueryParam.DESC);
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<RegistrationVO> pageData = queryList(param).getData();


//        导出数据
        logger.info("导出数据----{}",JSONObject.toJSONString(pageData));
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<RegistrationVO> list = BeanMapper.mapList(pageData.getRecords(), RegistrationVO.class);
            for (RegistrationVO item:list){
                item.setBillStateStr(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
                item.setContractTypeStr(item.getContractType()==0?"劳务分包合同":"专业分包合同");
//                item.setBillTypeStr(item.getBillType()==0?"自制":"申请单");
//                item.setSupplierSignStatusStr(item.getSupplierSignStatus()==0?"乙方未签字":"乙方已签字");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                item.setTimeStr(sdf.format(item.getCreateTime()));

            }
            Map<String, Object> beans = new HashMap<>(list.size());
            beans.put("records", list);
            ExcelExport.getInstance().exportWithTrans("registration-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value = "/mnyCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> mnyCtrl(@RequestBody RegistrationVO registrationVO) {
        return CommonResponse.success("参数校验成功！", service.mnyCtrl(registrationVO));
    }

    @RequestMapping(value = "/mnyCtrlById", method=RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> mnyCtrlById(@RequestParam(value = "id") Long id) {
        RegistrationEntity entity = service.selectById(id);
        if (entity == null) {
            return CommonResponse.error("结算单不存在！");
        }
        return CommonResponse.success("参数校验成功！", service.mnyCtrl(BeanMapper.map(entity, RegistrationVO.class)));
    }

    /**
     * @return
     * @param id 合同Id
     */
    @RequestMapping(value = "/contractRegistrationRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> contractRegistrationRecord(@RequestParam Long id) {
        JSONObject resp = new JSONObject();

        ContractEntity contract = contractService.selectById(id);

        QueryWrapper<RegistrationEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contract.getId());
        query.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        query.orderByDesc("create_time");

        List<RegistrationEntity> list = service.list(query);
        resp.put("registrationList", BeanMapper.mapList(list, RegistrationVO.class));

        BigDecimal totalRegistrationTaxMny = BigDecimal.ZERO;
        for(RegistrationEntity item : list) {
            totalRegistrationTaxMny = totalRegistrationTaxMny.add(item.getTotalTaxMny());
        }

        resp.put("contractTaxMny", contract.getContractTaxMny());
        resp.put("totalRegistrationTaxMny", totalRegistrationTaxMny);
        resp.put("registrationRatio", totalRegistrationTaxMny.divide(contract.getContractTaxMny(), 8, BigDecimal.ROUND_HALF_UP));

        return CommonResponse.success("查询详情数据成功！", resp);
    }

}
