package com.ejianc.business.prosub.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.prosub.service.IContractManagementService;
import com.ejianc.business.prosub.vo.ProjectObjectVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.concurrent.ExecutionException;

@RestController
@RequestMapping("contractManagement")
public class ContractManagementController {

    private static final Logger log = LoggerFactory.getLogger(ContractManagementController.class);
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IContractManagementService service;

    @GetMapping("/gmkzysj")
    public CommonResponse<List<Map<String, String>>> gmkzysjSelect() {
        List<Map<String, String>> ans = new ArrayList<>();
        Map<String, String> lwfbht = new HashMap<>();
        lwfbht.put("modeName", "合同管理");
        lwfbht.put("modeDataUrl", "lwfbht");
        lwfbht.put("modeDaraReqType", "GET");
        lwfbht.put("tableType", "1");
        ans.add(lwfbht);
        Map<String, String> fbfqzspd = new HashMap<>();
        fbfqzspd.put("modeName", "发包方商务管理");
        fbfqzspd.put("modeDataUrl", "fbfqzspd");
        fbfqzspd.put("modeDaraReqType", "GET");
        fbfqzspd.put("tableType", "2");
        ans.add(fbfqzspd);
        Map<String, String> wzgl = new HashMap<>();
        wzgl.put("modeName", "物资管理");
        wzgl.put("modeDataUrl", "wzgl");
        wzgl.put("modeDaraReqType", "GET");
        wzgl.put("tableType", "3");
        ans.add(wzgl);
        Map<String, String> fenbfswgl = new HashMap<>();
        fenbfswgl.put("modeName", "分包商务管理");
        fenbfswgl.put("modeDataUrl", "fenbfswgl");
        fenbfswgl.put("modeDaraReqType", "GET");
        fenbfswgl.put("tableType", "4");
        ans.add(fenbfswgl);
        Map<String, String> jsgli = new HashMap<>();
        jsgli.put("modeName", "技术管理");
        jsgli.put("modeDataUrl", "jsgli");
        jsgli.put("modeDaraReqType", "GET");
        jsgli.put("tableType", "5");
        ans.add(jsgli);
        Map<String, String> zljl = new HashMap<>();
        zljl.put("modeName", "质量管理");
        zljl.put("modeDataUrl", "zljl");
        zljl.put("modeDaraReqType", "GET");
        zljl.put("tableType", "6");
        ans.add(zljl);
        Map<String, String> aqjc = new HashMap<>();
        aqjc.put("modeName", "安全管理");
        aqjc.put("modeDataUrl", "aqjc");
        aqjc.put("modeDaraReqType", "GET");
        aqjc.put("tableType", "7");
        ans.add(aqjc);
        return CommonResponse.success("查询成功", ans);
    }

    @GetMapping(value = "/lwfbht")
    public CommonResponse<String> analysisSelect(@RequestParam(value = "id", required = false)
                                                 Long projectId) {
        ProjectObjectVo objectVo = service.analysisSelect(projectId);
        String jsonString = JSONObject.toJSONString(objectVo);
        return CommonResponse.success("查询成功", jsonString);
    }

    @GetMapping(value = "/fbfqzspd")
    public CommonResponse<String> fbfqzspdSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = service.fbfqzspdSelect(projectId);
        String jsonString = JSONObject.toJSONString(objectVo);
        return CommonResponse.success("查询成功", jsonString);
    }

    @GetMapping(value = "/wzgl")
    public CommonResponse<String> wzglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = service.wzglSelect(projectId);
        return CommonResponse.success("查询成功", JSONObject.toJSONString(objectVo));
    }

    @GetMapping(value = "/fenbfswgl")
    public CommonResponse<String> fenbfswglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = service.fenbfswglSelect(projectId);

        return CommonResponse.success("查询成功", JSONObject.toJSONString(objectVo));
    }

    @GetMapping(value = "/jsgli")
    public CommonResponse<String> jsgliSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = service.jsgliSelect(projectId);
        return CommonResponse.success("查询成功", JSONObject.toJSONString(objectVo));
    }

    @GetMapping(value = "/zljl")
    public CommonResponse<String> zlglSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = service.zlglSelect(projectId);
        return CommonResponse.success("查询成功", JSONObject.toJSONString(objectVo));
    }

    @GetMapping(value = "/aqjc")
    public CommonResponse<String> aqjcSelect(@RequestParam(value = "id", required = false) Long projectId) {
        ProjectObjectVo objectVo = service.aqjcSelect(projectId);
        return CommonResponse.success("查询成功", JSONObject.toJSONString(objectVo));
    }


    @PostMapping("/yunyingtongji")
    public CommonResponse<String> yunyingtongjiSelect(QueryParam param)
            throws ExecutionException, InterruptedException {
        //1.查询所有项目名称
        Map<String, Long> orgVo = getOrgVo();
        if (orgVo.isEmpty()) {
            return CommonResponse.success("暂无数据");
        }
        //排序后数据处理
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        //CompletableFuture<ProjectObjectVo> latch = new CompletableFuture<>();
        List<ProjectObjectVo> projectObjectVos = service.yunyingtongjiSelect(orgVo, param);
        log.info("projectObjectVos==>的长度:{}  pageIndex==>{},pageSize==>{}", projectObjectVos.size(), pageIndex, pageSize);
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        List<ProjectObjectVo> vos = orderMapVos(orderMap, projectObjectVos);
        List<ProjectObjectVo> ans = new ArrayList<>();
        log.info("pageIndex==>{},pageSize==>{}", pageIndex, pageSize);
        for (int i = (pageIndex - 1) * pageSize; i < pageSize * pageIndex; i++) {
            if (i >= vos.size()) break;
            ans.add(vos.get(i));
        }
        log.info("分页后数据长度==>{}", vos.size());
        return CommonResponse.success("查询成功",
                JSONObject.toJSONString(ans));
    }

    private List<ProjectObjectVo> orderMapVos(LinkedHashMap<String, String> orderMap,
                                              List<ProjectObjectVo> projectObjectVos
    ) {
        if (orderMap == null || orderMap.isEmpty()) {
            log.info("orderMap 排序规者为空");
            return projectObjectVos;
        }
        if (projectObjectVos == null || projectObjectVos.isEmpty()) {
            log.info("projectObjectVos 结果集为空");
            return projectObjectVos;
        }
        log.info("开始执行分页查询");
        Set<Map.Entry<String, String>> entries = orderMap.entrySet();
        List<ProjectObjectVo> ans = new ArrayList<>();
        boolean[][] check = new boolean[3][2];
        for (Map.Entry<String, String> entry : entries) {
            if ("weekly".equals(entry.getKey())) {
                check[0][0] = true;
                check[0][1] = "desc".equals(entry.getValue());//true代表降序
            }
            if ("monthly".equals(entry.getKey())) {
                check[1][0] = true;
                check[1][1] = "desc".equals(entry.getValue());
            }
            if ("total".equals(entry.getKey())) {
                check[2][0] = true;
                check[2][1] = "desc".equals(entry.getValue());
            }
        }
        Collections.sort(projectObjectVos,
                (o1, o2) -> {
                    if (check[0][0]) {
                        if (o1.getWeekly() > o2.getWeekly()) {
                            return check[0][1] ? -1 : 1;
                        } else if (o1.getWeekly() < o2.getWeekly()) {
                            return check[0][1] ? 1 : -1;
                        }
                    }
                    if (check[1][0]) {
                        if (o1.getMonthly() > o2.getMonthly()) {
                            return check[1][1] ? -1 : 1;
                        } else if (o1.getMonthly() < o2.getMonthly()) {
                            return check[1][1] ? 1 : -1;
                        }
                    }
                    if (check[2][0]) {
                        if (o1.getTotal() > o2.getTotal()) {
                            return check[2][1] ? -1 : 1;
                        } else if (o1.getTotal() < o2.getTotal()) {
                            return check[2][1] ? 1 : -1;
                        }
                    }
                    return 0;
                }
        );
        return ans;
    }


    private Map<String, Long> getOrgVo() {
        CommonResponse<List<OrgVO>> children = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        Map<String, Long> map = new HashMap<>();
        if (children == null || children.getData() == null || children.getData().isEmpty()) {
            return map;
        }
        for (OrgVO an : children.getData()) {
            if (an.getIsParent() == null || (!an.getIsParent() && an.getName() != null
                    && !an.getName().isEmpty()
                    && an.getId() != null)) {
                log.info("查询项目数据:名称==>{},项目ID==>{}", an.getName(), an.getId());
                map.put(an.getName(), an.getId());
            }
        }
        return map;
    }

}

