/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.process.bean.AdjustDetailEntity;
import com.ejianc.business.process.bean.AdjustEntity;
import com.ejianc.business.process.mapper.AdjustMapper;
import com.ejianc.business.process.service.IAdjustDetailService;
import com.ejianc.business.process.service.IAdjustService;
import com.ejianc.business.process.vo.AdjustDetailVO;
import com.ejianc.business.process.vo.AdjustVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="adjustService")
public class AdjustServiceImpl
extends BaseServiceImpl<AdjustMapper, AdjustEntity>
implements IAdjustService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ADJUST_CODE";
    @Autowired
    private IShareLabsubApi labsubApi;
    @Autowired
    private IShareProsubApi prosubApi;
    @Autowired
    private IAdjustService service;
    @Autowired
    private IAdjustDetailService detailService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public AdjustVO insertOrUpdate(AdjustVO saveOrUpdateVO) {
        AdjustEntity entity = (AdjustEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AdjustEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getAdjustDetailList())) {
            HashSet<String> useTypeSet = new HashSet<String>();
            List<AdjustDetailEntity> detailList = entity.getAdjustDetailList();
            for (AdjustDetailEntity detailEntity : detailList) {
                if ("del".equals(detailEntity.getRowState()) || !StringUtils.isNotBlank((String)detailEntity.getDetailUseTypeName())) continue;
                useTypeSet.add(detailEntity.getDetailUseTypeName());
            }
            if (CollectionUtils.isNotEmpty(useTypeSet)) {
                entity.setUseType(String.join((CharSequence)",", useTypeSet));
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        return (AdjustVO)BeanMapper.map((Object)((Object)entity), AdjustVO.class);
    }

    @Override
    public AdjustVO queryDetail(Long id) {
        AdjustEntity entity = (AdjustEntity)((Object)this.service.selectById(id));
        AdjustVO vo = (AdjustVO)BeanMapper.map((Object)((Object)entity), AdjustVO.class);
        return vo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CommonResponse<Object> importData(Integer type, HttpServletRequest request, HttpServletResponse response) {
        ArrayList<AdjustDetailVO> errorList;
        ArrayList<AdjustDetailVO> successList;
        block35: {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            successList = new ArrayList<AdjustDetailVO>();
            errorList = new ArrayList<AdjustDetailVO>();
            HashMap map = new HashMap();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
            boolean isFailed = false;
            MultipartFile mf = null;
            for (Map.Entry entity : fileMap.entrySet()) {
                mf = (MultipartFile)entity.getValue();
                String originalFileName = mf.getOriginalFilename();
                String extName = null;
                originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
                originalFileName.replaceAll("00.", "");
                extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
                if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
                isFailed = true;
                break;
            }
            if (isFailed) {
                return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
            }
            HashMap<String, List> codeMap = new HashMap<String, List>();
            HashMap<String, List> codeMap1 = new HashMap<String, List>();
            List result = ExcelReader.readExcel((MultipartFile)mf);
            DecimalFormat decimalFormat = new DecimalFormat("0.00000000");
            if (result == null || result.size() <= 0) break block35;
            if (((List)result.get(0)).size() != 9) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 1; i < result.size(); ++i) {
                AdjustDetailVO detailVO;
                String memo;
                String detailTaxMny;
                String detailTaxPrice;
                String detailTaxRate;
                String detailNum;
                String detailName;
                StringBuilder errorsMsgBuilder;
                block36: {
                    LabsubItemVO labsubItemVO;
                    Iterator iterator;
                    String detailCode;
                    block34: {
                        block33: {
                            List data;
                            List datas = (List)result.get(i);
                            errorsMsgBuilder = new StringBuilder();
                            detailCode = (String)datas.get(0);
                            this.logger.info("detailCode--" + detailCode);
                            this.logger.info("int----" + i);
                            detailName = (String)datas.get(1);
                            detailNum = (String)datas.get(2);
                            detailTaxRate = (String)datas.get(3);
                            detailTaxPrice = (String)datas.get(4);
                            detailTaxMny = (String)datas.get(5);
                            memo = (String)datas.get(6);
                            detailVO = new AdjustDetailVO();
                            detailVO.setDetailName(detailName);
                            detailVO.setDetailCode(detailCode);
                            detailVO.setTreeIndex(String.valueOf(i));
                            if (StringUtils.isBlank((String)detailCode)) {
                                detailVO.setErrorMessage("\u6e05\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                                continue;
                            }
                            CommonResponse listCommonResponse = null;
                            CommonResponse listCommonResponse1 = null;
                            if (type == 0 || type == 2) {
                                if (MapUtils.isEmpty(codeMap) || codeMap.get(detailCode) == null) {
                                    listCommonResponse = this.labsubApi.queryItemListByCodes(Arrays.asList(detailCode));
                                    if (listCommonResponse.isSuccess()) {
                                        data = (List)listCommonResponse.getData();
                                        if (data == null) {
                                            detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                            errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                                            detailVO.setIsMatch("\u672a\u5339\u914d");
                                            continue;
                                        }
                                        codeMap.put(detailCode, data);
                                        iterator = data.iterator();
                                        break block33;
                                    } else {
                                        detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                        errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                                        continue;
                                    }
                                }
                                detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                                continue;
                            }
                            if (type == 1) {
                                if (MapUtils.isEmpty(codeMap1) || codeMap1.get(detailCode) == null) {
                                    listCommonResponse1 = this.prosubApi.queryItemListByCodes(Arrays.asList(detailCode));
                                    if (listCommonResponse1.isSuccess()) {
                                        data = (List)listCommonResponse1.getData();
                                        if (data == null) {
                                            detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                            errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                                            detailVO.setIsMatch("\u672a\u5339\u914d");
                                            continue;
                                        }
                                        codeMap1.put(detailCode, data);
                                        iterator = data.iterator();
                                        break block34;
                                    } else {
                                        detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                        errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                                        continue;
                                    }
                                }
                                detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                                continue;
                            }
                            if (type == 3) {
                                detailVO.setDetailCode(detailCode);
                            }
                            break block36;
                        }
                        while (iterator.hasNext()) {
                            labsubItemVO = (LabsubItemVO)iterator.next();
                            if (labsubItemVO.getTrawlingCode().equals(detailCode) && labsubItemVO.getTrawlingName().equals(detailName)) {
                                detailVO.setDetailWorkContent(labsubItemVO.getJobContent());
                                detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                detailVO.setDetailUnit(labsubItemVO.getUnitName());
                                detailVO.setDetailCode(detailCode);
                                detailVO.setDetailName(detailName);
                                detailVO.setIsMatch("\u5df2\u5339\u914d");
                                continue;
                            }
                            detailVO.setIsMatch("\u672a\u5339\u914d");
                            detailVO.setErrorMessage("\u6e05\u5355\u7f16\u7801\u4e0e\u6863\u6848\u7f16\u7801\u672a\u5339\u914d");
                            errorsMsgBuilder.append("\u672a\u5339\u914d");
                        }
                        break block36;
                    }
                    while (iterator.hasNext()) {
                        labsubItemVO = (ProsubItemVO)iterator.next();
                        if (labsubItemVO.getTrawlingCode().equals(detailCode) && labsubItemVO.getTrawlingName().equals(detailName)) {
                            detailVO.setDetailWorkContent(labsubItemVO.getJobContent());
                            detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                            detailVO.setDetailUnit(labsubItemVO.getUnitName());
                            detailVO.setDetailCode(detailCode);
                            detailVO.setDetailName(detailName);
                            detailVO.setDocId(labsubItemVO.getId());
                            detailVO.setIsMatch("\u5df2\u5339\u914d");
                            continue;
                        }
                        detailVO.setIsMatch("\u672a\u5339\u914d");
                        errorsMsgBuilder.append("\u672a\u5339\u914d");
                    }
                }
                if (type == 3) {
                    if (StringUtils.isBlank((String)detailName)) {
                        detailVO.setErrorMessage("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                        errorsMsgBuilder.append("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                        continue;
                    }
                    detailVO.setDetailName(detailName);
                }
                if (StringUtils.isBlank((String)detailNum)) {
                    detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    continue;
                }
                try {
                    BigDecimal detailNum1 = new BigDecimal(detailNum);
                    detailVO.setDetailSubNum(detailNum1);
                }
                catch (Exception e) {
                    detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                    errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    continue;
                }
                if (StringUtils.isBlank((String)detailTaxRate)) {
                    detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    continue;
                }
                try {
                    BigDecimal taxRate1 = new BigDecimal(detailTaxRate);
                    if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                        detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
                        errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        continue;
                    }
                    detailVO.setDetailTaxRate(taxRate1);
                }
                catch (Exception e) {
                    detailVO.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                    errorsMsgBuilder.append("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    continue;
                }
                BigDecimal tax = ComputeUtil.safeDiv((BigDecimal)new BigDecimal(detailTaxRate), (BigDecimal)new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                BigDecimal num = new BigDecimal(detailNum);
                if (StringUtils.isNotBlank((String)detailTaxPrice)) {
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setDetailSubTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailSubPrice(price);
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)num, (BigDecimal)price);
                    detailVO.setDetailSubMny(mny);
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailSubTaxMny(taxMny);
                    BigDecimal tax1 = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)tax);
                    detailVO.setDetailSubTax(tax1);
                }
                if (StringUtils.isNotBlank((String)detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setDetailSubTaxMny(taxMny);
                    BigDecimal mny = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailSubMny(mny);
                    BigDecimal taxPrice = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)num);
                    detailVO.setDetailSubTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailSubPrice(price);
                    BigDecimal detailTax = ComputeUtil.safeMultiply((BigDecimal)tax, (BigDecimal)mny);
                    detailVO.setDetailSubTax(detailTax);
                }
                if (StringUtils.isNotBlank((String)memo)) {
                    detailVO.setDetailMemo(memo);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @Override
    public CommonResponse<Object> importOtherData(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<AdjustDetailVO> successList = new ArrayList<AdjustDetailVO>();
        ArrayList<AdjustDetailVO> errorList = new ArrayList<AdjustDetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        HashMap codeMap = new HashMap();
        HashMap codeMap1 = new HashMap();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        DecimalFormat decimalFormat = new DecimalFormat("0.00000000");
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 9) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String detailName = (String)datas.get(0);
                String detailWorkContent = (String)datas.get(1);
                String detailMeasurementRules = (String)datas.get(2);
                String detailUnit = (String)datas.get(3);
                String detailNum = (String)datas.get(4);
                String detailTaxRate = (String)datas.get(5);
                String detailTaxPrice = (String)datas.get(6);
                String detailTaxMny = (String)datas.get(7);
                String memo = (String)datas.get(8);
                AdjustDetailVO detailVO = new AdjustDetailVO();
                detailVO.setDetailName(detailName);
                detailVO.setTreeIndex(String.valueOf(i));
                if (StringUtils.isBlank((String)detailName)) {
                    detailVO.setErrorMessage("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u6e05\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setDetailName(detailName);
                }
                if (StringUtils.isBlank((String)detailWorkContent)) {
                    detailVO.setErrorMessage("\u5de5\u4f5c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5de5\u4f5c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setDetailWorkContent(detailWorkContent);
                }
                if (StringUtils.isBlank((String)detailMeasurementRules)) {
                    detailVO.setErrorMessage("\u8ba1\u91cf\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u8ba1\u91cf\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setDetailMeasurementRules(detailMeasurementRules);
                }
                if (StringUtils.isBlank((String)detailUnit)) {
                    detailVO.setErrorMessage("\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    detailVO.setDetailUnit(detailUnit);
                }
                if (StringUtils.isBlank((String)detailNum)) {
                    detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        BigDecimal detailNum1 = new BigDecimal(detailNum);
                        detailVO.setDetailSubNum(detailNum1);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                if (StringUtils.isBlank((String)detailTaxRate)) {
                    detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        BigDecimal taxRate1 = new BigDecimal(detailTaxRate);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            detailVO.setDetailTaxRate(taxRate1);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                BigDecimal tax = ComputeUtil.safeDiv((BigDecimal)new BigDecimal(detailTaxRate), (BigDecimal)new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                BigDecimal num = new BigDecimal(detailNum);
                if (StringUtils.isNotBlank((String)detailTaxPrice)) {
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setDetailSubTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailSubPrice(price);
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)num, (BigDecimal)price);
                    detailVO.setDetailSubMny(mny);
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailSubTaxMny(taxMny);
                    BigDecimal tax1 = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)tax);
                    detailVO.setDetailSubTax(tax1);
                }
                if (StringUtils.isNotBlank((String)detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setDetailSubTaxMny(taxMny);
                    BigDecimal mny = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailSubMny(mny);
                    BigDecimal taxPrice = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)num);
                    detailVO.setDetailSubTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailSubPrice(price);
                    BigDecimal detailTax = ComputeUtil.safeMultiply((BigDecimal)tax, (BigDecimal)mny);
                    detailVO.setDetailSubTax(detailTax);
                }
                if (StringUtils.isNotBlank((String)memo)) {
                    detailVO.setDetailMemo(memo);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @Override
    public CommonResponse<Object> importEquipmentData(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<AdjustDetailVO> successList = new ArrayList<AdjustDetailVO>();
        ArrayList<AdjustDetailVO> errorList = new ArrayList<AdjustDetailVO>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        HashMap<String, List> codeMap = new HashMap<String, List>();
        HashMap codeMap1 = new HashMap();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 8) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String detailCode = (String)datas.get(0);
                String detailName = (String)datas.get(1);
                String detailNewNum = (String)datas.get(2);
                String useTime = (String)datas.get(3);
                String detailTaxRate = (String)datas.get(4);
                String detailTaxPrice = (String)datas.get(5);
                String detailTaxMny = (String)datas.get(6);
                String memo = (String)datas.get(7);
                AdjustDetailVO detailVO = new AdjustDetailVO();
                detailVO.setDetailName(detailName);
                detailVO.setDetailCode(detailCode);
                detailVO.setTreeIndex(String.valueOf(i));
                if (StringUtils.isBlank((String)detailCode)) {
                    detailVO.setErrorMessage("\u6e05\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    CommonResponse listCommonResponse = null;
                    Object listCommonResponse1 = null;
                    if (MapUtils.isEmpty(codeMap) || codeMap.get(detailCode) == null) {
                        listCommonResponse = this.labsubApi.queryItemListByCodes(Arrays.asList(detailCode));
                        if (listCommonResponse.isSuccess()) {
                            List data = (List)listCommonResponse.getData();
                            if (data == null) {
                                detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                                errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                                detailVO.setIsMatch("\u672a\u5339\u914d");
                            } else {
                                codeMap.put(detailCode, data);
                                for (LabsubItemVO labsubItemVO : data) {
                                    if (labsubItemVO.getTrawlingCode().equals(detailCode) && labsubItemVO.getTrawlingName().equals(detailName)) {
                                        detailVO.setDetailWorkContent(labsubItemVO.getJobContent());
                                        detailVO.setDetailMeasurementRules(labsubItemVO.getDetailMeasurementRules());
                                        detailVO.setDetailUnit(labsubItemVO.getUnitName());
                                        detailVO.setDetailCode(detailCode);
                                        detailVO.setDetailName(detailName);
                                        detailVO.setDocId(labsubItemVO.getId());
                                        detailVO.setIsMatch("\u5df2\u5339\u914d");
                                        continue;
                                    }
                                    detailVO.setIsMatch("\u672a\u5339\u914d");
                                    detailVO.setErrorMessage("\u6e05\u5355\u7f16\u7801\u4e0e\u6e05\u5355\u540d\u79f0\u672a\u5339\u914d");
                                    errorsMsgBuilder.append("\u672a\u5339\u914d");
                                }
                            }
                        } else {
                            detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                            errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                        }
                    } else {
                        detailVO.setErrorMessage("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25");
                        errorsMsgBuilder.append("\u6839\u636e\u6e05\u5355\u7f16\u53f7\u67e5\u8be2\u5931\u8d25\uff01");
                    }
                }
                if (StringUtils.isBlank((String)detailNewNum)) {
                    detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        BigDecimal detailNewNum1 = new BigDecimal(detailNewNum);
                        detailVO.setDetailSubNum(detailNewNum1);
                        detailVO.setDetailSubNewNum(detailNewNum1);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u5de5\u7a0b\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                BigDecimal useTimeData = null;
                if (StringUtils.isBlank((String)useTime)) {
                    detailVO.setErrorMessage("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        useTimeData = new BigDecimal(useTime);
                        if (useTimeData.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            detailVO.setDetailSubUseDate(useTimeData);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u4f7f\u7528\u65f6\u95f4\uff08\u6708\uff09\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                if (StringUtils.isBlank((String)detailTaxRate)) {
                    detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    try {
                        BigDecimal taxRate1 = new BigDecimal(detailTaxRate);
                        if (taxRate1.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
                            errorsMsgBuilder.append("\u7a0e\u7387\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
                        } else {
                            detailVO.setDetailTaxRate(taxRate1);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57");
                        errorsMsgBuilder.append("\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                    }
                }
                BigDecimal tax = ComputeUtil.safeDiv((BigDecimal)new BigDecimal(detailTaxRate), (BigDecimal)new BigDecimal("100"));
                BigDecimal one = new BigDecimal("1.0");
                BigDecimal detailNewNumData = new BigDecimal(detailNewNum);
                BigDecimal num = ComputeUtil.safeMultiply((BigDecimal)detailNewNumData, (BigDecimal)useTimeData);
                if (StringUtils.isNotBlank((String)detailTaxPrice)) {
                    BigDecimal taxPrice = new BigDecimal(detailTaxPrice);
                    detailVO.setDetailSubTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailSubPrice(price);
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)num, (BigDecimal)price);
                    detailVO.setDetailSubMny(mny);
                    BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailSubTaxMny(taxMny);
                    BigDecimal tax1 = ComputeUtil.safeMultiply((BigDecimal)mny, (BigDecimal)tax);
                    detailVO.setDetailSubTax(tax1);
                }
                if (StringUtils.isNotBlank((String)detailTaxMny)) {
                    BigDecimal taxMny = new BigDecimal(detailTaxMny);
                    detailVO.setDetailSubTaxMny(taxMny);
                    BigDecimal mny = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailSubMny(mny);
                    BigDecimal taxPrice = ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)num);
                    detailVO.setDetailSubTaxPrice(taxPrice);
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)one, (BigDecimal)tax));
                    detailVO.setDetailSubPrice(price);
                    BigDecimal detailTax = ComputeUtil.safeMultiply((BigDecimal)tax, (BigDecimal)mny);
                    detailVO.setDetailSubTax(detailTax);
                }
                if (StringUtils.isNotBlank((String)memo)) {
                    detailVO.setDetailMemo(memo);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private static void sortIntMethod(List<AdjustDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                AdjustDetailVO o1Detail = (AdjustDetailVO)objectMapper.convertValue(o1, AdjustDetailVO.class);
                AdjustDetailVO o2Detail = (AdjustDetailVO)objectMapper.convertValue(o2, AdjustDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getTreeIndex().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }
}

