/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.controller;

import com.ejianc.business.prosub.mapper.ProgressAnalysisMapper;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"progressAnalysis"})
public class ProgressAnalysisController {
    private static final Logger log = LoggerFactory.getLogger(ProgressAnalysisController.class);
    @Autowired
    private ProgressAnalysisMapper mapper;
    @Autowired
    private SettleMapper settleMapper;

    @GetMapping(value={"/analysis"})
    public CommonResponse<Map<String, Object>> analysisSelect(@RequestParam(value="id", required=false) Long projectId) {
        HashMap<String, Object> ans = new HashMap<String, Object>();
        if (projectId == null) {
            ans.put("duration", 0);
            ans.put("planEndDate", 0);
            ans.put("progress", 0);
            ans.put("planStartDate", 0);
            ans.put("planDateNum", 0);
            ans.put("productionProgress", 0);
            ans.put("approvalProgress", 0);
            ans.put("reportProgress", 0);
            ans.put("paymentCollection", 0);
            ans.put("expenditureSettlement", 0);
            ans.put("paymentProgress", 0);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", ans);
        }
        Map<String, Object> projectInitiation = this.mapper.getProjectInitiation(projectId);
        log.info("projectInitiation:{}", projectInitiation);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        long duration = 0L;
        Date day = new Date();
        try {
            String planEndDateStr = String.valueOf(projectInitiation.get("plan_end_date"));
            Date planEndDate = format.parse(planEndDateStr);
            duration = ChronoUnit.DAYS.between(this.getLocalDate(day), this.getLocalDate(planEndDate));
            if (duration < 0L) {
                duration = 0L;
            }
            ans.put("duration", duration);
            log.info("duration:{}", ans.get("duration"));
            ans.put("planEndDate", format.format(planEndDate));
            log.info("planEndDate:{}", ans.get("planEndDate"));
        }
        catch (Exception e) {
            log.error("\u3010\u5269\u4f59\u5de5\u671f\u3011\u9519\u8bef");
            ans.put("duration", 0);
        }
        try {
            String planStartDateStr = String.valueOf(projectInitiation.get("plan_start_date"));
            Date planStartDate = format.parse(planStartDateStr);
            long planDateNum = Long.parseLong(String.valueOf(projectInitiation.get("plan_date_num")));
            double progress = 0.0;
            long between = Math.abs(ChronoUnit.DAYS.between(this.getLocalDate(day), this.getLocalDate(planStartDate)));
            progress = (double)between / (double)planDateNum * 100.0;
            ans.put("progress", progress);
            ans.put("planStartDate", format.format(planStartDate));
            ans.put("planDateNum", planDateNum);
        }
        catch (Exception e) {
            log.error("\u3010\u8ba1\u5212\u5de5\u671f\u3011\uff0c\u3010\u8ba1\u5212\u5f00\u5de5\u65e5\u671f\u3011\uff0c\u3010\u5de5\u671f\u8fdb\u5ea6\u3011\u9519\u8bef");
            ans.put("progress", 0);
        }
        BigDecimal registerProgectId = null;
        try {
            BigDecimal incomeProgectId = this.mapper.getProductionProgectMoney(projectId);
            registerProgectId = this.mapper.getContractRegisterProgectMoney(projectId);
            BigDecimal productionProgress = registerProgectId.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : incomeProgectId.divide(registerProgectId, 10, RoundingMode.HALF_UP);
            ans.put("productionProgress", productionProgress.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
            log.info("productionProgress:{}", ans.get("productionProgress"));
        }
        catch (Exception e) {
            log.error("\u3010\u65bd\u5de5\u5408\u540c\u91d1\u989d\u3011\u9519\u8bef");
            ans.put("productionProgress", 0);
        }
        try {
            BigDecimal templaterProgectMoney = this.mapper.getTemplaterProgectMoney(projectId);
            if (registerProgectId == null) {
                throw new BusinessException("\u65bd\u5de5\u5408\u540c\u91d1\u989d\u5f02\u5e38");
            }
            BigDecimal approvalProgress = registerProgectId.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : templaterProgectMoney.divide(registerProgectId, 10, RoundingMode.HALF_UP);
            ans.put("approvalProgress", approvalProgress.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
        }
        catch (Exception e) {
            log.error("\u3010\u6279\u590d\u8fdb\u5ea6\u3011\u9519\u8bef");
            ans.put("approvalProgress", 0);
        }
        try {
            BigDecimal money = this.mapper.getSBProgectMoney(projectId);
            BigDecimal reportProgress = registerProgectId.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : money.divide(registerProgectId, 10, RoundingMode.HALF_UP);
            ans.put("reportProgress", reportProgress.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
        }
        catch (Exception e) {
            log.error("\u3010\u4e0a\u62a5\u8fdb\u5ea6\u3011\u9519\u8bef");
            ans.put("reportProgress", 0);
        }
        try {
            BigDecimal registerProgectMoney = this.mapper.getReceiptRegisterProgectMoney(projectId);
            if (registerProgectId == null) {
                throw new BusinessException("\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u5f02\u5e38");
            }
            BigDecimal paymentCollection = registerProgectId.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : registerProgectMoney.divide(registerProgectId, 10, RoundingMode.HALF_UP);
            ans.put("paymentCollection", paymentCollection.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
        }
        catch (Exception e) {
            log.error("\u3010\u56de\u6b3e\u8fdb\u5ea6\u3011\u9519\u8bef");
            ans.put("paymentCollection", 0);
        }
        BigDecimal expenditureContractAmount = null;
        BigDecimal settlementAmountSum = null;
        try {
            settlementAmountSum = this.getAmountSum(projectId);
            expenditureContractAmount = this.getSubcontractAmount(projectId);
            BigDecimal expenditureSettlement = expenditureContractAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : settlementAmountSum.divide(expenditureContractAmount, 10, RoundingMode.HALF_UP);
            ans.put("expenditureSettlement", expenditureSettlement.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
        }
        catch (Exception e) {
            ans.put("expenditureSettlement", 0);
        }
        try {
            BigDecimal paymentRegisterAmount = this.mapper.getPaymentRegisterAmount(projectId);
            BigDecimal paymentProgress = settlementAmountSum.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : paymentRegisterAmount.divide(settlementAmountSum, 10, RoundingMode.HALF_UP);
            ans.put("paymentProgress", paymentProgress.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
        }
        catch (Exception e) {
            log.error("\u3010\u4ed8\u6b3e\u8fdb\u5ea6\u3011\u9519\u8bef");
            ans.put("paymentProgress", 0);
        }
        return CommonResponse.success((String)("\u67e5\u8be2\u6210\u529f:" + projectId), ans);
    }

    private BigDecimal getAmountSum(Long projectId) {
        BigDecimal measurementProjectMny = this.settleMapper.getMeasurementProjectMny(projectId);
        BigDecimal adjustmentAmount = this.mapper.getAdjustmentAmount(projectId);
        BigDecimal promaterialSettlementAmount = this.mapper.getPromaterialSettlementAmount(projectId);
        BigDecimal settlementAmount = this.mapper.getSettlementAmount(projectId);
        BigDecimal proequipmentPurchaseAmount = this.mapper.getProequipmentPurchaseAmount(projectId);
        BigDecimal prosubSettleAmount = this.mapper.getProsubSettleAmount(projectId);
        return (measurementProjectMny == null ? BigDecimal.ZERO : measurementProjectMny).add(adjustmentAmount == null ? BigDecimal.ZERO : adjustmentAmount).add(prosubSettleAmount == null ? BigDecimal.ZERO : prosubSettleAmount).add(promaterialSettlementAmount == null ? BigDecimal.ZERO : promaterialSettlementAmount).add(settlementAmount == null ? BigDecimal.ZERO : settlementAmount).add(proequipmentPurchaseAmount == null ? BigDecimal.ZERO : proequipmentPurchaseAmount);
    }

    private LocalDate getLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    private BigDecimal getSubcontractAmount(Long projectId) {
        BigDecimal ans = BigDecimal.ZERO;
        BigDecimal subcontractAmount = this.mapper.getSubcontractAmount(projectId);
        log.info("subcontractAmount:{}", (Object)subcontractAmount);
        ans = ans.add(subcontractAmount == null ? BigDecimal.ZERO : subcontractAmount);
        BigDecimal contractAmount = this.mapper.getContractAmount(projectId);
        log.info("contractAmount:{}", (Object)contractAmount);
        ans = ans.add(contractAmount == null ? BigDecimal.ZERO : contractAmount);
        BigDecimal prormatContract = this.mapper.getPrormatContract(projectId);
        log.info("prormatContract:{}", (Object)prormatContract);
        ans = ans.add(prormatContract == null ? BigDecimal.ZERO : prormatContract);
        BigDecimal rentContractAmount = this.mapper.getRentContractAmount(projectId);
        log.info("rentContractAmount:{}", (Object)rentContractAmount);
        ans = ans.add(rentContractAmount == null ? BigDecimal.ZERO : rentContractAmount);
        BigDecimal purchaseContractAmount = this.mapper.getPurchaseContractAmount(projectId);
        log.info("purchaseContractAmount:{}", (Object)purchaseContractAmount);
        ans = ans.add(purchaseContractAmount == null ? BigDecimal.ZERO : purchaseContractAmount);
        return ans;
    }

    @GetMapping(value={"/expenditureAnalysis"})
    public CommonResponse<Map<String, Object>> expenditureAnalysis(@RequestParam(value="id", required=false) Long projectId) {
        HashMap<String, Number> ans = new HashMap<String, Number>();
        BigDecimal expenditureContractAmount = null;
        if (projectId == null) {
            ans.put("expenditureContractAmount", 0);
            ans.put("settlementAmountSum", 0);
            ans.put("paymentRegisterAmount", 0);
            ans.put("oldjobRegistration", 0);
            ans.put("paymentAmount", 0);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", ans);
        }
        try {
            expenditureContractAmount = this.getSubcontractAmount(projectId);
            ans.put("expenditureContractAmount", expenditureContractAmount);
        }
        catch (Exception e) {
            log.error("\u3010\u652f\u51fa\u5408\u540c\u91d1\u989d\u3011\u9519\u8bef");
            ans.put("expenditureContractAmount", 0);
        }
        BigDecimal settlementAmountSum = null;
        try {
            settlementAmountSum = this.getAmountSum(projectId);
            ans.put("settlementAmountSum", settlementAmountSum);
        }
        catch (Exception e) {
            log.error("\u3010\u8ba1\u91cf/\u7ed3\u7b97\u91d1\u989d\u3011\u9519\u8bef");
            ans.put("settlementAmountSum", 0);
        }
        BigDecimal paymentRegisterAmount = this.mapper.getPaymentRegisterAmount(projectId);
        ans.put("paymentRegisterAmount", paymentRegisterAmount);
        try {
            BigDecimal oldjobRegistration = this.mapper.getOldjobRegistration(projectId);
            ans.put("oldjobRegistration", oldjobRegistration);
        }
        catch (Exception e) {
            log.error("\u3010\u5206\u5305\u7b7e\u8bc1\u91d1\u989d\u3011\u9519\u8bef");
            ans.put("oldjobRegistration", 0);
        }
        try {
            BigDecimal paymentAmount = this.mapper.getPaymentRegisterAmount(projectId);
            ans.put("paymentAmount", paymentAmount);
        }
        catch (Exception e) {
            log.error("\u3010\u4ed8\u6b3e\u91d1\u989d\u3011\u9519\u8bef");
            ans.put("paymentAmount", 0);
        }
        return CommonResponse.success((String)("\u67e5\u8be2\u6210\u529f:" + projectId), ans);
    }
}

