package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.bean.RegistrationEntity;
import com.ejianc.business.process.enums.UseFlagEnum;
import com.ejianc.business.process.mapper.ApplicationMapper;
import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.business.process.vo.ApplicationVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 零工申请实体
 *
 * @author generator
 */
@Service("applicationService")
public class ApplicationServiceImpl extends BaseServiceImpl<ApplicationMapper, ApplicationEntity> implements IApplicationService {

    // 劳务分包-零工申请，劳务分包-零工登记
    private static final String LAB_CHECK_PARAM_CODE = "P-34v45349";
    // 专业分包-零工申请，专业分包-零工登记
    private static final String PRO_CHECK_PARAM_NAME = "P-0lV6mY50";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IRegistrationService registrationService;

    @Override
    public ParamsCheckVO mnyCtrl(ApplicationVO applicationVO) {

        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();

        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        // 劳务分包合同
        if (0 == applicationVO.getContractType()) {
            //查询是否为零工合同，若是零工合同则不受参数控制
            ContractEntity contract = contractService.selectById(applicationVO.getContractId());
            if(!"laborSub-2".equals(contract.getContractCategoryProperty())) {
                billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_CHECK_PARAM_CODE, applicationVO.getOrgId());
            } else {
                logger.info("零工申请-【{}】所属合同-【{}】为零工合同，不进行参数控制！", JSONObject.toJSONString(applicationVO), JSONObject.toJSONString(contract));
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            }
        }
        // 专业分包合同
        if (1 == applicationVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_CHECK_PARAM_NAME, applicationVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            logger.info("获取控制参数配置失败！");
            throw new BusinessException("获取控制参数配置失败！");
        }

        List<BillParamVO> data = billParamByCode.getData();
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        for (BillParamVO billParamVO : data) {
            List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();

            // 控制规则值
            BigDecimal roleValue = billParamVO.getRoleValue();

            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }

            if (!"none".equals(paramsCheck.getWarnType())) {
                // 金额计算

                // 最新版本合同金额，最新的合同金额
                ContractEntity contract = contractService.selectById(applicationVO.getContractId());
                if (null == contract) {
                    logger.info("获取合同信息失败！");
                    throw new BusinessException("获取合同信息失败！");
                }
                // 合同金额
                BigDecimal contractTaxMny = contract.getContractTaxMny().multiply(roleValue.divide(BigDecimal.valueOf(100), 2, RoundingMode.HALF_UP));

                // 本次零工申请金额
                BigDecimal taxMny = applicationVO.getTaxMny();

                // 零工金额： 该合同所有【零工登记金额+零工申请未被零工登记引用金额+本次零工申请金额】
                BigDecimal totalTaxMny = BigDecimal.ZERO;

                // 零工登记金额
                QueryWrapper<RegistrationEntity> qw = new QueryWrapper<>();
                qw.eq("contract_id", applicationVO.getContractId());
                List<RegistrationEntity> res = registrationService.list(qw);
                if (CollectionUtils.isNotEmpty(res)) {
                    totalTaxMny = res.stream().map(RegistrationEntity::getTotalTaxMny).reduce(taxMny, BigDecimal::add);
                }

                // 零工申请未被零工登记引用金额
                QueryWrapper<ApplicationEntity> ae = new QueryWrapper<>();
                ae.eq("contract_id", applicationVO.getContractId());
                ae.eq("use_flag", UseFlagEnum.零工未登记.getCode());
                List<ApplicationEntity> aes = super.list(ae);
                if (CollectionUtils.isNotEmpty(aes)) {
                    totalTaxMny = aes.stream().map(ApplicationEntity::getTaxMny).reduce(totalTaxMny, BigDecimal::add);
                }


                // 控制金额
                if (totalTaxMny.compareTo(contractTaxMny) > 0) {
                    // 超结金额
                    BigDecimal overTaxMny = totalTaxMny.subtract(contractTaxMny);

                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("零工超合同");
                    paramsCheckDsVO.setWarnName("累计零工金额大于合同金额");

                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次零工金额：").append(taxMny.setScale(2, RoundingMode.DOWN)).append("，含本次累计零工金额：").append(totalTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，合同金额*").append(roleValue).append("%：").append(contractTaxMny.setScale(2, RoundingMode.DOWN)).append("。超结金额：").append(overTaxMny.setScale(2, RoundingMode.DOWN));

                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    checkDsVOS.add(paramsCheckDsVO);
                    paramsCheck.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheck);
                } else {
                    // 未超结金额
                    paramsCheck.setWarnType(paramsArray[0]);
                }
            }
        }

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for(ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }

        return paramsCheckVO;
    }
}
