package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.process.bean.RegistrationEntity;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;

@Controller
@RequestMapping("statistic")
public class StatisticController implements Serializable {

    @Autowired
    private IRegistrationService service;

    /**
     * 门户-零星用工内容
     * @param projectDepartmentId 项目部id
     * @param regionDate  用工日期
     * @return 业务笔数、暂估金额、占比
     */
    @RequestMapping(value = "/getRegistrationInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getRegistrationInfo(Long projectDepartmentId ,String regionDate){
        JSONObject jo = new JSONObject();
        ArrayList<Integer> list = new ArrayList<>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        if(projectDepartmentId != null ){
            QueryWrapper<RegistrationEntity> wrapper = new QueryWrapper<>();
            wrapper.select("count(id) AS businessCount , IFNULL(sum(total_tax_mny) , 0 ) AS totalTaxMny");
            wrapper.in("bill_state",list);
            wrapper.eq("org_id",projectDepartmentId);
            if(StringUtils.isNotBlank(regionDate)){
                String[] split = regionDate.split(",");
                wrapper.ge("region_date",split[0]);
                wrapper.le("region_date",split[1]);
            }
            RegistrationEntity one = service.getOne(wrapper);
            jo.put("businessCount",one.getBusinessCount());
            jo.put("totalTaxMny",one.getTotalTaxMny());
            return CommonResponse.success("查询数据成功！", jo);
        }
        return CommonResponse.error("查询数据失败，缺少项目部id！", jo);
    }

}
