/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.bean.AdjustDetailEntity;
import com.ejianc.business.process.bean.AdjustEntity;
import com.ejianc.business.process.service.IAdjustDetailService;
import com.ejianc.business.process.service.IAdjustService;
import com.ejianc.business.process.vo.AdjustDetailVO;
import com.ejianc.business.process.vo.AdjustVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"adjust"})
public class AdjustController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ADJUST_CODE";
    @Autowired
    private IAdjustService service;
    @Autowired
    private IAdjustDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AdjustVO> saveOrUpdate(@RequestBody AdjustVO saveOrUpdateVO) {
        AdjustVO vo = this.service.insertOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AdjustVO> queryDetail(Long id) {
        AdjustVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AdjustVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AdjustVO adjustVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AdjustVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("parentOrgName", "orgName", "billCode", "projectName", "contractName", "supplierName", "changeItems", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AdjustVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/referTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> referTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam String condition) {
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("parentOrgName", "orgName", "billCode", "projectName", "contractName", "supplierName", "changeItems", "employeeName"));
        JSONObject _con = JSONObject.parseObject((String)condition);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            if (_con.containsKey((Object)"contractId")) {
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)_con.getLong("contractId")));
            }
            if (_con.containsKey((Object)"useType")) {
                queryParam.getParams().put("useType", new Parameter("like", _con.get((Object)"useType")));
            }
            if (_con.containsKey((Object)"endDate")) {
                queryParam.getParams().put("signDate", new Parameter("le", _con.get((Object)"endDate")));
            }
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List dataList = this.service.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (AdjustEntity entity : dataList) {
            if (_con.containsKey((Object)"useType")) {
                QueryWrapper queryWrapper = new QueryWrapper();
                ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"pid", (Object)entity.getId())).eq((Object)"dr", (Object)0)).like(null != _con.get((Object)"useType"), (Object)"detail_use_type_name", _con.get((Object)"useType"))).apply("IFNULL(detail_finish_num,0)>IFNULL(sum_measure_num,0)", new Object[0]);
                List adjustDetailEntities = this.detailService.list((Wrapper)queryWrapper);
                if (CollectionUtils.isEmpty((Collection)adjustDetailEntities)) continue;
            }
            map = new HashMap();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getBillCode());
            map.put("code", entity.getBillCode());
            map.put("parentId", "000001");
            resultMapList.add(map);
        }
        if (CollectionUtils.isNotEmpty(resultMapList)) {
            map = new HashMap<String, Object>();
            map.put("id", "000001");
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", "000001");
            map.put("name", "\u5168\u90e8");
            map.put("code", "000001");
            map.put("parentId", null);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/refSubData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> refSubData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String condition, @RequestParam(required=false) String relyNode, @RequestParam(required=false) String searchText, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("changeType");
        fuzzyFields.add("detailName");
        fuzzyFields.add("detailWorkContent");
        fuzzyFields.add("detailMeasurementRules");
        fuzzyFields.add("detailUnit");
        Map param = queryParam.getParams();
        boolean queryAllFlag = false;
        if (StringUtils.isNotEmpty((String)relyCondition)) {
            String pid = relyCondition.split("=")[1];
            if (!"000001".equals(pid)) {
                param.put("pid", new Parameter("eq", (Object)pid));
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)condition) && condition.contains("useType")) {
                    param.put("detailUseTypeName", new Parameter("eq", JSONObject.parseObject((String)condition).get((Object)"useType")));
                }
            } else {
                queryAllFlag = true;
            }
        } else {
            queryAllFlag = true;
        }
        if (StringUtils.isNotBlank((String)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        if (queryAllFlag) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)condition) || !condition.contains("contractId")) {
                throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u4e0d\u6b63\u786e\uff01\u8bf7\u4f20\u5165contractId");
            }
            JSONObject conditionJson = JSONObject.parseObject((String)condition);
            Long contractId = conditionJson.getLong("contractId");
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(AdjustEntity::getContractId, (Object)contractId);
            if (conditionJson.containsKey((Object)"endDate")) {
                queryWrapper.le(AdjustEntity::getSignDate, conditionJson.get((Object)"endDate"));
            }
            if (conditionJson.containsKey((Object)"useType")) {
                queryWrapper.like(AdjustEntity::getUseType, conditionJson.get((Object)"useType"));
                param.put("detailUseTypeName", new Parameter("eq", JSONObject.parseObject((String)condition).get((Object)"useType")));
            }
            queryWrapper.in(AdjustEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            List list = this.service.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (AdjustEntity entity : list) {
                    ids.add(entity.getId());
                }
                param.put("pid", new Parameter("in", ids));
            } else {
                param.put("pid", new Parameter("eq", (Object)1L));
            }
        }
        if (condition.contains("useType")) {
            param.put("111", new Parameter("sql", (Object)"IFNULL(detail_finish_num,0)>IFNULL(sum_measure_num,0)"));
        }
        IPage pageData = this.detailService.queryPage(queryParam);
        Object voPage = null;
        JSONObject page = new JSONObject();
        page.put("records", (Object)pageData.getRecords());
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u5408\u540c\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("parentOrgName", "orgName", "billCode", "projectName", "contractName", "supplierName", "changeItems", "employeeName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("Adjust-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refAdjustData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AdjustVO>> refAdjustData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("adjustId")) {
                param.getParams().put("adjustId", new Parameter("eq", conditionMap.get("adjustId")));
            }
            if (null != conditionMap.get("contractId")) {
                param.getParams().put("contractId", new Parameter("eq", conditionMap.get("contractId")));
            }
            if (null != conditionMap.get("useType")) {
                param.getParams().put("useType", new Parameter("eq", conditionMap.get("useType")));
            }
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List voList = BeanMapper.mapList((Iterable)page.getRecords(), AdjustVO.class);
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper qw = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)qw.in(AdjustDetailEntity::getPid, ids)).eq(BaseEntity::getDr, (Object)0);
            List list = this.detailService.list((Wrapper)qw);
            Map<Long, List<AdjustDetailEntity>> detailListMap = list.stream().collect(Collectors.groupingBy(AdjustDetailEntity::getPid));
            for (AdjustVO adjustVO : voList) {
                adjustVO.setAdjustDetailList(BeanMapper.mapList((Iterable)detailListMap.get(adjustVO.getId()), AdjustDetailVO.class));
            }
        }
        pageData.setRecords(voList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"adjust-detail-import.xlsx", (String)"\u5206\u5305\u4ef7\u683c\u8c03\u6574\u4e0e\u589e\u8865-\u8be6\u60c5");
    }

    @RequestMapping(value={"/downloadOther"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadOther(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"adjustOther-detail-import.xlsx", (String)"\u5176\u4ed6\u5206\u5305\u660e\u7ec6\u8868");
    }

    @RequestMapping(value={"/downloadEquipment"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadEquipment(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"adjustEquipment-detail-import.xlsx", (String)"\u7279\u79cd\u8bbe\u5907\u660e\u7ec6\u8868");
    }

    @RequestMapping(value={"/importOtherData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importOtherData(HttpServletRequest request, HttpServletResponse response) {
        return this.service.importOtherData(request, response);
    }

    @RequestMapping(value={"/importEquipmentData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importEquipmentData(HttpServletRequest request, HttpServletResponse response) {
        return this.service.importEquipmentData(request, response);
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importData(Integer type, HttpServletRequest request, HttpServletResponse response) {
        return this.service.importData(type, request, response);
    }
}

