/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.equip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prosub.equip.service.IEquipUseApplyDetailService;
import com.ejianc.business.prosub.equip.service.IEquipUseApplyService;
import com.ejianc.business.prosub.equip.vo.EquipUseApplyDetailVO;
import com.ejianc.business.prosub.equip.vo.EquipUseApplyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"equipUseApplyDetail"})
public class EquipUseApplyDetailController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEquipUseApplyDetailService service;
    @Autowired
    private IEquipUseApplyService applyService;

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @PostMapping(value={"queryAllByApplyIds"})
    public CommonResponse<List<EquipUseApplyDetailVO>> queryAllByApplyIds(@RequestBody List<Long> applyIds) {
        List<EquipUseApplyVO> applyList = this.applyService.getAllByIds(applyIds);
        Map<Long, EquipUseApplyVO> applyMap = applyList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        List<EquipUseApplyDetailVO> detailList = this.service.queryAllByApplyIds(applyIds);
        for (EquipUseApplyDetailVO detail : detailList) {
            detail.setApplyCode(applyMap.get(detail.getApplyId()).getBillCode());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", detailList);
    }

    @RequestMapping(value={"/refEquipUseApplyDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<EquipUseApplyDetailVO>> refEquipUseApplyDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EquipUseApplyDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

