package com.ejianc.business.material.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.prosub.bean.ChangeClauseEntity;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.material.bean.MaterialApplyDetailEntity;
/**
 * 领料限额登记主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_material_apply")
public class MaterialApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 合同id
     */
    @TableField(value="contract_id")
    private Long contractId;

    /**
     * 合同编码
     */
    @TableField(value="contract_code")
    private String contractCode;

    /**
     * 合同名称
     */
    @TableField(value="contract_name")
    private String contractName;

    /**
     * 合同类型:分包合同-0,专业合同-1
     */
    @TableField(value="contract_type")
    private Integer contractType;

    /**
     * 项目Id
     */
    @TableField(value="project_id")
    private Long projectId;

    /**
     * 项目编号
     */
    @TableField(value="project_code")
    private String projectCode;

    /**
     * 项目名称
     */
    @TableField(value="project_name")
    private String projectName;

    /**
     * 供应商id
     */
    @TableField(value="supplier_id")
    private Long supplierId;

    /**
     * 供应商名称
     */
    @TableField(value="supplier_name")
    private String supplierName;

    /**
     * 乙方项目经理Id（乙方负责人id）
     */
    @TableField(value="supplier_project_manager_id")
    private Long supplierProjectManagerId;

    /**
     * 乙方项目经理名称（乙方负责人名称）
     */
    @TableField(value="supplier_project_manager_name")
    private String supplierProjectManagerName;

    /**
     * 经办人
     */
    @TableField(value="employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField(value="employee_name")
    private String employeeName;


    /**
     * 经办部门id
     */
    @TableField(value = "department_id")
    private Long departmentId;

    /**
     * 经办部门名称
     */
    @TableField(value = "department_name")
    private String departmentName;

    /**
     * 项目部id
     */
    @TableField(value="org_id")
    private Long orgId;

    /**
     * 项目部编码
     */
    @TableField(value="org_code")
    private String orgCode;

    /**
     * 项目部名称
     */
    @TableField(value="org_name")
    private String orgName;

    /**
     * 项目部所属组织Id
     */
    @TableField(value="parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部所属组织编码
     */
    @TableField(value="parent_org_code")
    private String parentOrgCode;

    /**
     * 项目部所属组织名称
     */
    @TableField(value="parent_org_name")
    private String parentOrgName;

    /**
     * 合同类别Id
     */
    @TableField(value="contract_category_id")
    private Long contractCategoryId;

    /**
     * 合同类别名称
     */
    @TableField(value="contract_category_name")
    private String contractCategoryName;

    /**
     * 单据编号
     */
    @TableField(value="bill_code")
    private String billCode;

    /**
     * 单据状态
     */
    @TableField(value="bill_state")
    private Integer billState;

    /**
     * 备注
     */
    @TableField(value="memo")
    private String memo;


    /**
     * 领料限额登记明细实体
     */
    @TableField(exist=false)
    @SubEntity(serviceName="materialApplyDetailService", pidName = "materialApplyId")
    private List<MaterialApplyDetailEntity> materialApplyDetailList = new ArrayList<>();

    

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getSupplierProjectManagerId() {
        return supplierProjectManagerId;
    }

    public void setSupplierProjectManagerId(Long supplierProjectManagerId) {
        this.supplierProjectManagerId = supplierProjectManagerId;
    }

    public String getSupplierProjectManagerName() {
        return supplierProjectManagerName;
    }

    public void setSupplierProjectManagerName(String supplierProjectManagerName) {
        this.supplierProjectManagerName = supplierProjectManagerName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<MaterialApplyDetailEntity> getMaterialApplyDetailList() {
        return materialApplyDetailList;
    }

    public void setMaterialApplyDetailList(List<MaterialApplyDetailEntity> materialApplyDetailList) {
        this.materialApplyDetailList = materialApplyDetailList;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
}
