package com.ejianc.business.control.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.control.bean.ControlEntity;
import com.ejianc.business.control.service.IControlService;
import com.ejianc.business.control.vo.*;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分包招标控制价审核表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("control")
public class ControlController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IExecutionApi executionApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IControlService service;

    @Autowired
    private IShareProsubApi shareProsubApi;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareLabsubApi shareLabsubApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ControlVO> saveOrUpdate(@RequestBody ControlVO saveOrUpdateVO) {
        ControlVO vo = service.saveOrUpdate(saveOrUpdateVO, false);

        if(CollectionUtils.isNotEmpty(vo.getControlDetailList())){
            List<ControlDetailVO> contractDetailVOS = vo.getControlDetailList().stream().sorted(Comparator.comparing(ControlDetailVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailTwoList())){
            List<ControlDetailTwoVO> contractDetailVOS = vo.getControlDetailTwoList().stream().sorted(Comparator.comparing(ControlDetailTwoVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailTwoList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailThreeList())){
            List<ControlDetailThreeVO> contractDetailVOS = vo.getControlDetailThreeList().stream().sorted(Comparator.comparing(ControlDetailThreeVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailThreeList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailFourList())){
            List<ControlDetailFourVO> contractDetailVOS = vo.getControlDetailFourList().stream().sorted(Comparator.comparing(ControlDetailFourVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailFourList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailFiveList())){
            List<ControlDetailFiveVO> contractDetailVOS = vo.getControlDetailFiveList().stream().sorted(Comparator.comparing(ControlDetailFiveVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailFiveList(contractDetailVOS);
        }

    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ControlVO> queryDetail(Long id) {
        ControlVO vo = service.queryDetail(id);
        if(CollectionUtils.isNotEmpty(vo.getControlDetailList())){
            List<ControlDetailVO> contractDetailVOS = vo.getControlDetailList().stream().sorted(Comparator.comparing(ControlDetailVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailTwoList())){
            List<ControlDetailTwoVO> contractDetailVOS = vo.getControlDetailTwoList().stream().sorted(Comparator.comparing(ControlDetailTwoVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailTwoList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailThreeList())){
            List<ControlDetailThreeVO> contractDetailVOS = vo.getControlDetailThreeList().stream().sorted(Comparator.comparing(ControlDetailThreeVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailThreeList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailFourList())){
            List<ControlDetailFourVO> contractDetailVOS = vo.getControlDetailFourList().stream().sorted(Comparator.comparing(ControlDetailFourVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailFourList(contractDetailVOS);
        }
        if(CollectionUtils.isNotEmpty(vo.getControlDetailFiveList())){
            List<ControlDetailFiveVO> contractDetailVOS = vo.getControlDetailFiveList().stream().sorted(Comparator.comparing(ControlDetailFiveVO::getSort))
                    .collect(Collectors.toList());
            vo.setControlDetailFiveList(contractDetailVOS);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 根据分类id查询分类的二级分类
     * @param id
     */
    @RequestMapping(value = "/queryTwoCategoryByIds", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ControlDetailFiveVO>> queryDetail(@RequestBody ControlVO controlVO) {
        List<Long> categorgIds = controlVO.getCategorgIds();
        Integer subType = controlVO.getSubType();
        List<ControlDetailFiveVO> detailFiveVOList = new ArrayList<>();
        if (subType == 1){
            CommonResponse<List<ProsubCategoryVO>> listCommonResponse = shareProsubApi.queryCategoryListByIds(categorgIds);
            if (!listCommonResponse.isSuccess()){
                throw new BusinessException("根据分包分类id查询分类失败");
            }
            List<ProsubCategoryVO> prosubCategoryVOS = listCommonResponse.getData();
            List<Long> secondLevelIds = prosubCategoryVOS.stream()
                    .map(vo -> vo.getInnerCode())
                    .filter(innerCode -> innerCode != null && !innerCode.isEmpty())
                    .map(innerCode -> {
                        // 按"|"分割字符串
                        String[] parts = innerCode.split("\\|");
                        // 确保至少有2个部分（即有二级分类）
                        if (parts.length >= 2) {
                            try {
                                return Long.parseLong(parts[1]);
                            } catch (NumberFormatException e) {
                                // 处理转换异常，返回null（后续会被过滤掉）
                                return null;
                            }
                        }
                        return null;
                    })
                    .filter(id -> id != null)  // 过滤掉null值
                    .distinct()  // 去重
                    .collect(Collectors.toList());
            CommonResponse<List<ProsubCategoryVO>> listTwoCommonResponse = shareProsubApi.queryCategoryListByIds(secondLevelIds);
            if (!listTwoCommonResponse.isSuccess()){
                throw new BusinessException("根据分包分类id查询分类失败");
            }
            List<ProsubCategoryVO> listTwoCommonResponseData = listTwoCommonResponse.getData();
            Map<Long, ProsubCategoryVO> twoCategoryMap = listTwoCommonResponseData.stream().collect(Collectors.toMap(ProsubCategoryVO::getId, Function.identity()));
            for (ProsubCategoryVO prosubCategoryVO : prosubCategoryVOS){
                String innerCode = prosubCategoryVO.getInnerCode();
                String[] parts = innerCode.split("\\|");
                long parseLong = Long.parseLong(parts[1]);

                ControlDetailFiveVO controlDetailFiveVO = new ControlDetailFiveVO();
                controlDetailFiveVO.setDocCategoryId(prosubCategoryVO.getId());
                if (twoCategoryMap.containsKey(parseLong)){
                    ProsubCategoryVO prosubCategoryVO1 = twoCategoryMap.get(parseLong);
                    controlDetailFiveVO.setCategoryTwoId(prosubCategoryVO1.getId());
                    controlDetailFiveVO.setCategoryTwoName(prosubCategoryVO1.getName());
                }
                detailFiveVOList.add(controlDetailFiveVO);
            }
        }
        //劳务
        if (subType == 2 || subType == 3 || subType == 4){
            CommonResponse<List<LabsubCategoryVO>> listCommonResponse = shareLabsubApi.getCategoryListByIds(categorgIds);
            if (!listCommonResponse.isSuccess()){
                throw new BusinessException("根据分包分类id查询分类失败");
            }
            List<LabsubCategoryVO> prosubCategoryVOS = listCommonResponse.getData();
            List<Long> secondLevelIds = prosubCategoryVOS.stream()
                    .map(vo -> vo.getInnerCode())
                    .filter(innerCode -> innerCode != null && !innerCode.isEmpty())
                    .map(innerCode -> {
                        // 按"|"分割字符串
                        String[] parts = innerCode.split("\\|");
                        // 确保至少有2个部分（即有二级分类）
                        if (parts.length >= 2) {
                            try {
                                return Long.parseLong(parts[1]);
                            } catch (NumberFormatException e) {
                                // 处理转换异常，返回null（后续会被过滤掉）
                                return null;
                            }
                        }
                        return null;
                    })
                    .filter(id -> id != null)  // 过滤掉null值
                    .distinct()  // 去重
                    .collect(Collectors.toList());
            CommonResponse<List<LabsubCategoryVO>> listTwoCommonResponse = shareLabsubApi.queryCategoryListByIds(secondLevelIds);
            if (!listTwoCommonResponse.isSuccess()){
                throw new BusinessException("根据分包分类id查询分类失败");
            }
            List<LabsubCategoryVO> listTwoCommonResponseData = listTwoCommonResponse.getData();
            Map<Long, LabsubCategoryVO> twoCategoryMap = listTwoCommonResponseData.stream().collect(Collectors.toMap(LabsubCategoryVO::getId, Function.identity()));
            for (LabsubCategoryVO prosubCategoryVO : prosubCategoryVOS){
                String innerCode = prosubCategoryVO.getInnerCode();
                String[] parts = innerCode.split("\\|");
                long parseLong = Long.parseLong(parts[1]);

                ControlDetailFiveVO controlDetailFiveVO = new ControlDetailFiveVO();
                controlDetailFiveVO.setDocCategoryId(prosubCategoryVO.getId());
                if (twoCategoryMap.containsKey(parseLong)){
                    LabsubCategoryVO prosubCategoryVO1 = twoCategoryMap.get(parseLong);
                    controlDetailFiveVO.setCategoryTwoId(prosubCategoryVO1.getId());
                    controlDetailFiveVO.setCategoryTwoName(prosubCategoryVO1.getCategoryName());
                }
                detailFiveVOList.add(controlDetailFiveVO);
            }
        }
        //    private Integer subType; // 分包类别, 1-专业分包,2-劳务分包

        //

        return CommonResponse.success("查询详情数据成功！",detailFiveVOList);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ControlVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ControlVO vo : vos) {
                //策划成本推送
                List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
                for (ControlVO contractVO : vos) {
                    ControlEntity controlEntity = service.selectById(contractVO.getId());
                    if(ControlVO.招标方式_项目招标.equals(controlEntity.getType())) {
                        //单据业务类型
                        ExecutionVO executionVO = service.targetCost(BeanMapper.map(controlEntity, ControlVO.class),
                                service.getLinkUrl(controlEntity.getId(), controlEntity.getType()), controlEntity.getSubType(),
                                ControlVO.招标方式_项目招标.equals(controlEntity.getType()) ? ProsubBillTypeEnum.分包招标控制价.getBillTypeCode()
                                        : ProsubBillTypeEnum.分包招标控制价框架协议.getBillTypeCode());
                        totalExecutionVOList.add(executionVO.getTotalVO());
                    }
                }
                if(CollectionUtils.isNotEmpty(totalExecutionVOList)) {
                    logger.info("策划成本删除数据"+ JSON.toJSONString(totalExecutionVOList));
                    CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                    if (!response.isSuccess()){
                        throw new BusinessException("策划成本推送失败,"+response.getMsg());
                    }
                }
            }
        }
        service.removeByIds(vos.stream().map(ControlVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ControlVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                throw new BusinessException("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ControlEntity> page = service.queryPage(param,false);
        IPage<ControlVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ControlVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ControlEntity> list = service.queryList(param);

        Map<String, Object> beans = new HashMap<String, Object>();
        List<ControlVO> listvo = BeanMapper.mapList(list, ControlVO.class);
        listvo.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            Integer bidType = vo.getBidType();
            if (bidType==null){
                vo.setBidName("");
            } else if (bidType.equals(1)){
                vo.setBidName("项目招标");
            } else if (bidType.equals(2)) {
                vo.setBidName("框架协议招标");
            }else{
                vo.setBidName("");
            }

            String changeStateName = null;
            if (vo.getChangeState().equals(0)){
                changeStateName = "未变更";
            }
            if (vo.getChangeState().equals(1)){
                changeStateName = "变更中";
            }
            if (vo.getChangeState().equals(2)){
                changeStateName = "已变更";
            }
            vo.setChangeStateName(changeStateName);
//            分包类别, 1-,2-劳务分包
            String subTypeName = null;
            if (vo.getSubType().equals(1)){
                subTypeName = "专业分包";
            }
            if (vo.getSubType().equals(2)){
                subTypeName = "劳务分包";
            }

            vo.setSubTypeName(subTypeName);
        });

        beans.put("records", listvo);

        ExcelExport.getInstance().export("Control-export.xlsx", beans, response);
    }

    /**
     * 单据管控-
     *
     * @return
     */
    @RequestMapping(value = "/checkParams", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody ControlVO vo) {
        ControlVO cv = service.saveOrUpdate(vo, true);

        //策划成本推送
        CommonResponse<ParamsCheckVO> response = new CommonResponse<>();
        if(ControlVO.招标方式_项目招标.equals(vo.getType())) {
            ExecutionVO executionVO = service.targetCost(cv, service.getLinkUrl(cv.getId(), cv.getType()),
                    cv.getSubType(), ControlVO.招标方式_项目招标.equals(cv.getType()) ? ProsubBillTypeEnum.分包招标控制价.getBillTypeCode()
                            : ProsubBillTypeEnum.分包招标控制价框架协议.getBillTypeCode());
            logger.error("分包招标控制价，策划成本数据校验参数：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue));
            response = executionApi.ctrlCheckVO(executionVO);
            logger.info("分包合同，策划成本数据校验结果：{}" , JSONObject.toJSONString(response));

            if (!response.isSuccess()) {
                logger.error("策划成本参数控制失败，返回信息-{}", response.getMsg());
                return response;
            }
        }

        ParamsCheckVO paramsCheckVO = service.checkParams(vo, response,null);
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refControlData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ControlVO>> refControlData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ControlEntity> page = service.queryPage(param,false);
        IPage<ControlVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ControlVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/download", method = RequestMethod.POST)
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "contract-import-subcontractPrice.xlsx", "分包明细表");
    }
    /**
     * 其他分包合同明明细导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadOther", method = RequestMethod.POST)
    @ResponseBody
    public void downloadOther(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "contractOther-import-subcontractPrice.xlsx", "其他分包明细表");
    }
    @RequestMapping(value = "/downloadEquipment", method = RequestMethod.POST)
    @ResponseBody
    public void downloadEquipment(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "contractEquipment-import-subcontractPrice.xlsx", "特种设备明细表");
    }
    @RequestMapping(value = "/import", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> importData(Long projectId,Integer type,String tabKey,HttpServletRequest request, HttpServletResponse response) {
        return service.importData(projectId,type,tabKey,request,response);
    }
    //框架协议导入
    @RequestMapping(value = "/importKjxyData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> importKjxyData(Integer type,HttpServletRequest request, HttpServletResponse response) {
        return service.importKjxyData(type,request,response);
    }
    @RequestMapping(value = "/importOtherData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> importOtherData(Integer type,String tabKey,HttpServletRequest request, HttpServletResponse response){
        return service.importOtherData(type,tabKey,request,response);
    }
    @RequestMapping(value = "/importEquipmentData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> importEquipmentData(Long projectId,Integer type,String tabKey,HttpServletRequest request, HttpServletResponse response) {
        return service.importEquipmentData(projectId,type,tabKey,request,response);
    }

    @RequestMapping(value = "/targetCostCtrl", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ControlVO controlVO, HttpServletRequest req) {
        ControlVO cv = service.saveOrUpdate(controlVO, true);
        CommonResponse<ParamsCheckVO> response = new CommonResponse<>();
        //策划成本推送
        if(ControlVO.招标方式_项目招标.equals(controlVO.getType())) {
            ExecutionVO executionVO = service.targetCost(cv, service.getLinkUrl(cv.getId(), cv.getType()),
                    cv.getSubType(), ControlVO.招标方式_项目招标.equals(cv.getType()) ? ProsubBillTypeEnum.分包招标控制价.getBillTypeCode()
                            : ProsubBillTypeEnum.分包招标控制价框架协议.getBillTypeCode());
            logger.error("分包招标控制价，策划成本数据校验参数：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue));
            response = executionApi.ctrlCheckVO(executionVO);
            logger.info("分包合同，策划成本数据校验结果：{}" , JSONObject.toJSONString(response));

            if (!response.isSuccess()) {
                logger.error("策划成本参数控制失败，返回信息-{}", response.getMsg());
                return response;
            }
        }

        ParamsCheckVO responseData = service.checkParams(controlVO, response,null);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        ControlEntity entity = service.selectById(id);
        ControlVO cv = BeanMapper.map(entity, ControlVO.class);
        CommonResponse<ParamsCheckVO> response = new CommonResponse<>();
        //策划成本推送
        if(ControlVO.招标方式_项目招标.equals(cv.getType())) {
            String linkUrl = service.getLinkUrl(cv.getId(), cv.getType());
            ExecutionVO executionVO = service.targetCost(cv,linkUrl,cv.getSubType(),
                    ControlVO.招标方式_项目招标.equals(cv.getType()) ? ProsubBillTypeEnum.分包招标控制价.getBillTypeCode()
                            : ProsubBillTypeEnum.分包招标控制价框架协议.getBillTypeCode());
            response = executionApi.ctrlCheckVO(executionVO);
            logger.info("分包合同，策划成本数据校验结果：{}" , JSONObject.toJSONString(response));

            if (!response.isSuccess()) {
                logger.error("策划成本参数控制失败，返回信息-{}", response.getMsg());
                return response;
            }
        }

        ParamsCheckVO responseData = service.checkParams(cv, response,null);
        return CommonResponse.success("参数校验成功！", responseData);
    }

}
